/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.ui.databinding;

import android.content.res.Resources;
import android.databinding.BindingAdapter;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.util.SparseArray;
import android.view.View;
import com.algolia.instantsearch.ui.databinding.RenderingHelper;

public class BindingHelper {
    private static final SparseArray<String> bindings = new SparseArray();

    @Deprecated
    @BindingAdapter(value={"attribute"})
    public static void bindAttribute(@NonNull View view, String attribute) {
        int id2 = view.getId();
        if (BindingHelper.notAlreadyMapped(id2)) {
            BindingHelper.mapAttribute(attribute, id2);
        }
    }

    @Deprecated
    @BindingAdapter(value={"attribute", "highlighted"})
    public static void bindHighlighted(@NonNull View view, String attribute, Boolean isHighlighted) {
        BindingHelper.bindAndHighlight(view, attribute, "@color/colorHighlighting");
    }

    @Deprecated
    @BindingAdapter(value={"attribute", "highlightingColor"})
    public static void bindHighlighted(@NonNull View view, String attribute, @NonNull String colorStr) {
        BindingHelper.bindAndHighlight(view, attribute, colorStr);
    }

    @Deprecated
    @BindingAdapter(value={"attribute", "highlighted", "highlightingColor"})
    public static void bindHighlighted(@NonNull View view, String attribute, Boolean isHighlighted, @NonNull String colorStr) {
        BindingHelper.bindAndHighlight(view, attribute, colorStr);
    }

    @Deprecated
    @BindingAdapter(value={"highlighted"})
    public static void bindInvalid(@NonNull View view, Boolean isHighlighted) {
        BindingHelper.throwBindingError(view, "You need an algolia:attribute to use algolia:highlighted.");
    }

    @Deprecated
    @BindingAdapter(value={"highlightingColor"})
    public static void bindInvalid(@NonNull View view, @ColorRes int color2) {
        BindingHelper.throwBindingError(view, "You need an algolia:attribute to use algolia:highlightingColor.");
    }

    @Deprecated
    @BindingAdapter(value={"highlighted", "highlightingColor"})
    public static void bindInvalid(@NonNull View view, Boolean isHighlighted, String colorStr) {
        BindingHelper.throwBindingError(view, "You need an algolia:attribute to use algolia:highlighted and algolia:highlighting.");
    }

    private static boolean notAlreadyMapped(int id2) {
        return bindings.get(id2) == null;
    }

    private static void mapAttribute(String attribute, int viewId) {
        if (viewId == -1) {
            throw new IllegalStateException(String.format("Your View for attribute %s is missing an android:id.", attribute));
        }
        bindings.put(viewId, (Object)attribute);
    }

    private static void throwBindingError(@NonNull View view, String message) {
        Resources r = view.getContext().getResources();
        int id2 = view.getId();
        String viewName = r.getResourcePackageName(id2) + ":" + r.getResourceTypeName(id2) + "/" + r.getResourceEntryName(id2);
        throw new IllegalStateException("Cannot bind " + viewName + ": " + message);
    }

    private static void bindAndHighlight(@NonNull View view, String attribute, @NonNull String colorStr) {
        if (BindingHelper.notAlreadyMapped(view.getId())) {
            int colorId;
            String[] split = colorStr.split("/");
            String identifierType = split[0];
            String colorName = split[1];
            switch (identifierType) {
                case "@android:color": {
                    colorId = Resources.getSystem().getIdentifier(colorName, "color", "android");
                    break;
                }
                case "@color": {
                    colorId = view.getResources().getIdentifier(colorName, "color", view.getContext().getPackageName());
                    break;
                }
                default: {
                    throw new IllegalStateException("algolia:highlightingColor should be an @android:color or @color resource.");
                }
            }
            BindingHelper.bindAttribute(view, attribute);
            RenderingHelper renderingHelper = RenderingHelper.getDefault();
            renderingHelper.addHighlight(attribute);
            renderingHelper.addColor(attribute, colorId);
        }
    }

    public static SparseArray<String> getBindings() {
        return bindings;
    }
}

