/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.ui.databinding;

import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RenderingHelper {
    static final String DEFAULT_COLOR = "@color/colorHighlighting";
    private static RenderingHelper defaultRenderingHelper;
    @NonNull
    private final Set<String> highlightedAttributes = new HashSet<String>();
    @NonNull
    private final Map<String, Integer> attributeColors = new HashMap<String, Integer>();

    public static RenderingHelper getDefault() {
        if (defaultRenderingHelper == null) {
            defaultRenderingHelper = new RenderingHelper();
        }
        return defaultRenderingHelper;
    }

    private RenderingHelper() {
    }

    @ColorRes
    public Integer getHighlightColor(String attribute) {
        try {
            return this.attributeColors.get(attribute);
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    public boolean shouldHighlight(String attribute) {
        return this.highlightedAttributes.contains(attribute);
    }

    Integer addColor(String attribute, @ColorRes int colorId) {
        return this.attributeColors.put(attribute, colorId);
    }

    boolean addHighlight(String attribute) {
        return this.highlightedAttributes.add(attribute);
    }
}

