/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.ui.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.algolia.instantsearch.R;
import com.algolia.instantsearch.events.FacetRefinementEvent;
import com.algolia.instantsearch.events.RefinementEvent;
import com.algolia.instantsearch.events.ResetEvent;
import com.algolia.instantsearch.helpers.Searcher;
import com.algolia.instantsearch.model.AlgoliaErrorListener;
import com.algolia.instantsearch.model.AlgoliaResultListener;
import com.algolia.instantsearch.model.AlgoliaSearcherListener;
import com.algolia.instantsearch.model.FacetValue;
import com.algolia.instantsearch.model.SearchResults;
import com.algolia.instantsearch.ui.views.filters.AlgoliaFilter;
import com.algolia.search.saas.AlgoliaException;
import com.algolia.search.saas.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.json.JSONArray;
import org.json.JSONException;

public class RefinementList
extends ListView
implements AlgoliaFilter,
AlgoliaResultListener,
AlgoliaErrorListener,
AlgoliaSearcherListener {
    public static final int OPERATION_OR = 0;
    public static final int OPERATION_AND = 1;
    public static final String SORT_COUNT_ASC = "count:asc";
    public static final String SORT_COUNT_DESC = "count:desc";
    public static final String SORT_ISREFINED = "isRefined";
    public static final String SORT_NAME_ASC = "name:asc";
    public static final String SORT_NAME_DESC = "name:desc";
    public static final String DEFAULT_SORT = "count:desc";
    public static final int DEFAULT_LIMIT = 10;
    @NonNull
    private final String attribute;
    private final int operation;
    @NonNull
    private final ArrayList<String> sortOrder;
    private int limit;
    @NonNull
    private final FacetAdapter adapter;
    private Searcher searcher;
    @NonNull
    private Comparator<? super FacetValue> sortComparator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefinementList(@NonNull Context context, AttributeSet attrs) {
        super(context, attrs);
        if (this.isInEditMode()) {
            this.operation = 1;
            this.sortOrder = null;
            this.sortComparator = null;
            this.attribute = null;
            this.adapter = null;
            return;
        }
        TypedArray styledAttributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.RefinementList, 0, 0);
        TypedArray viewAttributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.View, 0, 0);
        try {
            this.attribute = viewAttributes.getString(R.styleable.View_attribute);
            if (this.attribute == null) {
                throw new IllegalStateException("You need to specify the attribute to refine on with algolia:attribute.");
            }
            this.operation = styledAttributes.getInt(R.styleable.RefinementList_operation, 0);
            this.limit = styledAttributes.getInt(R.styleable.RefinementList_limit, 10);
            ArrayList<String> parsedSortOrder = RefinementList.parseSortOrder(styledAttributes.getString(R.styleable.RefinementList_sortBy));
            this.sortOrder = parsedSortOrder != null ? parsedSortOrder : new ArrayList<String>(Collections.singletonList("count:desc"));
        }
        finally {
            styledAttributes.recycle();
            viewAttributes.recycle();
        }
        this.adapter = new FacetAdapter(context);
        this.setAdapter((ListAdapter)this.adapter);
        this.sortComparator = new Comparator<FacetValue>(){

            @Override
            public int compare(@NonNull FacetValue lhs, @NonNull FacetValue rhs) {
                int comparisonValue = 0;
                Iterator iterator = RefinementList.this.sortOrder.iterator();
                while (iterator.hasNext()) {
                    String sortValue;
                    switch (sortValue = (String)iterator.next()) {
                        case "count:asc": {
                            comparisonValue = Integer.valueOf(lhs.count).compareTo(rhs.count);
                            break;
                        }
                        case "count:desc": {
                            comparisonValue = Integer.valueOf(rhs.count).compareTo(lhs.count);
                            break;
                        }
                        case "isRefined": {
                            comparisonValue = -Boolean.valueOf(RefinementList.this.adapter.hasActive(lhs.value)).compareTo(RefinementList.this.adapter.hasActive(rhs.value));
                            break;
                        }
                        case "name:asc": {
                            comparisonValue = lhs.value.compareTo(rhs.value);
                            break;
                        }
                        case "name:desc": {
                            comparisonValue = rhs.value.compareTo(lhs.value);
                        }
                    }
                    if (comparisonValue == 0) continue;
                    break;
                }
                return comparisonValue;
            }
        };
        EventBus.getDefault().register((Object)this);
    }

    @Override
    public void initWithSearcher(@NonNull Searcher searcher) {
        this.searcher = searcher;
    }

    @Override
    public void onResults(@NonNull SearchResults results, boolean isLoadingMore) {
        if (isLoadingMore) {
            return;
        }
        if (results.nbHits == 0) {
            this.adapter.resetFacetCounts();
            return;
        }
        Map<String, List<FacetValue>> facets = results.facets;
        List<FacetValue> refinementFacets = facets.get(this.attribute);
        if (refinementFacets != null && refinementFacets.size() > 0) {
            this.adapter.clear(false);
            this.adapter.addAll(refinementFacets);
            this.adapter.sort(this.sortComparator);
        } else {
            this.adapter.resetFacetCounts();
        }
        this.adapter.notifyDataSetChanged();
    }

    @Override
    public void onError(@NonNull Query query, @NonNull AlgoliaException error) {
    }

    @Subscribe
    public void onReset(ResetEvent event) {
        this.adapter.clear();
    }

    @Subscribe
    public void onRefinement(FacetRefinementEvent event) {
        if (event.attribute.equals(this.attribute) && (this.adapter.hasActive(event.value) && event.operation.equals((Object)RefinementEvent.Operation.REMOVE) || !this.adapter.hasActive(event.value) && event.operation.equals((Object)RefinementEvent.Operation.ADD))) {
            this.adapter.toggleFacetValue(event.value);
        }
    }

    public void setSortComparator(@NonNull Comparator<? super FacetValue> sortComparator) {
        this.sortComparator = sortComparator;
    }

    @Override
    @NonNull
    public String getAttribute() {
        return this.attribute;
    }

    public int getOperation() {
        return this.operation;
    }

    @Nullable
    static ArrayList<String> parseSortOrder(@Nullable String attribute) {
        if (attribute == null) {
            return null;
        }
        ArrayList<String> sortOrder = new ArrayList<String>();
        switch (attribute) {
            case "count:asc": 
            case "count:desc": 
            case "isRefined": 
            case "name:asc": 
            case "name:desc": {
                sortOrder.add(attribute);
                break;
            }
            default: {
                if (!attribute.startsWith("[")) {
                    throw new IllegalStateException(String.format("invalid sortBy value: %s is none of \"isRefined\"|\"count:asc\"|\"count:desc\"|\"name:asc\"|\"name:desc\".", attribute));
                }
                try {
                    JSONArray array = new JSONArray(attribute);
                    for (int i = 0; i < array.length(); ++i) {
                        String value = array.optString(i);
                        RefinementList.addSortOrderOrThrow(value, sortOrder);
                    }
                    break;
                }
                catch (JSONException e) {
                    throw new IllegalStateException(String.format("invalid sortBy value: %s is not a valid JSONArray.", attribute));
                }
            }
        }
        return sortOrder;
    }

    private static void addSortOrderOrThrow(@NonNull String value, @NonNull ArrayList<String> sortOrder) {
        switch (value) {
            case "count:asc": 
            case "count:desc": 
            case "isRefined": 
            case "name:asc": 
            case "name:desc": {
                sortOrder.add(value);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("invalid sortBy value: %s is none of \"isRefined\"|\"count:asc\"|\"count:desc\"|\"name:asc\"|\"name:desc\".", value));
            }
        }
    }

    private class FacetAdapter
    extends ArrayAdapter<FacetValue> {
        @NonNull
        private final List<FacetValue> facetValues;
        private final HashSet<String> activeFacets;

        FacetAdapter(Context context) {
            this(context, new ArrayList<FacetValue>());
        }

        private FacetAdapter(@NonNull Context context, List<FacetValue> facetValues) {
            super(context, -1, facetValues);
            this.activeFacets = new HashSet();
            this.facetValues = new ArrayList<FacetValue>(facetValues);
        }

        void clear(boolean clearActiveFacets) {
            super.clear();
            if (clearActiveFacets) {
                this.activeFacets.clear();
            }
            this.facetValues.clear();
        }

        public void clear() {
            this.clear(true);
        }

        public void add(FacetValue facetValue) {
            this.addFacet(facetValue);
        }

        public void addAll(@NonNull Collection<? extends FacetValue> items) {
            for (FacetValue facetValue : items) {
                this.addFacet(facetValue);
            }
        }

        public void remove(@Nullable FacetValue facet) {
            super.remove((Object)facet);
            this.facetValues.remove(facet);
            if (facet != null) {
                this.activeFacets.remove(facet.value);
            }
        }

        public void sort(@NonNull Comparator<? super FacetValue> comparator) {
            super.sort(comparator);
            Collections.sort(this.facetValues, comparator);
        }

        @SuppressLint(value={"DefaultLocale"})
        @NonNull
        public View getView(final int position, @Nullable View convertView, @NonNull ViewGroup parent) {
            FacetValue facet;
            if (convertView == null) {
                convertView = ((LayoutInflater)this.getContext().getSystemService("layout_inflater")).inflate(R.layout.refinement_row, parent, false);
            }
            if ((facet = (FacetValue)this.getItem(position)) == null) {
                throw new IllegalStateException(String.format("RefinementList has no item at position %d.", position));
            }
            final TextView nameView = (TextView)convertView.findViewById(R.id.refinementName);
            final TextView countView = (TextView)convertView.findViewById(R.id.refinementCount);
            nameView.setText((CharSequence)facet.value);
            countView.setText((CharSequence)String.valueOf(facet.count));
            this.updateFacetViews(facet, nameView, countView);
            convertView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    FacetValue facet = (FacetValue)RefinementList.this.adapter.getItem(position);
                    if (facet == null) {
                        throw new IllegalStateException(String.format("RefinementList has no item at position %d.", position));
                    }
                    FacetAdapter.this.toggleFacetValue(facet.value);
                    FacetAdapter.this.sort(RefinementList.this.sortComparator);
                    RefinementList.this.searcher.updateFacetRefinement(RefinementList.this.attribute, facet.value, FacetAdapter.this.hasActive(facet.value)).search();
                    FacetAdapter.this.updateFacetViews(facet, nameView, countView);
                }
            });
            return convertView;
        }

        private void toggleFacetValue(String facetValue) {
            boolean wasActive = this.hasActive(facetValue);
            if (wasActive) {
                this.activeFacets.remove(facetValue);
            } else {
                this.activeFacets.add(facetValue);
            }
        }

        private boolean hasActive(String facetName) {
            return this.activeFacets.contains(facetName);
        }

        void addFacet(FacetValue facetValue) {
            this.facetValues.add(facetValue);
            if (this.getCount() < RefinementList.this.limit) {
                super.add((Object)facetValue);
            }
        }

        private void updateFacetViews(@NonNull FacetValue facet, @NonNull TextView nameView, @NonNull TextView countView) {
            if (this.hasActive(facet.value)) {
                nameView.setPaintFlags(nameView.getPaintFlags() | 8);
                countView.setTypeface(null, 1);
            } else {
                nameView.setPaintFlags(nameView.getPaintFlags() & 0xFFFFFFF7);
                countView.setTypeface(null, 0);
            }
        }

        private void resetFacetCounts() {
            for (FacetValue facetValue : this.facetValues) {
                facetValue.count = 0;
            }
        }
    }
}

