/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.ui.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v7.widget.SearchView;
import android.util.AttributeSet;
import com.algolia.instantsearch.R;

public class SearchBox
extends SearchView {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchBox(@NonNull Context context, @NonNull AttributeSet attrs) {
        super(context, attrs);
        if (this.isInEditMode()) {
            return;
        }
        TypedArray styledAttributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SearchBox, 0, 0);
        try {
            this.setIconifiedByDefault(false);
            for (int i = 0; i < attrs.getAttributeCount(); ++i) {
                if (!"iconifiedByDefault".equals(attrs.getAttributeName(i))) continue;
                this.setIconifiedByDefault(attrs.getAttributeBooleanValue(i, false));
            }
            if (styledAttributes.getBoolean(R.styleable.SearchBox_autofocus, false)) {
                this.setFocusable(true);
                this.setIconified(false);
                this.requestFocusFromTouch();
            }
            this.setSubmitButtonEnabled(styledAttributes.getBoolean(R.styleable.SearchBox_submitButtonEnabled, false));
        }
        finally {
            styledAttributes.recycle();
        }
    }

    public void disableFullScreen() {
        if (Build.VERSION.SDK_INT >= 16) {
            this.setImeOptions(this.getImeOptions() | 0x10000000);
        }
    }

    public void enableFullScreen() {
        if (Build.VERSION.SDK_INT >= 16) {
            this.setImeOptions(this.getImeOptions() & 0x10000000);
        }
    }
}

