/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.ui.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import com.algolia.instantsearch.R;
import com.algolia.instantsearch.events.ResetEvent;
import com.algolia.instantsearch.model.AlgoliaErrorListener;
import com.algolia.instantsearch.model.AlgoliaResultListener;
import com.algolia.instantsearch.model.SearchResults;
import com.algolia.search.saas.AlgoliaException;
import com.algolia.search.saas.Query;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class Stats
extends AppCompatTextView
implements AlgoliaResultListener,
AlgoliaErrorListener {
    public static final String DEFAULT_TEMPLATE = "{nbHits} results found in {processingTimeMS} ms";
    private String resultTemplate;
    private String errorTemplate;
    private final boolean autoHide;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stats(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray styledAttributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.Stats, 0, 0);
        TypedArray widgetAttributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.Widget, 0, 0);
        try {
            this.resultTemplate = styledAttributes.getString(R.styleable.Stats_resultTemplate);
            if (this.resultTemplate == null) {
                this.resultTemplate = DEFAULT_TEMPLATE;
            }
            this.errorTemplate = styledAttributes.getString(R.styleable.Stats_errorTemplate);
            this.autoHide = widgetAttributes.getBoolean(R.styleable.Widget_autoHide, false);
        }
        finally {
            styledAttributes.recycle();
        }
        EventBus.getDefault().register((Object)this);
    }

    @Subscribe
    public void onReset(ResetEvent event) {
        this.setVisibility(8);
    }

    @Override
    public void onResults(@NonNull SearchResults results, boolean isLoadingMore) {
        if (this.autoHide && results.nbHits == 0) {
            this.setVisibility(8);
        } else {
            this.setVisibility(0);
            this.setText(this.applyTemplate(this.resultTemplate, results));
        }
    }

    private String applyTemplate(@NonNull String template, @NonNull SearchResults results) {
        return template.replace("{hitsPerPage}", String.valueOf(results.hitsPerPage)).replace("{processingTimeMS}", String.valueOf(results.processingTimeMS)).replace("{nbHits}", String.valueOf(results.nbHits)).replace("{nbPages}", String.valueOf(results.nbPages)).replace("{page}", String.valueOf(results.page)).replace("{query}", String.valueOf(results.query));
    }

    private String applyTemplate(@NonNull String template, @NonNull Query query, @NonNull AlgoliaException error) {
        return template.replace("{query}", String.valueOf(query.getQuery())).replace("{error}", String.valueOf(error.getLocalizedMessage()));
    }

    @Override
    public void onError(@NonNull Query query, @NonNull AlgoliaException error) {
        if (this.errorTemplate == null) {
            this.setVisibility(8);
        } else {
            this.setVisibility(0);
            this.setText(this.applyTemplate(this.errorTemplate, query, error));
        }
    }
}

