/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.ui.views.filters;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.v7.widget.AppCompatSpinner;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.SpinnerAdapter;
import com.algolia.instantsearch.R;
import com.algolia.instantsearch.events.NumericRefinementEvent;
import com.algolia.instantsearch.events.RefinementEvent;
import com.algolia.instantsearch.helpers.Searcher;
import com.algolia.instantsearch.model.AlgoliaErrorListener;
import com.algolia.instantsearch.model.AlgoliaResultListener;
import com.algolia.instantsearch.model.AlgoliaSearcherListener;
import com.algolia.instantsearch.model.NumericRefinement;
import com.algolia.instantsearch.model.SearchResults;
import com.algolia.instantsearch.ui.views.filters.AlgoliaFilter;
import com.algolia.instantsearch.ui.views.filters.Filters;
import com.algolia.search.saas.AlgoliaException;
import com.algolia.search.saas.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class NumericSelector
extends AppCompatSpinner
implements AlgoliaFilter,
AlgoliaResultListener,
AlgoliaErrorListener,
AlgoliaSearcherListener,
AdapterView.OnItemSelectedListener {
    public static final Double DEFAULT_VALUE = null;
    private boolean autoHide;
    private String attribute;
    private int operator;
    private String defaultLabel;
    private List<String> labels;
    private final List<Double> values;
    private NumericRefinement currentRefinement;
    private Searcher searcher;
    private final int spinnerItemLayout = 17367048;
    private final int spinnerDropdownItemLayout = 0x1090009;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NumericSelector(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setOnItemSelectedListener(this);
        EventBus.getDefault().register((Object)this);
        TypedArray viewStyledAttributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.View, 0, 0);
        TypedArray widgetStyledAttributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.Widget, 0, 0);
        TypedArray selectorStyleAttributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.NumericSelector, 0, 0);
        try {
            this.attribute = viewStyledAttributes.getString(R.styleable.View_attribute);
            Filters.checkAttributeName(this.attribute);
            this.autoHide = widgetStyledAttributes.getBoolean(R.styleable.Widget_autoHide, false);
            this.operator = selectorStyleAttributes.getInt(R.styleable.NumericSelector_operator, 2);
            this.defaultLabel = selectorStyleAttributes.getString(R.styleable.NumericSelector_defaultLabel);
            String labelString = selectorStyleAttributes.getString(R.styleable.NumericSelector_labels);
            String valueString = selectorStyleAttributes.getString(R.styleable.NumericSelector_values);
            if (labelString != null || valueString != null) {
                if (labelString == null || valueString == null) {
                    throw new IllegalStateException("You need to either specify both labels and values or none of those.");
                }
                String[] labelStrings = labelString.split(",");
                List<String> valuesStrList = Arrays.asList(valueString.split(","));
                if (this.defaultLabel == null) {
                    this.labels = new ArrayList<String>(Arrays.asList(labelStrings));
                    this.values = new ArrayList<Double>(valuesStrList.size());
                } else {
                    this.labels = new ArrayList<String>(labelStrings.length + 1);
                    this.labels.add(this.defaultLabel);
                    this.labels.addAll(Arrays.asList(labelStrings));
                    this.values = new ArrayList<Double>(valuesStrList.size() + 1);
                    this.values.add(DEFAULT_VALUE);
                }
                for (String value : valuesStrList) {
                    this.values.add(Double.parseDouble(value));
                }
                if (this.labels.size() != this.values.size()) {
                    throw new IllegalStateException("You need to specify as much labels as values (" + this.labels.size() + " label" + (this.labels.size() > 1 ? "s" : "") + " but " + this.values.size() + " value" + (this.labels.size() > 1 ? "s" : "") + ").");
                }
                ArrayAdapter adapter = new ArrayAdapter(context, 17367048, this.labels);
                adapter.setDropDownViewResource(0x1090009);
                this.setAdapter((SpinnerAdapter)adapter);
            } else {
                this.values = new ArrayList<Double>();
            }
        }
        finally {
            viewStyledAttributes.recycle();
            widgetStyledAttributes.recycle();
            selectorStyleAttributes.recycle();
        }
    }

    @Override
    @NonNull
    public String getAttribute() {
        return this.attribute;
    }

    @Override
    public void onResults(@NonNull SearchResults results, boolean isLoadingMore) {
        Filters.hideIfShouldHide((View)this, this.autoHide, results.nbHits == 0);
    }

    @Override
    public void onError(@NonNull Query query, @NonNull AlgoliaException error) {
        Filters.hideIfShouldHide((View)this, this.autoHide, true);
    }

    @Override
    public void initWithSearcher(@NonNull Searcher searcher) {
        this.searcher = searcher;
    }

    public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
        Double selectedValue = this.values.get(position);
        if (this.currentRefinement != null) {
            this.searcher.removeNumericRefinement(this.currentRefinement);
        }
        if (selectedValue != null) {
            this.currentRefinement = new NumericRefinement(this.attribute, this.operator, selectedValue);
            this.searcher.addNumericRefinement(this.currentRefinement);
        }
        this.searcher.search();
    }

    public void onNothingSelected(AdapterView<?> parent) {
    }

    public boolean isAutoHide() {
        return this.autoHide;
    }

    public void setAutoHide(boolean autoHide) {
        this.autoHide = autoHide;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
        this.updateRefinement(attribute, this.operator);
    }

    public int getOperator() {
        return this.operator;
    }

    public void setOperator(int operator) {
        this.operator = operator;
        this.updateRefinement(this.attribute, operator);
    }

    public void setDefaultLabel(String defaultLabel) {
        this.defaultLabel = defaultLabel;
        this.labels.remove(0);
        this.labels.add(0, defaultLabel);
        ((ArrayAdapter)this.getAdapter()).notifyDataSetChanged();
    }

    public void setLabels(List<String> labels) {
        if (labels.size() != this.labels.size()) {
            throw new IllegalArgumentException("You need to provide " + this.labels.size() + " labels.");
        }
        this.labels = labels;
        ((ArrayAdapter)this.getAdapter()).notifyDataSetChanged();
    }

    private void updateRefinement(String attribute, int operator) {
        if (this.currentRefinement != null) {
            this.searcher.removeNumericRefinement(this.currentRefinement);
            this.currentRefinement = new NumericRefinement(attribute, operator, this.currentRefinement.value);
            this.searcher.addNumericRefinement(this.currentRefinement);
            this.searcher.search();
        }
    }

    @Subscribe
    public void onRefinement(NumericRefinementEvent event) {
        if (event.refinement.attribute.equals(this.attribute) && event.refinement.operator == this.operator) {
            if (event.operation == RefinementEvent.Operation.REMOVE) {
                this.setSelection(0);
            } else {
                for (int i = 0; i < this.values.size(); ++i) {
                    Double valueI = this.values.get(i);
                    if (!event.refinement.value.equals(valueI)) continue;
                    this.setSelection(i);
                    break;
                }
            }
        }
    }
}

