/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.ui.views.filters;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.widget.CompoundButton;
import com.algolia.instantsearch.R;
import com.algolia.instantsearch.events.FacetRefinementEvent;
import com.algolia.instantsearch.events.RefinementEvent;
import com.algolia.instantsearch.model.SearchResults;
import com.algolia.instantsearch.ui.views.filters.AlgoliaFilter;
import com.algolia.instantsearch.ui.views.filters.Toggle;
import org.greenrobot.eventbus.Subscribe;

public class OneValueToggle
extends Toggle
implements AlgoliaFilter {
    private String value;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OneValueToggle(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray styledAttributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.OneValueToggle, 0, 0);
        try {
            this.value = styledAttributes.getString(R.styleable.OneValueToggle_value);
        }
        finally {
            styledAttributes.recycle();
        }
    }

    public void setValue(String newValue, @Nullable String newName) {
        if (this.isChecked()) {
            this.searcher.updateFacetRefinement(this.attribute, this.value, false).updateFacetRefinement(newName != null ? newName : this.attribute, newValue, true).search();
        }
        this.value = newValue;
        this.applyEventualNewAttribute(newName);
    }

    @Override
    public void updateRefinementWithNewName(String newName) {
        if (this.isChecked()) {
            this.searcher.removeFacetRefinement(this.attribute, this.value).addFacetRefinement(newName, this.value).search();
        }
    }

    @Override
    protected CompoundButton.OnCheckedChangeListener getOnCheckedChangeListener() {
        return new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                OneValueToggle.this.searcher.updateFacetRefinement(OneValueToggle.this.attribute, OneValueToggle.this.value, isChecked).search();
            }
        };
    }

    @Override
    protected String applyTemplates(@NonNull SearchResults results) {
        return this.template.replace("{name}", this.attribute).replace("{isRefined}", String.valueOf(this.isChecked())).replace("{value}", this.value);
    }

    @Subscribe
    public void onFacetRefinementEvent(FacetRefinementEvent event) {
        if (event.attribute.equals(this.attribute) && event.value.equals(this.value)) {
            this.setChecked(event.operation == RefinementEvent.Operation.ADD);
        }
    }
}

