/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.ui.views.filters;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.SwitchCompat;
import android.util.AttributeSet;
import android.view.View;
import android.widget.CompoundButton;
import com.algolia.instantsearch.R;
import com.algolia.instantsearch.helpers.Searcher;
import com.algolia.instantsearch.model.AlgoliaErrorListener;
import com.algolia.instantsearch.model.AlgoliaResultListener;
import com.algolia.instantsearch.model.AlgoliaSearcherListener;
import com.algolia.instantsearch.model.SearchResults;
import com.algolia.instantsearch.ui.views.filters.AlgoliaFilter;
import com.algolia.instantsearch.ui.views.filters.Filters;
import com.algolia.search.saas.AlgoliaException;
import com.algolia.search.saas.Query;
import org.greenrobot.eventbus.EventBus;

public abstract class Toggle
extends SwitchCompat
implements AlgoliaFilter,
AlgoliaResultListener,
AlgoliaErrorListener,
AlgoliaSearcherListener {
    private final EventBus bus;
    public String attribute;
    private boolean autoHide;
    String template;
    Searcher searcher;
    private boolean shouldHide;
    private SearchResults lastResults;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Toggle(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray viewStyledAttributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.View, 0, 0);
        TypedArray widgetStyledAttributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.Widget, 0, 0);
        TypedArray toggleStyledAttributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.Toggle, 0, 0);
        try {
            this.attribute = viewStyledAttributes.getString(R.styleable.View_attribute);
            Filters.checkAttributeName(this.attribute);
            this.template = toggleStyledAttributes.getString(R.styleable.Toggle_template);
            this.autoHide = widgetStyledAttributes.getBoolean(R.styleable.Widget_autoHide, false);
        }
        finally {
            widgetStyledAttributes.recycle();
            toggleStyledAttributes.recycle();
            viewStyledAttributes.recycle();
        }
        this.bus = EventBus.getDefault();
        this.bus.register((Object)this);
    }

    public final void setAttribute(@NonNull String newAttribute) {
        this.searcher.removeFacet(this.attribute).addFacet(newAttribute);
        this.updateRefinementWithNewName(newAttribute);
        this.attribute = newAttribute;
    }

    public final void setAutoHide(boolean autoHide) {
        this.autoHide = autoHide;
        Filters.hideIfShouldHide((View)this, autoHide, this.shouldHide);
    }

    public final void setTemplate(String template) {
        this.template = template;
        this.setText(this.applyTemplates(this.lastResults));
    }

    void applyEventualNewAttribute(@Nullable String newAttribute) {
        if (newAttribute != null) {
            this.searcher.removeFacet(this.attribute).addFacet(newAttribute);
            this.attribute = newAttribute;
        }
    }

    @Override
    @NonNull
    public final String getAttribute() {
        return this.attribute;
    }

    @Override
    public final void initWithSearcher(@NonNull Searcher searcher) {
        this.searcher = searcher;
        this.setOnCheckedChangeListener(this.getOnCheckedChangeListener());
        searcher.search();
    }

    @Override
    public final void onResults(@NonNull SearchResults results, boolean isLoadingMore) {
        this.shouldHide = results.nbHits == 0;
        Filters.hideIfShouldHide((View)this, this.autoHide, this.shouldHide);
        if (this.template != null) {
            this.setText(this.applyTemplates(results));
        }
        this.lastResults = results;
    }

    @Override
    public final void onError(@NonNull Query query, @NonNull AlgoliaException error) {
        Filters.hideIfShouldHide((View)this, this.autoHide, this.shouldHide);
    }

    protected abstract CompoundButton.OnCheckedChangeListener getOnCheckedChangeListener();

    protected abstract String applyTemplates(@NonNull SearchResults var1);

    protected abstract void updateRefinementWithNewName(String var1);
}

