/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.utils;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.algolia.instantsearch.R;

public class ItemClickSupport {
    private final RecyclerView mRecyclerView;
    @Nullable
    private OnItemClickListener mOnItemClickListener;
    @Nullable
    private final View.OnClickListener mOnClickListener = new View.OnClickListener(){

        public void onClick(@NonNull View v) {
            if (ItemClickSupport.this.mOnItemClickListener != null) {
                RecyclerView.ViewHolder holder = ItemClickSupport.this.mRecyclerView.getChildViewHolder(v);
                ItemClickSupport.this.mOnItemClickListener.onItemClick(ItemClickSupport.this.mRecyclerView, holder.getAdapterPosition(), v);
            }
        }
    };
    private OnItemLongClickListener mOnItemLongClickListener;
    @Nullable
    private final View.OnLongClickListener mOnLongClickListener = new View.OnLongClickListener(){

        public boolean onLongClick(@NonNull View v) {
            if (ItemClickSupport.this.mOnItemLongClickListener != null) {
                RecyclerView.ViewHolder holder = ItemClickSupport.this.mRecyclerView.getChildViewHolder(v);
                return ItemClickSupport.this.mOnItemLongClickListener.onItemLongClick(ItemClickSupport.this.mRecyclerView, holder.getAdapterPosition(), v);
            }
            return false;
        }
    };
    @Nullable
    private final RecyclerView.OnChildAttachStateChangeListener mAttachListener = new RecyclerView.OnChildAttachStateChangeListener(){

        public void onChildViewAttachedToWindow(@NonNull View view) {
            if (ItemClickSupport.this.mOnItemClickListener != null) {
                view.setOnClickListener(ItemClickSupport.this.mOnClickListener);
            }
            if (ItemClickSupport.this.mOnItemLongClickListener != null) {
                view.setOnLongClickListener(ItemClickSupport.this.mOnLongClickListener);
            }
        }

        public void onChildViewDetachedFromWindow(View view) {
        }
    };

    private ItemClickSupport(RecyclerView recyclerView) {
        this.mRecyclerView = recyclerView;
        this.mRecyclerView.setTag(R.id.item_click_support, (Object)this);
        this.mRecyclerView.addOnChildAttachStateChangeListener(this.mAttachListener);
    }

    @Deprecated
    @NonNull
    public static ItemClickSupport addTo(@NonNull RecyclerView view) {
        ItemClickSupport support = (ItemClickSupport)view.getTag(R.id.item_click_support);
        if (support == null) {
            support = new ItemClickSupport(view);
        }
        return support;
    }

    @NonNull
    public ItemClickSupport setOnItemClickListener(OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
        return this;
    }

    @NonNull
    public ItemClickSupport setOnItemLongClickListener(OnItemLongClickListener listener) {
        this.mOnItemLongClickListener = listener;
        return this;
    }

    private void detach(@NonNull RecyclerView view) {
        view.removeOnChildAttachStateChangeListener(this.mAttachListener);
        view.setTag(R.id.item_click_support, null);
    }

    public static interface OnItemLongClickListener {
        public boolean onItemLongClick(RecyclerView var1, int var2, View var3);
    }

    public static interface OnItemClickListener {
        public void onItemClick(RecyclerView var1, int var2, View var3);
    }
}

