/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.utils;

import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import com.algolia.instantsearch.utils.LayoutTraverser;
import java.util.ArrayList;
import java.util.List;

public final class LayoutViews {
    @NonNull
    public static List<View> findByTag(@NonNull ViewGroup root, Object tag) {
        FinderByTag finderByTag = new FinderByTag(tag);
        LayoutTraverser.build(finderByTag).traverse(root);
        return finderByTag.getViews();
    }

    @NonNull
    public static <T> List<T> findByClass(@NonNull View rootView, Class<T> classType) {
        ViewGroup viewGroup = (ViewGroup)rootView.findViewById(0x1020002);
        return viewGroup == null ? new ArrayList() : LayoutViews.findByClass(viewGroup, classType);
    }

    @NonNull
    public static <T> List<T> findByClass(@NonNull ViewGroup root, Class<T> classType) {
        FinderByClass finderByClass = new FinderByClass(classType);
        LayoutTraverser.build(finderByClass).traverse(root);
        return finderByClass.getViews();
    }

    private static class FinderByClass<T>
    implements LayoutTraverser.Processor {
        private final Class<T> type;
        @NonNull
        private final List<T> views;

        private FinderByClass(Class<T> type) {
            this.type = type;
            this.views = new ArrayList<T>();
        }

        @Override
        public void process(@NonNull View view) {
            if (this.type.isAssignableFrom(view.getClass())) {
                this.views.add(view);
            }
        }

        @NonNull
        public List<T> getViews() {
            return this.views;
        }
    }

    private static class FinderByTag
    implements LayoutTraverser.Processor {
        private final Object searchTag;
        private final List<View> views = new ArrayList<View>();

        private FinderByTag(Object searchTag) {
            this.searchTag = searchTag;
        }

        @Override
        public void process(@NonNull View view) {
            Object viewTag = view.getTag();
            if (viewTag != null && viewTag.equals(this.searchTag)) {
                this.views.add(view);
            }
        }

        @NonNull
        private List<View> getViews() {
            return this.views;
        }
    }
}

