/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.helpers;

import android.content.Context;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.ParcelableSpan;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.style.BackgroundColorSpan;
import android.text.style.StyleSpan;
import com.algolia.instantsearch.R;
import com.algolia.instantsearch.utils.JSONUtils;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class Highlighter {
    private static Highlighter defaultHighlighter;
    private final Pattern pattern;
    private final String prefixTag;
    private final String postfixTag;

    public static Highlighter getDefault() {
        if (defaultHighlighter == null) {
            defaultHighlighter = new Highlighter();
        }
        return defaultHighlighter;
    }

    public static void setDefault(@NonNull String regexp) {
        defaultHighlighter = new Highlighter(regexp);
    }

    public static void setDefault(String prefixTag, String postfixTag) {
        defaultHighlighter = new Highlighter(prefixTag, postfixTag);
    }

    public Highlighter(String regexp) {
        this.pattern = Pattern.compile(regexp);
        String[] splits = regexp.split("[()]");
        this.prefixTag = splits.length > 0 ? splits[0] : null;
        this.postfixTag = splits.length > 0 ? splits[splits.length - 1] : null;
    }

    public Highlighter(String prefixTag, String postfixTag) {
        this(prefixTag + "(.*?)" + postfixTag);
    }

    private Highlighter() {
        this("<em>", "</em>");
    }

    public Styler setInput(@NonNull JSONObject result, @NonNull String attribute) {
        return this.setInput(result, attribute, false);
    }

    public Styler setInput(@NonNull JSONObject result, @NonNull String attribute, boolean inverted) {
        return this.setInput(this.getHighlightedAttribute(result, attribute, inverted));
    }

    public Styler setInput(@NonNull String markupString) {
        return new Styler(markupString);
    }

    @Nullable
    public String inverseHighlight(@Nullable String text) {
        if (text == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        Matcher matcher = this.pattern.matcher(text);
        Pattern spaces = Pattern.compile("\\s");
        int posIn = 0;
        while (matcher.find()) {
            String match = matcher.group(1);
            String before = text.substring(posIn, matcher.start());
            posIn = matcher.end();
            Matcher spacesBefore = spaces.matcher(before);
            if (spacesBefore.matches()) {
                result.append(this.prefixTag);
                result.append(before);
                result.append(this.postfixTag);
            } else {
                result.append(this.prefixTag);
                result.append(before);
                result.append(this.postfixTag);
            }
            result.append(match);
        }
        result.append(this.prefixTag);
        String after = text.substring(posIn);
        result.append(after);
        result.append(this.postfixTag);
        return result.toString().replace(this.prefixTag + this.postfixTag, "");
    }

    private String getHighlightedAttribute(@NonNull JSONObject result, String attribute, boolean inverted) {
        JSONObject highlightResult = result.optJSONObject("_highlightResult");
        if (highlightResult != null) {
            HashMap<String, String> highlightAttribute = JSONUtils.getMapFromJSONPath(highlightResult, attribute);
            if (highlightAttribute != null) {
                String highlightedValue = highlightAttribute.get("value");
                if (inverted) {
                    highlightedValue = this.inverseHighlight(highlightedValue);
                }
                if (highlightedValue != null) {
                    return highlightedValue;
                }
            } else {
                JSONArray array = highlightResult.optJSONArray(attribute);
                if (array != null) {
                    StringBuilder builder = new StringBuilder();
                    int length = array.length();
                    for (int i = 0; i < length; ++i) {
                        String elementValue = ((JSONObject)array.opt(i)).optString("value");
                        builder.append(elementValue);
                        if (i + 1 >= length) continue;
                        builder.append(", ");
                    }
                    return builder.toString();
                }
            }
        }
        return JSONUtils.getStringFromJSONPath(result, attribute);
    }

    @ColorInt
    private int getColor(@NonNull Context context, @ColorRes int colorId) {
        int colorHighlighting = Build.VERSION.SDK_INT >= 23 ? context.getResources().getColor(colorId, context.getTheme()) : context.getResources().getColor(colorId);
        return colorHighlighting;
    }

    public class Renderer {
        @ColorInt
        private int color;
        @NonNull
        private final String markupString;
        private boolean bold;

        Renderer(String markupString, boolean bold, int colorInt) {
            this.markupString = markupString;
            this.bold = bold;
            this.color = colorInt;
        }

        @NonNull
        public Spannable render() {
            SpannableStringBuilder result = new SpannableStringBuilder();
            Matcher matcher = Highlighter.this.pattern.matcher(this.markupString);
            int posIn = 0;
            int posOut = 0;
            while (matcher.find()) {
                result.append((CharSequence)this.markupString.substring(posIn, matcher.start()));
                String highlightString = matcher.group(1);
                result.append((CharSequence)highlightString);
                ParcelableSpan span = (ParcelableSpan)(this.bold ? new StyleSpan(1) : (this.color != 0 ? new BackgroundColorSpan(this.color) : new StyleSpan(0)));
                result.setSpan((Object)span, posOut += matcher.start() - posIn, posOut + highlightString.length(), 33);
                posOut += highlightString.length();
                posIn = matcher.end();
            }
            result.append((CharSequence)this.markupString.substring(posIn));
            return result;
        }
    }

    public class Styler {
        @NonNull
        private String markupString;

        public Styler(String markupString) {
            this.markupString = markupString;
        }

        public Renderer setStyle(@NonNull Context context) {
            return this.setStyle(Highlighter.this.getColor(context, R.color.colorHighlighting));
        }

        public Renderer setStyle(@ColorRes int colorRes, Context context) {
            return this.setStyle(Highlighter.this.getColor(context, colorRes));
        }

        public Renderer setStyle(@ColorInt int colorInt) {
            return new Renderer(this.markupString, false, colorInt);
        }

        public Renderer setStyle(boolean isBold) {
            return new Renderer(this.markupString, true, 0);
        }
    }
}

