/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.helpers;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.app.SearchManager;
import android.content.Context;
import android.os.Build;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.appcompat.R;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.SearchView;
import com.algolia.instantsearch.R;
import com.algolia.instantsearch.events.ResetEvent;
import com.algolia.instantsearch.helpers.SearchProgressController;
import com.algolia.instantsearch.helpers.Searcher;
import com.algolia.instantsearch.model.AlgoliaErrorListener;
import com.algolia.instantsearch.model.AlgoliaResultsListener;
import com.algolia.instantsearch.model.AlgoliaSearcherListener;
import com.algolia.instantsearch.model.SearchBoxViewModel;
import com.algolia.instantsearch.ui.databinding.BindingHelper;
import com.algolia.instantsearch.ui.views.Hits;
import com.algolia.instantsearch.ui.views.RefinementList;
import com.algolia.instantsearch.ui.views.SearchBox;
import com.algolia.instantsearch.ui.views.filters.AlgoliaFilter;
import com.algolia.instantsearch.utils.LayoutViews;
import com.algolia.instantsearch.utils.SearchViewFacade;
import com.algolia.search.saas.Query;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.greenrobot.eventbus.EventBus;

public class InstantSearch {
    public static final int DELAY_PROGRESSBAR_NO_ANIMATIONS = 200;
    @Nullable
    private SearchBoxViewModel searchBoxViewModel;
    @NonNull
    private final Set<View> widgets = new HashSet<View>();
    @NonNull
    private final Set<AlgoliaResultsListener> resultListeners = new HashSet<AlgoliaResultsListener>();
    @NonNull
    private final Set<AlgoliaErrorListener> errorListeners = new HashSet<AlgoliaErrorListener>();
    @NonNull
    private final Searcher searcher;
    private Menu searchMenu;
    private int searchMenuId;
    private boolean showProgressBar;
    private SearchProgressController progressController;
    private boolean searchOnEmptyString = true;
    private int progressBarDelay = 0;

    public InstantSearch(@NonNull Activity activity, @NonNull Searcher searcher) {
        this(searcher);
        this.processActivity(activity);
    }

    public InstantSearch(@NonNull Activity activity, @NonNull Menu menu, @IdRes int menuItemId, @NonNull Searcher searcher) {
        this(searcher);
        this.registerSearchView(activity, menu, menuItemId);
        this.processActivity(activity);
    }

    public InstantSearch(@NonNull Activity activity, @NonNull Searcher searcher, @NonNull Fragment fragment) {
        this(searcher);
        this.registerSearchView(activity);
        this.processAllListeners(fragment.getView());
    }

    public InstantSearch(@NonNull Activity activity, @NonNull Searcher searcher, @NonNull android.support.v4.app.Fragment fragment) {
        this(searcher);
        this.registerSearchView(activity);
        this.processAllListeners(fragment.getView());
    }

    public InstantSearch(@NonNull View widget, @NonNull Searcher searcher) {
        this(searcher);
        this.registerWidget(widget);
    }

    public InstantSearch(@NonNull Searcher searcher) {
        this.searcher = searcher;
        this.enableProgressBar();
    }

    public void search() {
        this.searcher.search();
    }

    public void search(String query) {
        Query newQuery = this.searcher.getQuery().setQuery(query);
        this.searcher.setQuery(newQuery).search();
    }

    public void registerSearchView(@NonNull Activity activity, @NonNull Menu menu, int id2) {
        this.searchMenu = menu;
        this.searchMenuId = id2;
        SearchViewFacade actionView = new SearchViewFacade(menu, id2);
        this.registerSearchView(activity, actionView);
    }

    public void registerSearchView(@NonNull Activity activity, @NonNull SearchView searchView) {
        this.registerSearchView(activity, new SearchViewFacade(searchView));
    }

    public void registerSearchView(@NonNull Activity activity, @NonNull android.support.v7.widget.SearchView searchView) {
        this.registerSearchView(activity, new SearchViewFacade(searchView));
    }

    private void registerSearchView(@NonNull Activity activity) {
        View rootView = activity.getWindow().getDecorView().getRootView();
        SearchViewFacade searchView = InstantSearch.getSearchView(rootView);
        if (this.searchBoxViewModel == null && searchView != null) {
            this.searchBoxViewModel = new SearchBoxViewModel(searchView);
        }
        if (this.searchBoxViewModel != null) {
            this.registerSearchView(activity, this.searchBoxViewModel);
        }
    }

    private void registerSearchView(@NonNull Activity activity, @NonNull SearchViewFacade searchView) {
        this.registerSearchView(activity, new SearchBoxViewModel(searchView));
    }

    public void registerSearchView(@NonNull Activity activity, SearchBoxViewModel searchBoxViewModel) {
        this.searchBoxViewModel = searchBoxViewModel;
        SearchViewFacade searchView = searchBoxViewModel.getSearchView();
        SearchManager searchManager = (SearchManager)searchView.getContext().getSystemService("search");
        searchView.setSearchableInfo(searchManager.getSearchableInfo(activity.getComponentName()));
        searchView.setIconifiedByDefault(false);
        searchBoxViewModel.addListener(this);
    }

    public void reset() {
        this.searcher.reset();
        EventBus.getDefault().post((Object)new ResetEvent(this.searcher));
    }

    public void enableProgressBar(int delay) {
        this.enableProgressBar();
        this.progressBarDelay = delay;
    }

    public void enableProgressBar() {
        this.showProgressBar = true;
        if (this.searchBoxViewModel != null) {
            this.progressController = new SearchProgressController(new SearchProgressController.ProgressListener(){

                @Override
                public void onStart() {
                    InstantSearch.this.updateProgressBar(InstantSearch.this.searchBoxViewModel, true);
                }

                @Override
                public void onStop() {
                    InstantSearch.this.updateProgressBar(InstantSearch.this.searchBoxViewModel, false);
                }
            }, this.progressBarDelay);
        }
    }

    public void disableProgressBar() {
        this.updateProgressBar(this.searchBoxViewModel, false);
        this.progressController.disable();
    }

    public void registerFilters(@NonNull ViewGroup rootView) {
        List<AlgoliaFilter> filterViews = LayoutViews.findByClass(rootView, AlgoliaFilter.class);
        if (filterViews.isEmpty()) {
            throw new IllegalStateException(String.format("No AlgoliaFilter was found in view %s.", rootView));
        }
        this.registerFilters(filterViews);
        this.processAllListeners((View)rootView);
    }

    public void registerFilters(List<AlgoliaFilter> filters) {
        for (AlgoliaFilter filter : filters) {
            this.searcher.addFacet(filter.getAttribute());
        }
    }

    public void setSearchOnEmptyString(boolean searchOnEmptyString) {
        this.searchOnEmptyString = searchOnEmptyString;
    }

    public boolean hasSearchOnEmptyString() {
        return this.searchOnEmptyString;
    }

    private void processActivity(@NonNull Activity activity) {
        this.registerSearchView(activity);
        List<String> refinementAttributes = this.processAllListeners(activity.getWindow().getDecorView().getRootView());
        String[] facets = refinementAttributes.toArray(new String[refinementAttributes.size()]);
        if (facets.length > 0) {
            this.searcher.addFacet(facets);
        }
    }

    public void registerWidget(View widget) {
        Object listener;
        this.prepareWidget(widget);
        if (widget instanceof AlgoliaResultsListener) {
            listener = (AlgoliaResultsListener)widget;
            if (!this.resultListeners.contains(listener)) {
                this.resultListeners.add((AlgoliaResultsListener)listener);
            }
            this.searcher.registerResultListener((AlgoliaResultsListener)listener);
        }
        if (widget instanceof AlgoliaErrorListener) {
            listener = (AlgoliaErrorListener)widget;
            if (!this.errorListeners.contains(listener)) {
                this.errorListeners.add((AlgoliaErrorListener)listener);
            }
            this.searcher.registerErrorListener((AlgoliaErrorListener)listener);
        }
        if (widget instanceof AlgoliaSearcherListener) {
            listener = (AlgoliaSearcherListener)widget;
            listener.initWithSearcher(this.searcher);
        }
    }

    private List<String> processAllListeners(View rootView) {
        ArrayList<String> refinementAttributes = new ArrayList<String>();
        List<AlgoliaResultsListener> resultListeners = LayoutViews.findByClass((ViewGroup)rootView, AlgoliaResultsListener.class);
        if (resultListeners.isEmpty()) {
            throw new IllegalStateException("You need to add at least one AlgoliaResultsListener.");
        }
        for (AlgoliaResultsListener algoliaResultsListener : resultListeners) {
            String variant;
            if (this.resultListeners.contains(algoliaResultsListener) || (variant = BindingHelper.getVariantForView((View)algoliaResultsListener)) != null && !this.searcher.variant.equals(variant)) continue;
            this.resultListeners.add(algoliaResultsListener);
            this.searcher.registerResultListener(algoliaResultsListener);
            this.prepareWidget(algoliaResultsListener, refinementAttributes);
        }
        List<AlgoliaErrorListener> errorListeners = LayoutViews.findByClass((ViewGroup)rootView, AlgoliaErrorListener.class);
        for (AlgoliaErrorListener listener : errorListeners) {
            String variant;
            if (!this.errorListeners.contains(listener) && ((variant = BindingHelper.getVariantForView((View)listener)) == null || this.searcher.variant.equals(variant))) {
                this.errorListeners.add(listener);
            }
            this.searcher.registerErrorListener(listener);
            this.prepareWidget(listener, refinementAttributes);
        }
        List<AlgoliaSearcherListener> list = LayoutViews.findByClass((ViewGroup)rootView, AlgoliaSearcherListener.class);
        for (AlgoliaSearcherListener listener : list) {
            String variant = BindingHelper.getVariantForView((View)listener);
            if (variant != null && !this.searcher.variant.equals(variant)) continue;
            listener.initWithSearcher(this.searcher);
            this.prepareWidget(listener, refinementAttributes);
        }
        return refinementAttributes;
    }

    private void prepareWidget(Object listener) {
        this.prepareWidget(listener, null);
    }

    private void prepareWidget(Object listener, @Nullable List<String> refinementAttributes) {
        if (listener instanceof View) {
            this.prepareWidget((View)listener, refinementAttributes);
        }
    }

    private void prepareWidget(View widget, @Nullable List<String> refinementAttributes) {
        if (!this.widgets.contains(widget)) {
            this.widgets.add(widget);
            if (widget instanceof Hits) {
                ((Hits)widget).setEmptyView(InstantSearch.getEmptyView(widget.getRootView()));
                int itemLayoutId = ((Hits)widget).getLayoutId();
                if (itemLayoutId == 0) {
                    throw new IllegalStateException("To use the Hits widget, you need to specify an item layout with algolia:itemLayout.");
                }
            } else if (widget instanceof RefinementList) {
                this.searcher.addFacetRefinement(((RefinementList)widget).getAttribute(), null, ((RefinementList)widget).getOperation() == 0);
                if (refinementAttributes != null) {
                    refinementAttributes.add(((RefinementList)widget).getAttribute());
                }
            } else if (widget instanceof ListView) {
                ((ListView)widget).setEmptyView(InstantSearch.getEmptyView(widget.getRootView()));
            }
        }
    }

    @SuppressLint(value={"InflateParams"})
    private void updateProgressBar(@Nullable SearchBoxViewModel searchBoxViewModel, boolean showProgress) {
        if (!this.showProgressBar) {
            return;
        }
        if (searchBoxViewModel == null) {
            this.searchBoxViewModel = new SearchBoxViewModel(new SearchViewFacade(this.searchMenu, this.searchMenuId));
        }
        if (this.searchBoxViewModel != null) {
            int searchPlateId;
            SearchViewFacade searchView = this.searchBoxViewModel.getSearchView();
            LinearLayout searchPlate = (LinearLayout)searchView.findViewById(searchPlateId = searchView.getContext().getResources().getIdentifier("android:id/search_plate", null, null));
            if (searchPlate == null && (searchPlate = (LinearLayout)searchView.findViewById(R.id.search_plate)) == null) {
                Log.e((String)"Algolia|InstantSearch", (String)"Could not find a view with id @id/search_plate in SearchView.");
                return;
            }
            View progressBarView = searchPlate.findViewById(R.id.search_progress_bar);
            if (progressBarView != null) {
                if (Build.VERSION.SDK_INT >= 14) {
                    progressBarView.animate().setDuration(200L).alpha(showProgress ? 1.0f : 0.0f).start();
                } else {
                    progressBarView.setVisibility(showProgress ? 0 : 8);
                }
            } else if (showProgress) {
                searchPlate.setGravity(17);
                searchPlate.addView(LayoutInflater.from((Context)searchView.getContext()).inflate(R.layout.loading_icon, null), 1);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static SearchViewFacade getSearchView(@NonNull View rootView) {
        SearchViewFacade facade = null;
        List<SearchBox> searchBoxes = LayoutViews.findByClass(rootView, SearchBox.class);
        if (!searchBoxes.isEmpty()) {
            if (searchBoxes.size() != 1) throw new IllegalStateException("You cannot have more than one SearchBox.");
            return new SearchViewFacade(searchBoxes.get(0));
        }
        List<SearchView> searchViews = LayoutViews.findByClass(rootView, SearchView.class);
        View searchBox = rootView.findViewById(R.id.searchBox);
        if (searchViews.isEmpty()) {
            List<android.support.v7.widget.SearchView> supportViews = LayoutViews.findByClass(rootView, android.support.v7.widget.SearchView.class);
            if (!supportViews.isEmpty()) {
                if (supportViews.isEmpty()) return new SearchViewFacade(supportViews.get(0));
                SearchView labeledSearchView = (SearchView)searchBox;
                if (labeledSearchView != null) return new SearchViewFacade((SearchView)searchBox);
                throw new IllegalStateException("If you have several SearchViews, you need to identify the Algolia one with @id/searchBox.");
            }
        } else {
            if (searchViews.isEmpty()) return new SearchViewFacade(searchViews.get(0));
            SearchView labeledSearchView = (SearchView)searchBox;
            if (labeledSearchView != null) return new SearchViewFacade(labeledSearchView);
            throw new IllegalStateException("If you have several SearchViews, you need to identify the Algolia one with @id/searchBox.");
        }
        Log.e((String)"Algolia|InstantSearch", (String)"No SearchBox or SearchView was found in your activity.");
        return facade;
    }

    @Nullable
    private static View getEmptyView(@Nullable View rootView) {
        if (rootView == null) {
            throw new RuntimeException("A null rootView was passed to getEmptyView, but Hits/RefinementList require one.");
        }
        return rootView.findViewById(16908292);
    }
}

