/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.helpers;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.algolia.instantsearch.helpers.Highlighter;
import com.algolia.instantsearch.model.SearchResults;
import com.algolia.search.saas.AlgoliaException;
import com.algolia.search.saas.Index;
import com.algolia.search.saas.Query;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class QuerySuggestionsContentProvider
extends ContentProvider {
    public static final String[] COLUMN_NAMES = new String[]{"_id", "suggest_text_1", "suggest_intent_data"};
    private Index index;
    private boolean shouldReturnHighlightResult;

    protected abstract Index initIndex();

    protected abstract int getLimit();

    protected boolean shouldReturnHighlightResult() {
        return false;
    }

    public boolean onCreate() {
        this.index = this.initIndex();
        this.shouldReturnHighlightResult = this.shouldReturnHighlightResult();
        return true;
    }

    @Nullable
    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        MatrixCursor cursor = new MatrixCursor(COLUMN_NAMES);
        String query = uri.getLastPathSegment().toLowerCase();
        try {
            SearchResults results = new SearchResults(this.index.searchSync(new Query(query).setHitsPerPage(Integer.valueOf(this.getLimit())).setAttributesToHighlight(new String[]{"query"})));
            for (int i = 0; i < results.hits.length(); ++i) {
                String suggestion;
                JSONObject hit = results.hits.getJSONObject(i);
                String displaySuggestion = suggestion = hit.getString("query");
                if (suggestion.equalsIgnoreCase(query)) continue;
                if (this.shouldReturnHighlightResult) {
                    String highlightResult = hit.getJSONObject("_highlightResult").getJSONObject("query").getString("value");
                    displaySuggestion = Highlighter.getDefault().inverseHighlight(highlightResult).replace("<em>", "<b>").replace("</em>", "</b>");
                }
                cursor.addRow(new Object[]{hit.getString("objectID").hashCode(), displaySuggestion, suggestion});
            }
            return cursor;
        }
        catch (AlgoliaException e) {
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public String getType(@NonNull Uri uri) {
        return null;
    }

    @Nullable
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues values) {
        return null;
    }

    public int delete(@NonNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }

    public int update(@NonNull Uri uri, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        return 0;
    }
}

