/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.helpers;

import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.util.SparseArray;
import com.algolia.instantsearch.events.CancelEvent;
import com.algolia.instantsearch.events.ErrorEvent;
import com.algolia.instantsearch.events.FacetRefinementEvent;
import com.algolia.instantsearch.events.NumericRefinementEvent;
import com.algolia.instantsearch.events.QueryTextChangeEvent;
import com.algolia.instantsearch.events.RefinementEvent;
import com.algolia.instantsearch.events.ResultEvent;
import com.algolia.instantsearch.events.SearchEvent;
import com.algolia.instantsearch.model.AlgoliaErrorListener;
import com.algolia.instantsearch.model.AlgoliaResultsListener;
import com.algolia.instantsearch.model.FacetStat;
import com.algolia.instantsearch.model.NumericRefinement;
import com.algolia.instantsearch.model.SearchResults;
import com.algolia.search.saas.AbstractClient;
import com.algolia.search.saas.AlgoliaException;
import com.algolia.search.saas.Client;
import com.algolia.search.saas.CompletionHandler;
import com.algolia.search.saas.Index;
import com.algolia.search.saas.Query;
import com.algolia.search.saas.Request;
import com.algolia.search.saas.Searchable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.greenrobot.eventbus.EventBus;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Searcher {
    private static Map<String, Searcher> instances = new HashMap<String, Searcher>();
    private Searchable searchable;
    private final Client client;
    private Query query;
    public final String variant;
    private final List<AlgoliaResultsListener> resultListeners = new ArrayList<AlgoliaResultsListener>();
    private final List<AlgoliaErrorListener> errorListeners = new ArrayList<AlgoliaErrorListener>();
    private static int lastRequestId;
    private int lastResponseId;
    private int lastRequestPage;
    private int lastResponsePage;
    private boolean endReached;
    private final List<String> disjunctiveFacets = new ArrayList<String>();
    private final Map<String, List<String>> refinementMap = new HashMap<String, List<String>>();
    private final Map<String, SparseArray<NumericRefinement>> numericRefinements = new HashMap<String, SparseArray<NumericRefinement>>();
    private final Map<String, Boolean> booleanFilterMap = new HashMap<String, Boolean>();
    private final List<String> facets = new ArrayList<String>();
    private final Map<String, FacetStat> facetStats = new HashMap<String, FacetStat>();
    private final HashMap<String, Integer> facetRequestCount = new HashMap();
    private final SparseArray<Request> pendingRequests = new SparseArray();

    public static Searcher get() {
        return instances.get(instances.keySet().iterator().next());
    }

    public static Searcher get(String variant) {
        Searcher searcher = instances.get(variant);
        if (searcher == null) {
            throw new IllegalStateException("You cannot use Searcher#get before having called Searcher#create at least once.");
        }
        return searcher;
    }

    public static Searcher create(@NonNull String appId, @NonNull String apiKey, @NonNull String indexName) {
        return Searcher.create((Searchable)new Client(appId, apiKey).getIndex(indexName), indexName);
    }

    public static Searcher create(@NonNull String appId, @NonNull String apiKey, @NonNull String indexName, @NonNull String variant) {
        return Searcher.create((Searchable)new Client(appId, apiKey).getIndex(indexName), variant);
    }

    public static Searcher create(@NonNull Searchable searchable) {
        String key = searchable.toString();
        Searcher instance = instances.get(key);
        if (instance != null) {
            throw new IllegalStateException("There is already a Searcher for index " + key + ", you must specify a variant.");
        }
        instance = new Searcher(searchable, key);
        instances.put(key, instance);
        return instance;
    }

    public static Searcher create(@NonNull Searchable index, @NonNull String variant) {
        Searcher instance = instances.get(variant);
        if (instance == null || instance.getSearchable() != index) {
            instance = new Searcher(index, variant);
            instances.put(variant, instance);
        }
        return instance;
    }

    private Searcher(@NonNull Searchable searchable, @NonNull String variant) {
        this.searchable = searchable;
        this.variant = variant;
        this.query = new Query();
        if (searchable instanceof Index) {
            this.client = ((Index)searchable).getClient();
            AbstractClient.LibraryVersion version = new AbstractClient.LibraryVersion("InstantSearch Android", String.valueOf("1.8.2"));
            if (!Arrays.asList(this.client.getUserAgents()).contains(version)) {
                this.client.addUserAgent(version);
            }
        } else {
            this.client = null;
        }
    }

    public static void destroyAll() {
        instances.clear();
    }

    @NonNull
    public Searcher search() {
        return this.search(null, null);
    }

    @NonNull
    public Searcher search(@Nullable String queryString) {
        return this.search(queryString, null);
    }

    @NonNull
    public Searcher search(@Nullable Intent intent) {
        String query = null;
        Intent origin = null;
        if (intent != null && "android.intent.action.SEARCH".equals(intent.getAction())) {
            query = intent.hasExtra("query") ? intent.getStringExtra("query") : intent.getDataString();
            origin = intent;
        }
        return this.search(query, origin);
    }

    @NonNull
    public Searcher search(@Nullable String queryString, @Nullable Object origin) {
        if (queryString != null) {
            this.query.setQuery(queryString);
            EventBus.getDefault().post((Object)new QueryTextChangeEvent(queryString, origin == null ? this : origin));
        }
        this.endReached = false;
        this.lastRequestPage = 0;
        this.lastResponsePage = -1;
        final int currentRequestId = ++lastRequestId;
        CompletionHandler searchHandler = new CompletionHandler(){

            public void requestCompleted(@Nullable JSONObject content, @Nullable AlgoliaException error) {
                Searcher.this.pendingRequests.remove(currentRequestId);
                for (int i = 0; i < Searcher.this.pendingRequests.size(); ++i) {
                    int reqId = Searcher.this.pendingRequests.keyAt(i);
                    Request request = (Request)Searcher.this.pendingRequests.valueAt(i);
                    if (reqId >= currentRequestId) continue;
                    Searcher.this.cancelRequest(request, reqId);
                }
                if (currentRequestId <= Searcher.this.lastResponseId) {
                    Log.e((String)"Algolia|Searcher", (String)("We already displayed results for request " + Searcher.this.lastResponseId + ", current request (" + currentRequestId + ") should have been canceled"));
                }
                if (content == null || !Searcher.hasHits(content)) {
                    Searcher.this.endReached = true;
                } else {
                    Searcher.this.checkIfLastPage(content);
                }
                Searcher.this.lastResponseId = currentRequestId;
                Searcher.this.lastResponsePage = 0;
                if (error != null) {
                    Searcher.this.postError(error, currentRequestId);
                } else if (content == null) {
                    Log.e((String)"Algolia|Searcher", (String)"content is null but error too.");
                } else {
                    EventBus.getDefault().post((Object)new ResultEvent(Searcher.this, content, Searcher.this.query, currentRequestId));
                    Searcher.this.updateListeners(content, false);
                    Searcher.this.updateFacetStats(content);
                }
            }
        };
        Request searchRequest = this.triggerSearch(searchHandler);
        EventBus.getDefault().post((Object)new SearchEvent(this, this.query, currentRequestId));
        this.pendingRequests.put(currentRequestId, (Object)searchRequest);
        return this;
    }

    @NonNull
    public Searcher forwardBackendSearchResult(@NonNull JSONObject response) {
        if (!Searcher.hasHits(response)) {
            this.endReached = true;
        } else {
            this.checkIfLastPage(response);
        }
        this.updateListeners(response, false);
        this.updateFacetStats(response);
        EventBus.getDefault().post((Object)new ResultEvent(this, response, this.query, -1));
        return this;
    }

    @NonNull
    public Searcher loadMore() {
        if (!this.hasMoreHits()) {
            return this;
        }
        this.query.setPage(Integer.valueOf(++this.lastRequestPage));
        final int currentRequestId = ++lastRequestId;
        EventBus.getDefault().post((Object)new SearchEvent(this, this.query, currentRequestId));
        this.pendingRequests.put(currentRequestId, (Object)this.triggerSearch(new CompletionHandler(){

            public void requestCompleted(@NonNull JSONObject content, @Nullable AlgoliaException error) {
                Searcher.this.pendingRequests.remove(currentRequestId);
                if (error != null) {
                    Searcher.this.postError(error, currentRequestId);
                } else {
                    if (currentRequestId <= Searcher.this.lastResponseId) {
                        return;
                    }
                    if (Searcher.hasHits(content)) {
                        Searcher.this.updateListeners(content, true);
                        Searcher.this.updateFacetStats(content);
                        Searcher.this.lastResponsePage = Searcher.this.lastRequestPage;
                        Searcher.this.checkIfLastPage(content);
                    } else {
                        Searcher.this.endReached = true;
                    }
                    EventBus.getDefault().post((Object)new ResultEvent(Searcher.this, content, Searcher.this.query, currentRequestId));
                }
            }
        }));
        return this;
    }

    private Request triggerSearch(CompletionHandler searchHandler) {
        Request searchRequest = !this.disjunctiveFacets.isEmpty() ? this.searchable.searchDisjunctiveFacetingAsync(this.query, this.disjunctiveFacets, this.refinementMap, null, searchHandler) : this.searchable.searchAsync(this.query, searchHandler);
        return searchRequest;
    }

    public boolean hasMoreHits() {
        return !this.endReached && this.lastRequestPage <= this.lastResponsePage;
    }

    @NonNull
    public Searcher reset() {
        this.lastResponsePage = 0;
        this.lastRequestPage = 0;
        this.lastResponseId = 0;
        this.endReached = false;
        this.clearFacetRefinements();
        this.cancelPendingRequests();
        this.numericRefinements.clear();
        return this;
    }

    public boolean hasPendingRequests() {
        return this.pendingRequests.size() != 0;
    }

    public Searcher cancelPendingRequests() {
        if (this.pendingRequests.size() != 0) {
            for (int i = 0; i < this.pendingRequests.size(); ++i) {
                int reqId = this.pendingRequests.keyAt(i);
                Request r = (Request)this.pendingRequests.valueAt(i);
                if (r.isFinished() || r.isCancelled()) continue;
                this.cancelRequest(r, reqId);
            }
        }
        return this;
    }

    @Deprecated
    public void addFacet(@NonNull String attribute, boolean isDisjunctive, @Nullable List<String> values) {
        this.addFacetRefinement(attribute, values, isDisjunctive);
    }

    @NonNull
    public Searcher addFacetRefinement(@NonNull String attribute, @NonNull String value) {
        return this.addFacetRefinement(attribute, Collections.singletonList(value), this.disjunctiveFacets.contains(attribute));
    }

    public Searcher addFacetRefinement(@NonNull String attribute, @Nullable List<String> values, boolean isDisjunctive) {
        if (values == null) {
            values = new ArrayList<String>();
        }
        if (isDisjunctive) {
            this.disjunctiveFacets.add(attribute);
        }
        List<String> attributeRefinements = this.getOrCreateRefinements(attribute);
        attributeRefinements.addAll(values);
        this.rebuildQueryFacetFilters();
        for (String value : values) {
            EventBus.getDefault().post((Object)new FacetRefinementEvent(this, RefinementEvent.Operation.ADD, attribute, value, isDisjunctive));
        }
        return this;
    }

    @NonNull
    public Searcher removeFacetRefinement(@NonNull String attribute, @NonNull String value) {
        List<String> attributeRefinements = this.getOrCreateRefinements(attribute);
        attributeRefinements.remove(value);
        this.rebuildQueryFacetFilters();
        EventBus.getDefault().post((Object)new FacetRefinementEvent(this, RefinementEvent.Operation.REMOVE, attribute, value, this.disjunctiveFacets.contains(attribute)));
        return this;
    }

    @NonNull
    public Searcher updateFacetRefinement(@NonNull String attribute, @NonNull String value, boolean active) {
        if (active) {
            this.addFacetRefinement(attribute, value);
        } else {
            this.removeFacetRefinement(attribute, value);
        }
        return this;
    }

    public boolean hasFacetRefinement(@NonNull String attribute, @NonNull String value) {
        List<String> attributeRefinements = this.refinementMap.get(attribute);
        return attributeRefinements != null && attributeRefinements.contains(value);
    }

    @Nullable
    public List<String> getFacetRefinements(@NonNull String attribute) {
        return this.refinementMap.get(attribute);
    }

    public Searcher clearFacetRefinements() {
        this.refinementMap.clear();
        this.rebuildQueryFacetFilters();
        return this;
    }

    public Searcher clearFacetRefinements(@NonNull String attribute) {
        List<String> stringList = this.refinementMap.get(attribute);
        if (stringList != null) {
            stringList.clear();
        }
        this.rebuildQueryFacetFilters();
        return this;
    }

    @Nullable
    public NumericRefinement getNumericRefinement(@NonNull String attribute, int operator) {
        NumericRefinement.checkOperatorIsValid(operator);
        SparseArray<NumericRefinement> attributeRefinements = this.numericRefinements.get(attribute);
        return attributeRefinements == null ? null : (NumericRefinement)attributeRefinements.get(operator);
    }

    public Searcher addNumericRefinement(@NonNull NumericRefinement refinement) {
        SparseArray refinements = this.numericRefinements.get(refinement.attribute);
        if (refinements == null) {
            refinements = new SparseArray();
        }
        refinements.put(refinement.operator, (Object)refinement);
        this.numericRefinements.put(refinement.attribute, (SparseArray<NumericRefinement>)refinements);
        this.rebuildQueryNumericFilters();
        EventBus.getDefault().post((Object)new NumericRefinementEvent(this, RefinementEvent.Operation.ADD, refinement));
        return this;
    }

    public Searcher removeNumericRefinement(@NonNull String attribute) {
        return this.removeNumericRefinement(new NumericRefinement(attribute, -42, -42.0));
    }

    public Searcher removeNumericRefinement(@NonNull String attribute, @NonNull Integer operator) {
        return this.removeNumericRefinement(new NumericRefinement(attribute, operator, -42.0));
    }

    public Searcher removeNumericRefinement(@NonNull NumericRefinement refinement) {
        if (refinement.operator == -42) {
            this.numericRefinements.remove(refinement.attribute);
        } else {
            NumericRefinement.checkOperatorIsValid(refinement.operator);
            this.numericRefinements.get(refinement.attribute).remove(refinement.operator);
        }
        this.rebuildQueryNumericFilters();
        EventBus.getDefault().post((Object)new NumericRefinementEvent(this, RefinementEvent.Operation.REMOVE, refinement));
        return this;
    }

    public Searcher addBooleanFilter(String attribute, Boolean value) {
        this.booleanFilterMap.put(attribute, value);
        this.rebuildQueryFacetFilters();
        return this;
    }

    @Nullable
    public Boolean getBooleanFilter(String attribute) {
        return this.booleanFilterMap.get(attribute);
    }

    public Searcher removeBooleanFilter(String attribute) {
        this.booleanFilterMap.remove(attribute);
        this.rebuildQueryFacetFilters();
        return this;
    }

    public Searcher addFacet(String ... attributes) {
        String[] stringArray = attributes;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String attribute;
            Integer value = this.facetRequestCount.get(attribute = stringArray[i]);
            this.facetRequestCount.put(attribute, value == null ? 1 : value + 1);
            if (value != null && value != 0) continue;
            this.facets.add(attribute);
        }
        this.rebuildQueryFacets();
        return this;
    }

    public Searcher removeFacet(String ... attributes) {
        for (String attribute : attributes) {
            Integer value = this.facetRequestCount.get(attribute);
            if (value == null) {
                Log.e((String)"Algolia|Searcher", (String)("removeFacet called for" + attribute + " which was not currently a facet."));
                continue;
            }
            if (value == 1) {
                this.facets.remove(attribute);
                this.facetRequestCount.put(attribute, 0);
                continue;
            }
            this.facetRequestCount.put(attribute, value - 1);
        }
        this.rebuildQueryFacets();
        return this;
    }

    public Searcher deleteFacet(String ... attributes) {
        for (String attribute : attributes) {
            this.facetRequestCount.put(attribute, 0);
            this.facets.remove(attribute);
        }
        this.rebuildQueryFacets();
        return this;
    }

    public Searcher registerResultListener(@NonNull AlgoliaResultsListener resultListener) {
        if (!this.resultListeners.contains(resultListener)) {
            this.resultListeners.add(resultListener);
        }
        return this;
    }

    public Searcher registerErrorListener(@NonNull AlgoliaErrorListener errorListener) {
        if (!this.errorListeners.contains(errorListener)) {
            this.errorListeners.add(errorListener);
        }
        return this;
    }

    public void unregisterResultListener(@NonNull AlgoliaResultsListener resultListener) {
        this.resultListeners.remove(resultListener);
    }

    public void unregisterErrorListener(@NonNull AlgoliaErrorListener errorListener) {
        this.errorListeners.remove(errorListener);
    }

    static boolean hasHits(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return false;
        }
        JSONArray resultHits = jsonObject.optJSONArray("hits");
        if (resultHits == null) {
            return false;
        }
        for (int i = 0; i < resultHits.length(); ++i) {
            JSONObject hit = resultHits.optJSONObject(i);
            if (hit == null) continue;
            return true;
        }
        return false;
    }

    public Query getQuery() {
        return this.query;
    }

    @NonNull
    public Searcher setQuery(@NonNull Query query) {
        this.query = query;
        this.query.setPage(Integer.valueOf(0));
        return this;
    }

    public Searchable getSearchable() {
        return this.searchable;
    }

    @Deprecated
    public Index getIndex() {
        if (this.searchable instanceof Index) {
            return (Index)this.searchable;
        }
        throw new IllegalStateException("This method requires an Algolia Index and not a custom Searchable");
    }

    @NonNull
    public Searcher setIndex(@NonNull String indexName) {
        if (this.client == null) {
            throw new IllegalStateException("This method requires an Algolia Index and not a custom Searchable");
        }
        this.searchable = this.client.getIndex(indexName);
        this.query.setPage(Integer.valueOf(0));
        return this;
    }

    public void destroy() {
        this.errorListeners.clear();
        this.resultListeners.clear();
    }

    private void updateFacetStats(JSONObject content) {
        if (content == null) {
            return;
        }
        JSONObject facets = content.optJSONObject("facets");
        JSONObject facets_stats = content.optJSONObject("facets_stats");
        if (facets != null) {
            Iterator keys = facets.keys();
            while (keys.hasNext()) {
                this.updateFacetStat(facets, facets_stats, (String)keys.next());
            }
        }
    }

    private void updateFacetStat(JSONObject facets, JSONObject facets_stats, String attribute) {
        JSONObject attributeStats;
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        double sum = 0.0;
        if (facets_stats != null && (attributeStats = facets_stats.optJSONObject(attribute)) != null) {
            try {
                min = attributeStats.getDouble("min");
                max = attributeStats.getDouble("max");
                sum = attributeStats.getDouble("sum");
                double avg = attributeStats.getDouble("avg");
                this.facetStats.put(attribute, new FacetStat(min, max, avg, sum));
                return;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        JSONObject values = facets.optJSONObject(attribute);
        Iterator valueKeys = values.keys();
        while (valueKeys.hasNext()) {
            boolean attributeValue;
            String valueKey = (String)valueKeys.next();
            if (!valueKey.equals("true") && !valueKey.equals("false")) continue;
            boolean bl = attributeValue = !valueKey.equals("false");
            if ((double)attributeValue < min) {
                min = (double)attributeValue;
            }
            if ((double)attributeValue > max) {
                max = (double)attributeValue;
            }
            sum += (double)attributeValue;
        }
        if (min != Double.MAX_VALUE && max != Double.MIN_VALUE) {
            double avg = sum / (double)values.length();
            this.facetStats.put(attribute, new FacetStat(min, max, avg, sum));
        }
    }

    @Nullable
    public FacetStat getFacetStat(String attribute) {
        return this.facetStats.get(attribute);
    }

    public void getUpdatedFacetStats() {
        this.searchable.searchAsync(this.query, new CompletionHandler(){

            public void requestCompleted(JSONObject content, AlgoliaException error) {
                if (error == null) {
                    Searcher.this.updateFacetStats(content);
                } else {
                    Log.e((String)"Algolia|Searcher", (String)("Error while getting updated facet stats:" + error.getMessage()));
                }
            }
        });
    }

    public String toString() {
        String key = null;
        for (Map.Entry<String, Searcher> entry : instances.entrySet()) {
            if (!this.equals(entry.getValue())) continue;
            key = entry.getKey();
            break;
        }
        return "Searcher{" + (key != null ? key : "") + "}";
    }

    private Searcher rebuildQueryFacetFilters() {
        JSONArray facetFilters = new JSONArray();
        for (Map.Entry<String, List<String>> entry : this.refinementMap.entrySet()) {
            List<String> values = entry.getValue();
            String attribute = entry.getKey();
            for (String value : values) {
                facetFilters.put((Object)(attribute + ":" + value));
            }
        }
        for (Map.Entry<String, Object> entry : this.booleanFilterMap.entrySet()) {
            facetFilters.put((Object)(entry.getKey() + ":" + entry.getValue()));
        }
        this.query.setFacetFilters(facetFilters);
        this.query.setPage(Integer.valueOf(0));
        return this;
    }

    private void rebuildQueryNumericFilters() {
        JSONArray numericFilters = new JSONArray();
        for (SparseArray<NumericRefinement> refinements : this.numericRefinements.values()) {
            for (int i = 0; i < refinements.size(); ++i) {
                numericFilters.put((Object)((NumericRefinement)refinements.valueAt(i)).toString());
            }
        }
        this.query.setNumericFilters(numericFilters);
        this.query.setPage(Integer.valueOf(0));
    }

    private Searcher rebuildQueryFacets() {
        String[] facetArray = this.facets.toArray(new String[this.facets.size()]);
        this.query.setFacets(facetArray);
        return this;
    }

    @NonNull
    private List<String> getOrCreateRefinements(@NonNull String attribute) {
        List<String> attributeRefinements = this.refinementMap.get(attribute);
        if (attributeRefinements == null) {
            attributeRefinements = new ArrayList<String>();
            this.refinementMap.put(attribute, attributeRefinements);
        }
        return attributeRefinements;
    }

    private void cancelRequest(Request request, int requestSeqNumber) {
        if (request.isCancelled()) {
            throw new IllegalStateException("cancelRequest was called on a request that was already canceled.");
        }
        request.cancel();
        this.pendingRequests.delete(requestSeqNumber);
        EventBus.getDefault().post((Object)new CancelEvent(this, request, requestSeqNumber));
    }

    private void checkIfLastPage(@NonNull JSONObject content) {
        if (content.optInt("nbPages") == content.optInt("page") + 1) {
            this.endReached = true;
        }
    }

    private void updateListeners(@NonNull JSONObject content, boolean isLoadingMore) {
        for (AlgoliaResultsListener listener : this.resultListeners) {
            listener.onResults(new SearchResults(content), isLoadingMore);
        }
    }

    private void postError(@NonNull AlgoliaException error, int currentRequestId) {
        for (AlgoliaErrorListener listener : this.errorListeners) {
            listener.onError(this.query, error);
        }
        EventBus.getDefault().post((Object)new ErrorEvent(this, error, this.query, currentRequestId));
    }
}

