/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.model;

import android.support.annotation.NonNull;
import java.util.Locale;

public class NumericRefinement {
    public static final int OPERATOR_LT = 0;
    public static final int OPERATOR_LE = 1;
    public static final int OPERATOR_EQ = 2;
    public static final int OPERATOR_NE = 3;
    public static final int OPERATOR_GE = 4;
    public static final int OPERATOR_GT = 5;
    public static final int OPERATOR_UNKNOWN = -42;
    public static final double VALUE_UNKNOWN = -42.0;
    private static final String ERROR_INVALID_CODE = "operator (%d) should be one of NumericRefinement.OPERATOR_XX.";
    private static final String ERROR_INVALID_NAME = "operator (%s) should be one of 'lt', 'le', 'eq', 'ne', 'ge', 'gt'.";
    public final int operator;
    @NonNull
    public final String attribute;
    public final Double value;

    public NumericRefinement(@NonNull String attribute, int operator, double value) {
        NumericRefinement.checkOperatorIsValid(operator);
        this.operator = operator;
        this.value = value;
        this.attribute = attribute;
    }

    public static int getOperatorCode(String operatorName) {
        switch (operatorName) {
            case "lt": {
                return 0;
            }
            case "le": {
                return 1;
            }
            case "eq": {
                return 2;
            }
            case "ne": {
                return 3;
            }
            case "ge": {
                return 4;
            }
            case "gt": {
                return 5;
            }
        }
        throw new IllegalStateException(String.format(ERROR_INVALID_NAME, operatorName));
    }

    public static void checkOperatorIsValid(int operatorCode) {
        switch (operatorCode) {
            case -42: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return;
            }
        }
        throw new IllegalStateException(String.format(Locale.US, ERROR_INVALID_CODE, operatorCode));
    }

    static String getOperatorSymbol(int operatorCode) {
        switch (operatorCode) {
            case 0: {
                return "<";
            }
            case 1: {
                return "<=";
            }
            case 2: {
                return "=";
            }
            case 3: {
                return "!=";
            }
            case 4: {
                return ">=";
            }
            case 5: {
                return ">";
            }
        }
        throw new IllegalStateException(String.format(Locale.US, ERROR_INVALID_CODE, operatorCode));
    }

    public String toString() {
        return this.attribute + NumericRefinement.getOperatorSymbol(this.operator) + String.format(Locale.US, "%f", this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumericRefinement that = (NumericRefinement)o;
        return this.operator == that.operator && this.attribute.equals(that.attribute) && this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.operator;
        result = 31 * result + this.attribute.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }
}

