/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.model;

import android.support.annotation.NonNull;
import android.support.v7.widget.SearchView;
import android.widget.SearchView;
import com.algolia.instantsearch.events.QueryTextChangeEvent;
import com.algolia.instantsearch.events.QueryTextSubmitEvent;
import com.algolia.instantsearch.helpers.InstantSearch;
import com.algolia.instantsearch.utils.SearchViewFacade;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.EventBus;

public class SearchBoxViewModel {
    private final SearchViewFacade searchViewFacade;
    private List<InstantSearch> listeners = new ArrayList<InstantSearch>();

    public SearchBoxViewModel(@NonNull SearchView searchView) {
        this(new SearchViewFacade(searchView));
    }

    public SearchBoxViewModel(@NonNull android.widget.SearchView searchView) {
        this(new SearchViewFacade(searchView));
    }

    public SearchBoxViewModel(@NonNull SearchViewFacade searchViewFacade) {
        this.searchViewFacade = searchViewFacade;
    }

    public void addListener(InstantSearch instantSearch) {
        this.listeners.add(instantSearch);
        this.setOnQueryTextListener();
    }

    public SearchViewFacade getSearchView() {
        return this.searchViewFacade;
    }

    private void setOnQueryTextListener() {
        this.searchViewFacade.setOnQueryTextListener(new SearchView.OnQueryTextListener(){

            public boolean onQueryTextSubmit(String query) {
                EventBus.getDefault().post((Object)new QueryTextSubmitEvent());
                SearchBoxViewModel.this.searchViewFacade.clearFocus();
                return true;
            }

            public boolean onQueryTextChange(String newText) {
                EventBus.getDefault().post((Object)new QueryTextChangeEvent(newText, SearchBoxViewModel.this.searchViewFacade.getSearchView()));
                String query = SearchBoxViewModel.this.searchViewFacade.getQuery().toString();
                for (InstantSearch instantSearch : SearchBoxViewModel.this.listeners) {
                    if (newText.isEmpty() && !instantSearch.hasSearchOnEmptyString()) continue;
                    instantSearch.search(query);
                }
                return true;
            }
        });
    }
}

