/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.algolia.instantsearch.model.FacetValue;
import com.algolia.search.saas.AbstractQuery;
import com.algolia.search.saas.Query;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SearchResults {
    @NonNull
    public final JSONObject content;
    public Map<String, List<FacetValue>> disjunctiveFacets;
    public Map<String, List<FacetValue>> facets;
    @NonNull
    public JSONArray hits;
    public int nbHits;
    @NonNull
    public String query;
    @NonNull
    public String params;
    @NonNull
    public int processingTimeMS;
    @NonNull
    public Integer page;
    @NonNull
    public Integer nbPages;
    @NonNull
    public Integer hitsPerPage;
    @NonNull
    public Boolean exhaustiveFacetsCount;
    @Nullable
    public String message;
    @Nullable
    public String queryAfterRemoval;
    @Nullable
    public AbstractQuery.LatLng aroundLatLng;
    @Nullable
    public Integer automaticRadius;
    public String serverUsed;
    public String parsedQuery;
    public Boolean timeoutCounts;
    public Boolean timeoutHits;

    public SearchResults(@NonNull JSONObject content) {
        this.content = content;
        try {
            this.hits = content.getJSONArray("hits");
            this.nbHits = content.getInt("nbHits");
            this.query = content.getString("query");
            this.params = content.getString("params");
            this.processingTimeMS = content.getInt("processingTimeMS");
        }
        catch (JSONException e) {
            throw new IllegalStateException("Invalid response from server.", e);
        }
        this.message = content.optString("message", null);
        this.queryAfterRemoval = content.optString("queryAfterRemoval", null);
        this.aroundLatLng = Query.parseLatLng((String)content.optString("aroundLatLng", null));
        this.serverUsed = content.optString("serverUsed", null);
        this.parsedQuery = content.optString("parsedQuery", null);
        this.facets = this.parseFacets(content.optJSONObject("facets"));
        this.disjunctiveFacets = this.parseFacets(content.optJSONObject("disjunctiveFacets"));
        this.page = content.optInt("page");
        this.nbPages = content.optInt("nbPages");
        this.hitsPerPage = content.optInt("hitsPerPage");
        this.exhaustiveFacetsCount = content.optBoolean("exhaustiveFacetsCount");
        try {
            this.automaticRadius = content.getInt("automaticRadius");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            this.timeoutCounts = content.getBoolean("timeoutCounts");
            this.timeoutHits = content.getBoolean("timeoutHits");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @NonNull
    private Map<String, List<FacetValue>> parseFacets(@Nullable JSONObject facets) {
        HashMap<String, List<FacetValue>> facetMap = new HashMap<String, List<FacetValue>>();
        if (facets == null) {
            return facetMap;
        }
        Iterator attributesIterator = facets.keys();
        while (attributesIterator.hasNext()) {
            String attribute = (String)attributesIterator.next();
            JSONObject attributeFacets = facets.optJSONObject(attribute);
            Iterator valuesIterator = attributeFacets.keys();
            ArrayList<FacetValue> facetList = new ArrayList<FacetValue>();
            while (valuesIterator.hasNext()) {
                String value = (String)valuesIterator.next();
                int count = attributeFacets.optInt(value);
                facetList.add(new FacetValue(value, count));
            }
            facetMap.put(attribute, facetList);
        }
        return facetMap;
    }

    public String toString() {
        return this.content.toString();
    }
}

