/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.ui.databinding;

import android.annotation.SuppressLint;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.databinding.BindingAdapter;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import com.algolia.instantsearch.R;
import com.algolia.instantsearch.ui.databinding.RenderingHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BindingHelper {
    @NonNull
    private static final HashMap<String, HashMap<Integer, String>> bindings = new HashMap();
    @NonNull
    private static final SparseArray<String> prefixes = new SparseArray();
    @NonNull
    private static final SparseArray<String> suffixes = new SparseArray();

    @Deprecated
    @BindingAdapter(value={"attribute", "highlighted", "highlightColor", "variant", "prefix", "suffix"}, requireAll=false)
    public static void bindAttribute(@NonNull View view, @Nullable String attribute, @Nullable Boolean highlighted, @Nullable @ColorInt Integer color2, @Nullable String variant, @Nullable String prefix, @Nullable String suffix) {
        if (attribute == null) {
            BindingHelper.throwBindingError(view, "Your view lacks an algolia:attribute.");
        } else {
            BindingHelper.bindAttribute(view, attribute, variant);
        }
        if (highlighted != null && highlighted.booleanValue() || color2 != null && (highlighted == null || !highlighted.booleanValue())) {
            BindingHelper.highlight(view, attribute, color2 != null ? color2.intValue() : view.getResources().getColor(RenderingHelper.DEFAULT_COLOR));
        }
        if (prefix != null) {
            prefixes.put(view.getId(), (Object)prefix);
        }
        if (suffix != null) {
            suffixes.put(view.getId(), (Object)suffix);
        }
    }

    @Deprecated
    public static void bindAttribute(@NonNull View view, @NonNull String attribute, @Nullable String variant) {
        int id2 = view.getId();
        if (BindingHelper.notAlreadyMapped(id2, variant)) {
            BindingHelper.mapAttribute(attribute, id2, variant);
        }
    }

    public static HashMap<Integer, String> getBindings(String indexVariant) {
        return bindings.get(indexVariant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String setVariantForView(@NonNull View view, @NonNull AttributeSet attrs) {
        String previousVariant;
        TypedArray styledAttributes = view.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.View, 0, 0);
        try {
            previousVariant = BindingHelper.setVariantForView(view, styledAttributes.getString(R.styleable.View_variant));
        }
        finally {
            styledAttributes.recycle();
        }
        return previousVariant;
    }

    @Nullable
    public static String setVariantForView(@NonNull View view, @Nullable String variant) {
        String previousVariant = null;
        String previousAttribute = null;
        for (Map.Entry<String, HashMap<Integer, String>> entry : bindings.entrySet()) {
            if (!entry.getValue().containsKey(view.getId())) continue;
            previousVariant = entry.getKey();
            previousAttribute = entry.getValue().get(view.getId());
            bindings.remove(previousVariant);
            break;
        }
        BindingHelper.mapAttribute(previousAttribute, view.getId(), variant);
        return previousVariant;
    }

    @Nullable
    public static String getVariantForView(@NonNull View view) {
        for (Map.Entry<String, HashMap<Integer, String>> entry : bindings.entrySet()) {
            if (!entry.getValue().containsKey(view.getId())) continue;
            return entry.getKey();
        }
        return null;
    }

    private static boolean notAlreadyMapped(int id2, @Nullable String variant) {
        HashMap<Integer, String> indexMap = bindings.get(variant);
        return indexMap == null || indexMap.get(id2) == null;
    }

    public static boolean isBound(int viewId) {
        Set<Map.Entry<String, HashMap<Integer, String>>> allVariants = bindings.entrySet();
        for (Map.Entry<String, HashMap<Integer, String>> variantMap : allVariants) {
            if (!variantMap.getValue().keySet().contains(viewId)) continue;
            return true;
        }
        return false;
    }

    @SuppressLint(value={"UseSparseArrays"})
    private static void mapAttribute(String attribute, int viewId, @Nullable String variant) {
        if (viewId == -1) {
            throw new IllegalStateException(String.format("Your View for attribute %s must have an android:id.", attribute));
        }
        HashMap<Integer, String> variantMap = bindings.get(variant);
        if (variantMap == null) {
            variantMap = new HashMap();
            bindings.put(variant, variantMap);
        }
        variantMap.put(viewId, attribute);
    }

    private static void throwBindingError(@NonNull View view, String message) {
        String viewName = BindingHelper.getViewName(view);
        throw new IllegalStateException("Cannot bind " + viewName + ": " + message);
    }

    @NonNull
    private static String getViewName(@NonNull View view) {
        Resources r = view.getContext().getResources();
        int id2 = view.getId();
        return r.getResourcePackageName(id2) + ":" + r.getResourceTypeName(id2) + "/" + r.getResourceEntryName(id2);
    }

    private static void highlight(@NonNull View view, String attribute, @ColorInt int color2) {
        RenderingHelper.getDefault().addHighlight(view, attribute, color2);
    }

    @NonNull
    public static String getFullAttribute(View view, @Nullable String rawAttribute) {
        String attribute = "";
        int id2 = view.getId();
        String prefix = (String)prefixes.get(id2);
        String suffix = (String)suffixes.get(id2);
        if (prefix != null) {
            attribute = prefix;
        }
        attribute = attribute + rawAttribute;
        if (suffix != null) {
            attribute = attribute + suffix;
        }
        return attribute;
    }
}

