/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.ui.databinding;

import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.util.Pair;
import android.view.View;
import com.algolia.instantsearch.R;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RenderingHelper {
    @ColorRes
    static final int DEFAULT_COLOR = R.color.colorHighlighting;
    private static RenderingHelper defaultRenderingHelper;
    @NonNull
    private final Set<Pair<View, String>> highlightedAttributes = new HashSet<Pair<View, String>>();
    @NonNull
    private final Map<Pair<View, String>, Integer> attributeColors = new HashMap<Pair<View, String>, Integer>();

    public static RenderingHelper getDefault() {
        if (defaultRenderingHelper == null) {
            defaultRenderingHelper = new RenderingHelper();
        }
        return defaultRenderingHelper;
    }

    private RenderingHelper() {
    }

    @ColorInt
    public Integer getHighlightColor(View view, String attribute) {
        try {
            return this.attributeColors.get(new Pair((Object)view, (Object)attribute));
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    public boolean shouldHighlight(View view, String attribute) {
        return this.highlightedAttributes.contains(new Pair((Object)view, (Object)attribute));
    }

    Integer addHighlight(View view, String attribute, @ColorInt int colorId) {
        Pair pair = new Pair((Object)view, (Object)attribute);
        this.highlightedAttributes.add((Pair<View, String>)pair);
        return this.attributeColors.put((Pair<View, String>)pair, colorId);
    }
}

