/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.ui.views;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.TypedArray;
import android.databinding.DataBindingUtil;
import android.databinding.ViewDataBinding;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.text.Spannable;
import android.text.SpannableString;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RatingBar;
import android.widget.TextView;
import com.algolia.instantsearch.R;
import com.algolia.instantsearch.events.ResetEvent;
import com.algolia.instantsearch.helpers.Highlighter;
import com.algolia.instantsearch.helpers.Searcher;
import com.algolia.instantsearch.model.AlgoliaErrorListener;
import com.algolia.instantsearch.model.AlgoliaResultsListener;
import com.algolia.instantsearch.model.AlgoliaSearcherListener;
import com.algolia.instantsearch.model.SearchResults;
import com.algolia.instantsearch.ui.databinding.BindingHelper;
import com.algolia.instantsearch.ui.databinding.RenderingHelper;
import com.algolia.instantsearch.ui.views.AlgoliaHitView;
import com.algolia.instantsearch.utils.ItemClickSupport;
import com.algolia.instantsearch.utils.JSONUtils;
import com.algolia.instantsearch.utils.LayoutViews;
import com.algolia.search.saas.AlgoliaException;
import com.algolia.search.saas.Query;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.json.JSONArray;
import org.json.JSONObject;

public class Hits
extends RecyclerView
implements AlgoliaResultsListener,
AlgoliaErrorListener,
AlgoliaSearcherListener {
    public static final int DEFAULT_REMAINING_ITEMS = 5;
    private static final int MISSING_VALUE = Integer.MIN_VALUE;
    private final int remainingItemsBeforeLoading;
    protected int layoutId;
    @NonNull
    protected HitsAdapter adapter;
    @NonNull
    private RecyclerView.LayoutManager layoutManager;
    @NonNull
    private Searcher searcher;
    @NonNull
    private InputMethodManager imeManager;
    @Nullable
    protected final InfiniteScrollListener infiniteScrollListener;
    @Nullable
    private RecyclerView.OnScrollListener keyboardListener;
    @Nullable
    private View emptyView;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hits(@NonNull Context context, AttributeSet attrs) {
        super(context, attrs);
        boolean infiniteScroll;
        if (this.isInEditMode()) {
            this.remainingItemsBeforeLoading = 0;
            this.layoutId = 0;
            this.infiniteScrollListener = null;
            this.adapter = null;
            this.searcher = null;
            this.layoutManager = null;
            this.imeManager = null;
            return;
        }
        TypedArray styledAttributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.Hits, 0, 0);
        try {
            int remainingItemsAttribute;
            this.layoutId = styledAttributes.getResourceId(R.styleable.Hits_itemLayout, 0);
            infiniteScroll = styledAttributes.getBoolean(R.styleable.Hits_infiniteScroll, true);
            if (styledAttributes.getBoolean(R.styleable.Hits_autoHideKeyboard, false)) {
                this.enableKeyboardAutoHiding();
            }
            if ((remainingItemsAttribute = styledAttributes.getInt(R.styleable.Hits_remainingItemsBeforeLoading, Integer.MIN_VALUE)) == Integer.MIN_VALUE) {
                this.remainingItemsBeforeLoading = 5;
            } else {
                this.remainingItemsBeforeLoading = remainingItemsAttribute;
                if (!infiniteScroll) {
                    throw new IllegalStateException("You specified infiniteScroll=\"false\" and remainingItemsBeforeLoading, but they are mutually exclusive.");
                }
            }
            BindingHelper.setVariantForView((View)this, attrs);
        }
        finally {
            styledAttributes.recycle();
        }
        this.setHasFixedSize(true);
        this.adapter = new HitsAdapter();
        this.adapter.registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(){

            public void onChanged() {
                super.onChanged();
                Hits.this.updateEmptyView();
            }
        });
        this.setAdapter(this.adapter);
        this.imeManager = (InputMethodManager)context.getSystemService("input_method");
        this.layoutManager = new LinearLayoutManager(context);
        this.setLayoutManager(this.layoutManager);
        InfiniteScrollListener infiniteScrollListener = this.infiniteScrollListener = infiniteScroll ? new InfiniteScrollListener() : null;
        if (infiniteScroll) {
            this.addOnScrollListener(this.infiniteScrollListener);
        }
    }

    public void setOnItemClickListener(ItemClickSupport.OnItemClickListener listener) {
        ItemClickSupport.addTo(this).setOnItemClickListener(listener);
    }

    public void setOnItemLongClickListener(ItemClickSupport.OnItemLongClickListener listener) {
        ItemClickSupport.addTo(this).setOnItemLongClickListener(listener);
    }

    public void clear() {
        this.adapter.clear();
    }

    public JSONObject get(int position) {
        return this.adapter.getItemAt(position);
    }

    public void enableKeyboardAutoHiding() {
        this.keyboardListener = new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                if (dx != 0 || dy != 0) {
                    Hits.this.imeManager.hideSoftInputFromWindow(Hits.this.getWindowToken(), 2);
                }
                super.onScrolled(recyclerView, dx, dy);
            }
        };
        this.addOnScrollListener(this.keyboardListener);
    }

    public void disableKeyboardAutoHiding() {
        this.removeOnScrollListener(this.keyboardListener);
        this.keyboardListener = null;
    }

    protected void addHits(@Nullable SearchResults results, boolean isReplacing) {
        if (results == null) {
            if (isReplacing) {
                this.clear();
                if (this.infiniteScrollListener != null) {
                    this.infiniteScrollListener.setCurrentlyLoading(false);
                }
            }
            return;
        }
        JSONArray hits = results.hits;
        if (isReplacing) {
            this.adapter.clear(false);
        }
        for (int i = 0; i < hits.length(); ++i) {
            JSONObject hit = hits.optJSONObject(i);
            if (hit == null) continue;
            this.adapter.add(hit);
        }
        if (isReplacing) {
            this.adapter.notifyDataSetChanged();
            this.smoothScrollToPosition(0);
            if (this.infiniteScrollListener != null) {
                this.infiniteScrollListener.setCurrentlyLoading(false);
            }
        } else {
            this.adapter.notifyItemRangeInserted(this.adapter.getItemCount(), hits.length());
        }
    }

    @Nullable
    protected Spannable getHighlightedAttribute(@NonNull JSONObject hit, @NonNull View view, @NonNull String attribute, @Nullable String attributeValue) {
        SpannableString attributeText = null;
        if (attributeValue != null) {
            if (RenderingHelper.getDefault().shouldHighlight(view, attribute)) {
                int highlightColor = RenderingHelper.getDefault().getHighlightColor(view, attribute);
                attributeText = Highlighter.getDefault().setInput(hit, attribute, false).setStyle(highlightColor).render();
            } else {
                attributeText = new SpannableString((CharSequence)attributeValue);
            }
        }
        return attributeText;
    }

    private void updateEmptyView() {
        if (this.emptyView == null) {
            return;
        }
        if (this.adapter.getItemCount() == 0) {
            this.emptyView.setVisibility(0);
        } else {
            this.emptyView.setVisibility(8);
        }
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        EventBus.getDefault().register((Object)this);
    }

    public void onDetachedFromWindow() {
        EventBus.getDefault().unregister((Object)this);
        super.onDetachedFromWindow();
    }

    @Override
    public void initWithSearcher(@NonNull Searcher searcher) {
        this.searcher = searcher;
    }

    @Override
    public void onResults(@NonNull SearchResults results, boolean isLoadingMore) {
        this.addHits(results, !isLoadingMore);
    }

    @Override
    public void onError(@NonNull Query query, @NonNull AlgoliaException error) {
        Log.e((String)"Algolia|Hits", (String)("Error while searching '" + query.getQuery() + "':" + error.getMessage()));
    }

    @Subscribe
    public void onReset(ResetEvent event) {
        this.addHits(null, true);
    }

    public void setEmptyView(@Nullable View emptyView) {
        this.emptyView = emptyView;
    }

    public int getLayoutId() {
        return this.layoutId;
    }

    private class HitsAdapter
    extends RecyclerView.Adapter<ViewHolder> {
        @NonNull
        private List<JSONObject> hits = new ArrayList<JSONObject>();
        private SparseArray<Drawable> placeholders = new SparseArray();

        HitsAdapter() {
            this.hits = new ArrayList<JSONObject>();
        }

        void clear() {
            this.clear(true);
        }

        void clear(boolean shouldNotify) {
            if (shouldNotify) {
                int previousItemCount = this.getItemCount();
                this.hits.clear();
                this.notifyItemRangeRemoved(0, previousItemCount);
            } else {
                this.hits.clear();
            }
        }

        public void add(JSONObject result) {
            this.hits.add(result);
        }

        JSONObject getItemAt(int position) {
            return this.hits.get(position);
        }

        @NonNull
        public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            ViewDataBinding binding = DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)parent.getContext()), (int)Hits.this.layoutId, (ViewGroup)parent, (boolean)false);
            binding.executePendingBindings();
            return new ViewHolder(binding.getRoot());
        }

        public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
            Set mappedViews = holder.viewMap.keySet();
            List<AlgoliaHitView> hitViews = LayoutViews.findByClass((ViewGroup)holder.itemView, AlgoliaHitView.class);
            JSONObject hit = this.hits.get(position);
            for (AlgoliaHitView algoliaHitView : hitViews) {
                if (mappedViews.contains(algoliaHitView)) continue;
                algoliaHitView.onUpdateView(hit);
            }
            for (Map.Entry entry : holder.viewMap.entrySet()) {
                View view = (View)entry.getKey();
                String attributeName = (String)entry.getValue();
                if (attributeName == null) {
                    Log.d((String)"Hits", (String)("View " + view.toString() + " is bound to null attribute, skipping"));
                    continue;
                }
                String attributeValue = JSONUtils.getStringFromJSONPath(hit, attributeName);
                if (attributeValue == null) {
                    Log.d((String)"Hits", (String)("View " + view.toString() + " is bound to attribute " + attributeName + " missing in JSON, skipping"));
                    continue;
                }
                String fullAttribute = BindingHelper.getFullAttribute(view, attributeValue);
                if (view instanceof AlgoliaHitView) {
                    ((AlgoliaHitView)view).onUpdateView(hit);
                    continue;
                }
                if (view instanceof EditText) {
                    ((EditText)view).setHint((CharSequence)Hits.this.getHighlightedAttribute(hit, view, attributeName, fullAttribute));
                    continue;
                }
                if (view instanceof RatingBar) {
                    ((RatingBar)view).setRating(this.getFloatValue(fullAttribute));
                    continue;
                }
                if (view instanceof ProgressBar) {
                    ((ProgressBar)view).setProgress(Math.round(this.getFloatValue(fullAttribute)));
                    continue;
                }
                if (view instanceof TextView) {
                    ((TextView)view).setText((CharSequence)Hits.this.getHighlightedAttribute(hit, view, attributeName, fullAttribute));
                    continue;
                }
                if (view instanceof ImageView) {
                    Activity activity = this.getActivity(view);
                    if (activity == null || Build.VERSION.SDK_INT >= 17 && activity.isDestroyed()) continue;
                    ImageView imageView = (ImageView)view;
                    int viewId = imageView.getId();
                    Drawable placeholder = (Drawable)this.placeholders.get(viewId);
                    if (placeholder == null) {
                        placeholder = imageView.getDrawable();
                        this.placeholders.put(viewId, (Object)placeholder);
                    }
                    RequestOptions requestOptions = new RequestOptions().placeholder(placeholder);
                    switch (imageView.getScaleType()) {
                        case CENTER_CROP: {
                            requestOptions.centerCrop();
                            break;
                        }
                        case FIT_CENTER: {
                            requestOptions.fitCenter();
                            break;
                        }
                        case FIT_XY: 
                        case FIT_START: 
                        case FIT_END: 
                        case MATRIX: 
                        case CENTER: {
                            break;
                        }
                        default: {
                            requestOptions.centerInside();
                        }
                    }
                    Glide.with((Activity)activity).applyDefaultRequestOptions(requestOptions).load((Object)fullAttribute).into(imageView);
                    continue;
                }
                throw new IllegalStateException(String.format("Unrecognized view class (%s): Your view should either use/extend a system view or implement AlgoliaHitView.", view.getClass().getCanonicalName()));
            }
        }

        private float getFloatValue(String attributeValue) {
            return attributeValue != null ? Float.parseFloat(attributeValue) : 0.0f;
        }

        public int getItemCount() {
            return this.hits.size();
        }

        private Activity getActivity(View view) {
            Context context = view.getContext();
            while (context instanceof ContextWrapper) {
                if (context instanceof Activity) {
                    return (Activity)context;
                }
                context = ((ContextWrapper)context).getBaseContext();
            }
            Log.e((String)"Algolia|Hits", (String)"Error: Could not get activity from View.");
            return null;
        }

        class ViewHolder
        extends RecyclerView.ViewHolder {
            private final Map<View, String> viewMap;
            private final String defaultValue = "ADefaultValueForHitsVariant";

            ViewHolder(View itemView) {
                super(itemView);
                this.viewMap = new HashMap<View, String>();
                this.defaultValue = "ADefaultValueForHitsVariant";
                String indexVariant = "ADefaultValueForHitsVariant";
                List<View> views = LayoutViews.findAny((ViewGroup)itemView);
                for (View view : views) {
                    boolean isSameVariant;
                    if (!BindingHelper.isBound(view.getId()) || view instanceof AlgoliaHitView) continue;
                    String viewIndexVariant = BindingHelper.getVariantForView(view);
                    boolean bl = viewIndexVariant == null ? indexVariant == null : (isSameVariant = viewIndexVariant.equals(indexVariant));
                    if (!"ADefaultValueForHitsVariant".equals(indexVariant) && !isSameVariant) {
                        throw new IllegalStateException("Hits found two conflicting variants within its views: " + indexVariant + " / " + viewIndexVariant + ".");
                    }
                    indexVariant = viewIndexVariant;
                }
                HashMap<Integer, String> attributes = BindingHelper.getBindings(indexVariant);
                for (Map.Entry<Integer, String> entry : attributes.entrySet()) {
                    if (entry.getValue() == null) continue;
                    this.viewMap.put(itemView.findViewById(entry.getKey().intValue()), entry.getValue());
                }
            }
        }
    }

    private class InfiniteScrollListener
    extends RecyclerView.OnScrollListener {
        private int lastItemCount = 0;
        private boolean currentlyLoading = true;

        private InfiniteScrollListener() {
        }

        void setCurrentlyLoading(boolean currentlyLoading) {
            this.currentlyLoading = currentlyLoading;
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            if (!Hits.this.searcher.hasMoreHits()) {
                return;
            }
            int totalItemCount = Hits.this.layoutManager.getItemCount();
            if (totalItemCount < this.lastItemCount) {
                this.lastItemCount = totalItemCount;
                if (totalItemCount == 0) {
                    this.setCurrentlyLoading(true);
                    return;
                }
            }
            if (this.currentlyLoading) {
                if (totalItemCount > this.lastItemCount) {
                    this.setCurrentlyLoading(false);
                    this.lastItemCount = totalItemCount;
                }
            } else {
                int lastVisiblePosition = this.getLastVisibleItemPosition();
                if (lastVisiblePosition + Hits.this.remainingItemsBeforeLoading > totalItemCount) {
                    Hits.this.searcher.loadMore();
                    this.setCurrentlyLoading(true);
                }
            }
        }

        private int getLastVisibleItemPosition() {
            int lastVisiblePosition = 0;
            if (Hits.this.layoutManager instanceof StaggeredGridLayoutManager) {
                int[] lastVisibleItemPositions = ((StaggeredGridLayoutManager)Hits.this.layoutManager).findLastVisibleItemPositions(null);
                int maxSize = lastVisibleItemPositions[0];
                for (int lastVisibleItemPosition : lastVisibleItemPositions) {
                    if (lastVisibleItemPosition <= maxSize) continue;
                    maxSize = lastVisibleItemPosition;
                }
                lastVisiblePosition = maxSize;
            } else if (Hits.this.layoutManager instanceof LinearLayoutManager) {
                lastVisiblePosition = ((LinearLayoutManager)Hits.this.layoutManager).findLastVisibleItemPosition();
            }
            return lastVisiblePosition;
        }
    }
}

