/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.ui.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.SearchView;
import android.util.AttributeSet;
import android.view.View;
import com.algolia.instantsearch.R;
import com.algolia.instantsearch.events.QueryTextChangeEvent;
import com.algolia.instantsearch.ui.databinding.BindingHelper;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class SearchBox
extends SearchView {
    public SearchBox(Context context) {
        super(context);
        this.init(context, null);
    }

    public SearchBox(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(@NonNull Context context, @Nullable AttributeSet attrs) {
        if (this.isInEditMode()) {
            return;
        }
        EventBus.getDefault().register((Object)this);
        if (attrs != null) {
            TypedArray styledAttributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SearchBox, 0, 0);
            try {
                this.setIconifiedByDefault(false);
                for (int i = 0; i < attrs.getAttributeCount(); ++i) {
                    if (!"iconifiedByDefault".equals(attrs.getAttributeName(i))) continue;
                    this.setIconifiedByDefault(attrs.getAttributeBooleanValue(i, false));
                }
                if (styledAttributes.getBoolean(R.styleable.SearchBox_autofocus, false)) {
                    this.setFocusable(true);
                    this.setIconified(false);
                    this.requestFocusFromTouch();
                }
                this.setSubmitButtonEnabled(styledAttributes.getBoolean(R.styleable.SearchBox_submitButtonEnabled, false));
            }
            finally {
                styledAttributes.recycle();
            }
            BindingHelper.setVariantForView((View)this, attrs);
        }
    }

    public void disableFullScreen() {
        if (Build.VERSION.SDK_INT >= 16) {
            this.setImeOptions(this.getImeOptions() | 0x10000000);
        }
    }

    public void enableFullScreen() {
        if (Build.VERSION.SDK_INT >= 16) {
            this.setImeOptions(this.getImeOptions() & 0x10000000);
        }
    }

    @Subscribe
    public void onQueryEvent(QueryTextChangeEvent event) {
        if (!((Object)((Object)this)).equals(event.origin)) {
            this.setQuery(event.query, false);
        }
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
    }

    public void onDetachedFromWindow() {
        EventBus.getDefault().unregister((Object)this);
        super.onDetachedFromWindow();
    }
}

