/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.ui.views.filters;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.widget.CompoundButton;
import com.algolia.instantsearch.R;
import com.algolia.instantsearch.events.FacetRefinementEvent;
import com.algolia.instantsearch.events.RefinementEvent;
import com.algolia.instantsearch.model.SearchResults;
import com.algolia.instantsearch.ui.views.filters.AlgoliaFilter;
import com.algolia.instantsearch.ui.views.filters.Toggle;
import org.greenrobot.eventbus.Subscribe;

public class TwoValuesToggle
extends Toggle
implements AlgoliaFilter {
    private String valueOn;
    private String valueOff;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TwoValuesToggle(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray styledAttributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TwoValuesToggle, 0, 0);
        try {
            this.valueOn = styledAttributes.getString(R.styleable.TwoValuesToggle_valueOn);
            this.valueOff = styledAttributes.getString(R.styleable.TwoValuesToggle_valueOff);
            if (this.valueOff == null) {
                throw new IllegalStateException("Your TwoValuesToggle should have a valueOff attribute.");
            }
            if (this.valueOn == null) {
                throw new IllegalStateException("Your TwoValuesToggle should have a valueOn attribute.");
            }
        }
        finally {
            styledAttributes.recycle();
        }
    }

    public void setValueOn(String newValue, @Nullable String newName) {
        if (this.isChecked()) {
            this.searcher.updateFacetRefinement(this.attribute, this.valueOn, false).updateFacetRefinement(newName != null ? newName : this.attribute, newValue, true).search();
        }
        this.valueOn = newValue;
        this.applyEventualNewAttribute(newName);
    }

    public void setValueOff(String newValue, @Nullable String newName) {
        if (!this.isChecked()) {
            this.searcher.updateFacetRefinement(this.attribute, this.valueOff, false).updateFacetRefinement(newName != null ? newName : this.attribute, newValue, true).search();
        }
        this.valueOff = newValue;
        this.applyEventualNewAttribute(newName);
    }

    @Override
    protected CompoundButton.OnCheckedChangeListener getOnCheckedChangeListener() {
        this.searcher.updateFacetRefinement(this.attribute, this.valueOff, true);
        return new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                TwoValuesToggle.this.searcher.updateFacetRefinement(TwoValuesToggle.this.attribute, isChecked ? TwoValuesToggle.this.valueOn : TwoValuesToggle.this.valueOff, true).updateFacetRefinement(TwoValuesToggle.this.attribute, isChecked ? TwoValuesToggle.this.valueOff : TwoValuesToggle.this.valueOn, false).search();
            }
        };
    }

    @Override
    protected String applyTemplates(@NonNull SearchResults results) {
        return this.template.replace("{name}", this.attribute).replace("{value}", String.valueOf(this.currentValue()));
    }

    private String currentValue() {
        return this.isChecked() ? this.valueOn : this.valueOff;
    }

    @Override
    protected void updateRefinementWithNewName(String newName) {
        String valueRefined = this.currentValue();
        this.searcher.removeFacetRefinement(this.attribute, valueRefined).addFacetRefinement(newName, valueRefined).search();
    }

    @Subscribe
    public void onFacetRefinementEvent(FacetRefinementEvent event) {
        if (event.attribute.equals(this.attribute)) {
            if (event.value.equals(this.valueOn)) {
                if (this.isChecked() && event.operation == RefinementEvent.Operation.REMOVE) {
                    this.setChecked(false);
                } else if (!this.isChecked() && event.operation == RefinementEvent.Operation.ADD) {
                    this.setChecked(true);
                }
            } else if (event.value.equals(this.valueOff)) {
                if (!this.isChecked() && event.operation == RefinementEvent.Operation.REMOVE) {
                    this.setChecked(true);
                } else if (this.isChecked() && event.operation == RefinementEvent.Operation.ADD) {
                    this.setChecked(false);
                }
            }
        }
    }
}

