/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.utils;

import android.app.SearchableInfo;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.MenuItemCompat;
import android.support.v7.widget.SearchView;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.SearchView;

public class SearchViewFacade {
    private static final String ERROR_NO_SEARCHVIEW = "A SearchViewFacade should have at least one SearchView reference.";
    private android.widget.SearchView searchView;
    private SearchView supportView;

    public SearchViewFacade(android.widget.SearchView searchView) {
        this.searchView = searchView;
    }

    public SearchViewFacade(SearchView searchView) {
        this.supportView = searchView;
    }

    public SearchViewFacade(@NonNull Menu menu, int id2) {
        try {
            this.searchView = (android.widget.SearchView)menu.findItem(id2).getActionView();
        }
        catch (ClassCastException e) {
            this.supportView = (SearchView)MenuItemCompat.getActionView((MenuItem)menu.findItem(id2));
        }
    }

    public Object getSearchView() {
        if (this.searchView != null) {
            return this.searchView;
        }
        if (this.supportView != null) {
            return this.supportView;
        }
        throw new IllegalStateException(ERROR_NO_SEARCHVIEW);
    }

    public void clearFocus() {
        if (this.searchView != null) {
            this.searchView.clearFocus();
        } else if (this.supportView != null) {
            this.supportView.clearFocus();
        } else {
            throw new IllegalStateException(ERROR_NO_SEARCHVIEW);
        }
    }

    @Nullable
    public View findViewById(int id2) {
        if (this.searchView != null) {
            return this.searchView.findViewById(id2);
        }
        if (this.supportView != null) {
            return this.supportView.findViewById(id2);
        }
        throw new IllegalStateException(ERROR_NO_SEARCHVIEW);
    }

    @NonNull
    public Context getContext() {
        if (this.searchView != null) {
            return this.searchView.getContext();
        }
        if (this.supportView != null) {
            return this.supportView.getContext();
        }
        throw new IllegalStateException(ERROR_NO_SEARCHVIEW);
    }

    @NonNull
    public CharSequence getQuery() {
        if (this.searchView != null) {
            return this.searchView.getQuery();
        }
        if (this.supportView != null) {
            return this.supportView.getQuery();
        }
        throw new IllegalStateException(ERROR_NO_SEARCHVIEW);
    }

    public void setQuery(CharSequence query, boolean submit) {
        if (this.searchView != null) {
            this.searchView.setQuery(query, submit);
        } else if (this.supportView != null) {
            this.supportView.setQuery(query, submit);
        } else {
            throw new IllegalStateException(ERROR_NO_SEARCHVIEW);
        }
    }

    public void setSearchableInfo(SearchableInfo searchableInfo) {
        if (this.searchView != null) {
            this.searchView.setSearchableInfo(searchableInfo);
        } else if (this.supportView != null) {
            this.supportView.setSearchableInfo(searchableInfo);
        } else {
            throw new IllegalStateException(ERROR_NO_SEARCHVIEW);
        }
    }

    public void setIconifiedByDefault(boolean iconified) {
        if (this.searchView != null) {
            this.searchView.setIconifiedByDefault(iconified);
        } else if (this.supportView != null) {
            this.supportView.setIconifiedByDefault(iconified);
        } else {
            throw new IllegalStateException(ERROR_NO_SEARCHVIEW);
        }
    }

    public void setOnQueryTextListener(final @NonNull SearchView.OnQueryTextListener listener) {
        if (this.searchView != null) {
            this.searchView.setOnQueryTextListener(listener);
        } else if (this.supportView != null) {
            this.supportView.setOnQueryTextListener(new SearchView.OnQueryTextListener(){

                public boolean onQueryTextSubmit(String query) {
                    return listener.onQueryTextSubmit(query);
                }

                public boolean onQueryTextChange(String newText) {
                    return listener.onQueryTextChange(newText);
                }
            });
        } else {
            throw new IllegalStateException(ERROR_NO_SEARCHVIEW);
        }
    }

    public void setOnQueryTextListener(final @NonNull SearchView.OnQueryTextListener listener) {
        if (this.searchView != null) {
            this.searchView.setOnQueryTextListener(new SearchView.OnQueryTextListener(){

                public boolean onQueryTextSubmit(String query) {
                    return listener.onQueryTextSubmit(query);
                }

                public boolean onQueryTextChange(String newText) {
                    return listener.onQueryTextChange(newText);
                }
            });
        } else if (this.supportView != null) {
            this.supportView.setOnQueryTextListener(listener);
        } else {
            throw new IllegalStateException(ERROR_NO_SEARCHVIEW);
        }
    }

    public void setOnCloseListener(final @NonNull SearchView.OnCloseListener listener) {
        if (this.searchView != null) {
            this.searchView.setOnCloseListener(listener);
        } else if (this.supportView != null) {
            this.supportView.setOnCloseListener(new SearchView.OnCloseListener(){

                public boolean onClose() {
                    return listener.onClose();
                }
            });
        } else {
            throw new IllegalStateException(ERROR_NO_SEARCHVIEW);
        }
    }

    public void setOnCloseListener(final @NonNull SearchView.OnCloseListener listener) {
        if (this.searchView != null) {
            this.searchView.setOnCloseListener(new SearchView.OnCloseListener(){

                public boolean onClose() {
                    return listener.onClose();
                }
            });
        } else if (this.supportView != null) {
            this.supportView.setOnCloseListener(listener);
        } else {
            throw new IllegalStateException(ERROR_NO_SEARCHVIEW);
        }
    }
}

