/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.helper.hierarchical;

import com.algolia.instantsearch.core.connection.Connection;
import com.algolia.instantsearch.core.connection.ConnectionImpl;
import com.algolia.instantsearch.helper.filter.state.FilterState;
import com.algolia.instantsearch.helper.hierarchical.HierarchicalConnectionKt;
import com.algolia.instantsearch.helper.hierarchical.HierarchicalViewModel;
import com.algolia.instantsearch.helper.searcher.SearcherSingleIndex;
import com.algolia.search.model.Attribute;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B5\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u000eH\u00c6\u0003J\b\u0010\u001c\u001a\u00020\u001dH\u0016J'\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\b\u0010\u001f\u001a\u00020\u001dH\u0016J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\t\u0010&\u001a\u00020\u000bH\u00d6\u0001R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006'"}, d2={"Lcom/algolia/instantsearch/helper/hierarchical/HierarchicalConnector;", "Lcom/algolia/instantsearch/core/connection/ConnectionImpl;", "searcher", "Lcom/algolia/instantsearch/helper/searcher/SearcherSingleIndex;", "attribute", "Lcom/algolia/search/model/Attribute;", "filterState", "Lcom/algolia/instantsearch/helper/filter/state/FilterState;", "hierarchicalAttributes", "", "separator", "", "(Lcom/algolia/instantsearch/helper/searcher/SearcherSingleIndex;Lcom/algolia/search/model/Attribute;Lcom/algolia/instantsearch/helper/filter/state/FilterState;Ljava/util/List;Ljava/lang/String;)V", "viewModel", "Lcom/algolia/instantsearch/helper/hierarchical/HierarchicalViewModel;", "(Lcom/algolia/instantsearch/helper/searcher/SearcherSingleIndex;Lcom/algolia/instantsearch/helper/filter/state/FilterState;Lcom/algolia/instantsearch/helper/hierarchical/HierarchicalViewModel;)V", "connectionFilterState", "Lcom/algolia/instantsearch/core/connection/Connection;", "connectionSearcher", "getFilterState", "()Lcom/algolia/instantsearch/helper/filter/state/FilterState;", "getSearcher", "()Lcom/algolia/instantsearch/helper/searcher/SearcherSingleIndex;", "getViewModel", "()Lcom/algolia/instantsearch/helper/hierarchical/HierarchicalViewModel;", "component1", "component2", "component3", "connect", "", "copy", "disconnect", "equals", "", "other", "", "hashCode", "", "toString", "instantsearch-android_release"})
public final class HierarchicalConnector
extends ConnectionImpl {
    private final Connection connectionSearcher;
    private final Connection connectionFilterState;
    @NotNull
    private final SearcherSingleIndex searcher;
    @NotNull
    private final FilterState filterState;
    @NotNull
    private final HierarchicalViewModel viewModel;

    public void connect() {
        super.connect();
        this.connectionSearcher.connect();
        this.connectionFilterState.connect();
    }

    public void disconnect() {
        super.disconnect();
        this.connectionSearcher.disconnect();
        this.connectionFilterState.disconnect();
    }

    @NotNull
    public final SearcherSingleIndex getSearcher() {
        return this.searcher;
    }

    @NotNull
    public final FilterState getFilterState() {
        return this.filterState;
    }

    @NotNull
    public final HierarchicalViewModel getViewModel() {
        return this.viewModel;
    }

    public HierarchicalConnector(@NotNull SearcherSingleIndex searcher, @NotNull FilterState filterState, @NotNull HierarchicalViewModel viewModel) {
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        Intrinsics.checkNotNullParameter((Object)filterState, (String)"filterState");
        Intrinsics.checkNotNullParameter((Object)((Object)viewModel), (String)"viewModel");
        this.searcher = searcher;
        this.filterState = filterState;
        this.viewModel = viewModel;
        this.connectionSearcher = HierarchicalConnectionKt.connectSearcher(this.viewModel, this.searcher);
        this.connectionFilterState = HierarchicalConnectionKt.connectFilterState(this.viewModel, this.filterState);
    }

    public HierarchicalConnector(@NotNull SearcherSingleIndex searcher, @NotNull Attribute attribute, @NotNull FilterState filterState, @NotNull List<Attribute> hierarchicalAttributes, @NotNull String separator) {
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)filterState, (String)"filterState");
        Intrinsics.checkNotNullParameter(hierarchicalAttributes, (String)"hierarchicalAttributes");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        this(searcher, filterState, new HierarchicalViewModel(attribute, hierarchicalAttributes, separator, null, 8, null));
    }

    @NotNull
    public final SearcherSingleIndex component1() {
        return this.searcher;
    }

    @NotNull
    public final FilterState component2() {
        return this.filterState;
    }

    @NotNull
    public final HierarchicalViewModel component3() {
        return this.viewModel;
    }

    @NotNull
    public final HierarchicalConnector copy(@NotNull SearcherSingleIndex searcher, @NotNull FilterState filterState, @NotNull HierarchicalViewModel viewModel) {
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        Intrinsics.checkNotNullParameter((Object)filterState, (String)"filterState");
        Intrinsics.checkNotNullParameter((Object)((Object)viewModel), (String)"viewModel");
        return new HierarchicalConnector(searcher, filterState, viewModel);
    }

    public static /* synthetic */ HierarchicalConnector copy$default(HierarchicalConnector hierarchicalConnector, SearcherSingleIndex searcherSingleIndex, FilterState filterState, HierarchicalViewModel hierarchicalViewModel, int n, Object object) {
        if ((n & 1) != 0) {
            searcherSingleIndex = hierarchicalConnector.searcher;
        }
        if ((n & 2) != 0) {
            filterState = hierarchicalConnector.filterState;
        }
        if ((n & 4) != 0) {
            hierarchicalViewModel = hierarchicalConnector.viewModel;
        }
        return hierarchicalConnector.copy(searcherSingleIndex, filterState, hierarchicalViewModel);
    }

    @NotNull
    public String toString() {
        return "HierarchicalConnector(searcher=" + this.searcher + ", filterState=" + this.filterState + ", viewModel=" + (Object)((Object)this.viewModel) + ")";
    }

    public int hashCode() {
        SearcherSingleIndex searcherSingleIndex = this.searcher;
        FilterState filterState = this.filterState;
        HierarchicalViewModel hierarchicalViewModel = this.viewModel;
        return ((searcherSingleIndex != null ? searcherSingleIndex.hashCode() : 0) * 31 + (filterState != null ? ((Object)filterState).hashCode() : 0)) * 31 + (hierarchicalViewModel != null ? ((Object)((Object)hierarchicalViewModel)).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof HierarchicalConnector)) break block3;
                HierarchicalConnector hierarchicalConnector = (HierarchicalConnector)((Object)object);
                if (!Intrinsics.areEqual((Object)this.searcher, (Object)hierarchicalConnector.searcher) || !Intrinsics.areEqual((Object)this.filterState, (Object)hierarchicalConnector.filterState) || !Intrinsics.areEqual((Object)((Object)this.viewModel), (Object)((Object)hierarchicalConnector.viewModel))) break block3;
            }
            return true;
        }
        return false;
    }
}

