/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.hierarchical;

import com.algolia.instantsearch.core.subscription.SubscriptionEvent;
import com.algolia.instantsearch.core.subscription.SubscriptionValue;
import com.algolia.instantsearch.core.tree.Tree;
import com.algolia.instantsearch.core.tree.TreeViewModel;
import com.algolia.instantsearch.extension.TelemetryKt;
import com.algolia.search.model.Attribute;
import com.algolia.search.model.search.Facet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B7\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\u0012\b\u0002\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u00030\nj\u0002`\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0002H\u0016J\u0012\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007*\u00020\u0002H\u0002JV\u0010#\u001a\u0018\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u00110\u0007j\u0002`\u0012*\u0018\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u00110\u0007j\u0002`\u00122\u001c\u0010$\u001a\u0018\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u00110\u0007j\u0002`\u0012H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR-\u0010\u000f\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u00110\u0007j\u0002`\u00120\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R0\u0010\u0017\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u00110\u0007j\u0002`\u00120\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001d\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00070\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\u0011\u0010\b\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006%"}, d2={"Lcom/algolia/instantsearch/hierarchical/HierarchicalViewModel;", "Lcom/algolia/instantsearch/core/tree/TreeViewModel;", "", "Lcom/algolia/search/model/search/Facet;", "attribute", "Lcom/algolia/search/model/Attribute;", "hierarchicalAttributes", "", "separator", "tree", "Lcom/algolia/instantsearch/core/tree/Tree;", "Lcom/algolia/instantsearch/hierarchical/HierarchicalTree;", "(Lcom/algolia/search/model/Attribute;Ljava/util/List;Ljava/lang/String;Lcom/algolia/instantsearch/core/tree/Tree;)V", "getAttribute", "()Lcom/algolia/search/model/Attribute;", "eventHierarchicalPath", "Lcom/algolia/instantsearch/core/subscription/SubscriptionEvent;", "Lkotlin/Pair;", "Lcom/algolia/instantsearch/hierarchical/HierarchicalPath;", "getEventHierarchicalPath", "()Lcom/algolia/instantsearch/core/subscription/SubscriptionEvent;", "getHierarchicalAttributes", "()Ljava/util/List;", "hierarchicalPath", "Lcom/algolia/instantsearch/core/subscription/SubscriptionValue;", "getHierarchicalPath$instantsearch_release", "()Lcom/algolia/instantsearch/core/subscription/SubscriptionValue;", "selections", "getSelections", "getSeparator", "()Ljava/lang/String;", "computeSelections", "", "key", "toSelectionList", "updateIfDeselect", "current", "instantsearch_release"})
public class HierarchicalViewModel
extends TreeViewModel<String, Facet> {
    @NotNull
    private final Attribute attribute;
    @NotNull
    private final List<Attribute> hierarchicalAttributes;
    @NotNull
    private final String separator;
    @NotNull
    private final SubscriptionValue<List<String>> selections;
    @NotNull
    private final SubscriptionEvent<List<Pair<Attribute, String>>> eventHierarchicalPath;
    @NotNull
    private final SubscriptionValue<List<Pair<Attribute, String>>> hierarchicalPath;

    public HierarchicalViewModel(@NotNull Attribute attribute, @NotNull List<Attribute> hierarchicalAttributes, @NotNull String separator, @NotNull Tree<Facet> tree) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter(hierarchicalAttributes, (String)"hierarchicalAttributes");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Intrinsics.checkNotNullParameter(tree, (String)"tree");
        super(tree);
        this.attribute = attribute;
        this.hierarchicalAttributes = hierarchicalAttributes;
        this.separator = separator;
        this.selections = new SubscriptionValue((Object)CollectionsKt.emptyList());
        this.eventHierarchicalPath = new SubscriptionEvent();
        this.hierarchicalPath = new SubscriptionValue((Object)CollectionsKt.emptyList());
        if (this.hierarchicalAttributes.isEmpty()) {
            throw new IllegalArgumentException("HierarchicalAttributes should not be empty");
        }
        TelemetryKt.traceHierarchicalFacets();
    }

    public /* synthetic */ HierarchicalViewModel(Attribute attribute, List list, String string, Tree tree, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            tree = new Tree(null, 1, null);
        }
        this(attribute, list, string, (Tree<Facet>)tree);
    }

    @NotNull
    public final Attribute getAttribute() {
        return this.attribute;
    }

    @NotNull
    public final List<Attribute> getHierarchicalAttributes() {
        return this.hierarchicalAttributes;
    }

    @NotNull
    public final String getSeparator() {
        return this.separator;
    }

    @NotNull
    public final SubscriptionValue<List<String>> getSelections() {
        return this.selections;
    }

    @NotNull
    public final SubscriptionEvent<List<Pair<Attribute, String>>> getEventHierarchicalPath() {
        return this.eventHierarchicalPath;
    }

    @NotNull
    public final SubscriptionValue<List<Pair<Attribute, String>>> getHierarchicalPath$instantsearch_release() {
        return this.hierarchicalPath;
    }

    /*
     * WARNING - void declaration
     */
    public void computeSelections(@NotNull String key) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        List<String> selections = this.toSelectionList(key);
        Iterable iterable = this.hierarchicalAttributes;
        HierarchicalViewModel hierarchicalViewModel = this;
        boolean $i$f$mapIndexed = false;
        void var6_6 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            Pair pair;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Attribute attribute = (Attribute)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if ((String)CollectionsKt.getOrNull(selections, (int)index) == null) {
                pair = null;
            } else {
                String it;
                void item;
                boolean bl2 = false;
                pair = TuplesKt.to((Object)item, (Object)it);
            }
            collection.add(pair);
        }
        List<Pair<Attribute, String>> updatedHierarchicalPath = hierarchicalViewModel.updateIfDeselect(CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)), (List)this.hierarchicalPath.getValue());
        this.hierarchicalPath.setValue(updatedHierarchicalPath);
        this.eventHierarchicalPath.send(updatedHierarchicalPath);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> toSelectionList(String $this$toSelectionList) {
        void $this$fold$iv;
        Object object = new String[]{this.separator};
        object = StringsKt.split$default((CharSequence)$this$toSelectionList, (String[])object, (boolean)false, (int)0, (int)6, null);
        List initial$iv = CollectionsKt.emptyList();
        boolean $i$f$fold = false;
        List accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void s;
            String string = (String)element$iv;
            List acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = CollectionsKt.plus((Collection)acc, (Object)(acc.isEmpty() ? s : (String)CollectionsKt.last((List)acc) + this.getSeparator() + (String)s));
        }
        return accumulator$iv;
    }

    private final List<Pair<Attribute, String>> updateIfDeselect(List<Pair<Attribute, String>> $this$updateIfDeselect, List<Pair<Attribute, String>> current) {
        if (!Intrinsics.areEqual($this$updateIfDeselect, current)) {
            return $this$updateIfDeselect;
        }
        return CollectionsKt.dropLast($this$updateIfDeselect, (int)1);
    }
}

