/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.hierarchical.internal;

import com.algolia.instantsearch.core.connection.AbstractConnection;
import com.algolia.instantsearch.core.subscription.SubscriptionValue;
import com.algolia.instantsearch.hierarchical.HierarchicalViewModel;
import com.algolia.instantsearch.hierarchical.internal.ExtensionsKt;
import com.algolia.instantsearch.searcher.SearcherForHits;
import com.algolia.search.model.Attribute;
import com.algolia.search.model.response.ResponseSearch;
import com.algolia.search.model.search.Facet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0010\u001a\u00020\u0003H\u00c2\u0003J\r\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0005H\u00c2\u0003J\b\u0010\u0012\u001a\u00020\u000eH\u0016J!\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u00c6\u0001J\b\u0010\u0014\u001a\u00020\u000eH\u0016J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\bH\u00d6\u0001J$\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e0\u001d*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e0\u001dH\u0002R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR(\u0010\u000b\u001a\u001c\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u000e0\fj\n\u0012\u0006\u0012\u0004\u0018\u00010\r`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/algolia/instantsearch/hierarchical/internal/HierarchicalConnectionSearcher;", "Lcom/algolia/instantsearch/core/connection/AbstractConnection;", "viewModel", "Lcom/algolia/instantsearch/hierarchical/HierarchicalViewModel;", "searcher", "Lcom/algolia/instantsearch/searcher/SearcherForHits;", "(Lcom/algolia/instantsearch/hierarchical/HierarchicalViewModel;Lcom/algolia/instantsearch/searcher/SearcherForHits;)V", "selectedHierarchicalValue", "", "getSelectedHierarchicalValue", "()Ljava/lang/String;", "updateTree", "Lkotlin/Function1;", "Lcom/algolia/search/model/response/ResponseSearch;", "", "Lcom/algolia/instantsearch/core/Callback;", "component1", "component2", "connect", "copy", "disconnect", "equals", "", "other", "", "hashCode", "", "toString", "filterUnprefixed", "", "", "Lcom/algolia/search/model/search/Facet;", "instantsearch_release"})
@SourceDebugExtension(value={"SMAP\nHierarchicalConnectionSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HierarchicalConnectionSearcher.kt\ncom/algolia/instantsearch/hierarchical/internal/HierarchicalConnectionSearcher\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n37#2,2:71\n1864#3,3:73\n*S KotlinDebug\n*F\n+ 1 HierarchicalConnectionSearcher.kt\ncom/algolia/instantsearch/hierarchical/internal/HierarchicalConnectionSearcher\n*L\n57#1:71,2\n42#1:73,3\n*E\n"})
public final class HierarchicalConnectionSearcher
extends AbstractConnection {
    @NotNull
    private final HierarchicalViewModel viewModel;
    @NotNull
    private final SearcherForHits<?> searcher;
    @NotNull
    private final Function1<ResponseSearch, Unit> updateTree;

    public HierarchicalConnectionSearcher(@NotNull HierarchicalViewModel viewModel, @NotNull SearcherForHits<?> searcher) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewModel), (String)"viewModel");
        Intrinsics.checkNotNullParameter(searcher, (String)"searcher");
        this.viewModel = viewModel;
        this.searcher = searcher;
        this.updateTree = (Function1)new Function1<ResponseSearch, Unit>(this){
            final /* synthetic */ HierarchicalConnectionSearcher this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@Nullable ResponseSearch response) {
                if (response != null) {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    Attribute it;
                    Map map = response.getHierarchicalFacetsOrNull();
                    if (map == null) {
                        Map map2;
                        Map map3 = response.getFacetsOrNull();
                        if (map3 != null) {
                            void $this$filterTo$iv$iv;
                            void $this$filter$iv;
                            Map map4 = map3;
                            HierarchicalConnectionSearcher hierarchicalConnectionSearcher = this.this$0;
                            boolean $i$f$filter = false;
                            void var9_7 = $this$filter$iv;
                            Map destination$iv$iv = new LinkedHashMap<K, V>();
                            boolean $i$f$filterTo = false;
                            Iterator<Map.Entry<K, V>> iterator = $this$filterTo$iv$iv.entrySet().iterator();
                            while (iterator.hasNext()) {
                                Attribute element$iv$iv;
                                it = element$iv$iv = iterator.next();
                                boolean bl = false;
                                if (!Intrinsics.areEqual(it.getKey(), (Object)CollectionsKt.first(HierarchicalConnectionSearcher.access$getViewModel$p(hierarchicalConnectionSearcher).getHierarchicalAttributes()))) continue;
                                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                            }
                            map2 = destination$iv$iv;
                        } else {
                            map2 = map = null;
                        }
                        if (map2 == null) {
                            map = MapsKt.emptyMap();
                        }
                    }
                    Map facets2 = map;
                    Iterable iterable = HierarchicalConnectionSearcher.access$getViewModel$p(this.this$0).getHierarchicalAttributes();
                    HierarchicalConnectionSearcher hierarchicalConnectionSearcher = this.this$0;
                    SubscriptionValue subscriptionValue = HierarchicalConnectionSearcher.access$getViewModel$p(this.this$0).getTree();
                    boolean $i$f$mapNotNull = false;
                    void var5_22 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        List<E> it$iv$iv;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        it = (Attribute)element$iv$iv;
                        boolean bl2 = false;
                        List list = (List)facets2.get(it);
                        if ((list != null ? CollectionsKt.toMutableList((Collection)list) : null) == null) continue;
                        it$iv$iv = it$iv$iv;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List list = (List)destination$iv$iv;
                    subscriptionValue.setValue(ExtensionsKt.toNodes(CollectionsKt.flatten((Iterable)HierarchicalConnectionSearcher.access$filterUnprefixed(hierarchicalConnectionSearcher, list)), HierarchicalConnectionSearcher.access$getSelectedHierarchicalValue(this.this$0), HierarchicalConnectionSearcher.access$getViewModel$p(this.this$0).getSeparator()));
                }
            }
        };
        Collection $this$toTypedArray$iv = this.viewModel.getHierarchicalAttributes();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Attribute[] attributeArray = thisCollection$iv.toArray(new Attribute[0]);
        com.algolia.instantsearch.searcher.ExtensionsKt.addFacet(this.searcher.getQuery(), Arrays.copyOf(attributeArray, attributeArray.length));
    }

    private final List<List<Facet>> filterUnprefixed(List<? extends List<Facet>> $this$filterUnprefixed) {
        Iterable $this$forEachIndexed$iv = (Iterable)this.viewModel.getHierarchicalPath$instantsearch_release().getValue();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pair pair = (Pair)item$iv;
            int index = n;
            boolean bl = false;
            String item = (String)pair.component2();
            List list = (List)CollectionsKt.getOrNull($this$filterUnprefixed, (int)(index + 1));
            if (list == null) continue;
            CollectionsKt.removeAll((List)list, (Function1)((Function1)new Function1<Facet, Boolean>(item){
                final /* synthetic */ String $item;
                {
                    this.$item = $item;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Facet it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return !StringsKt.startsWith$default((String)it.getValue(), (String)this.$item, (boolean)false, (int)2, null);
                }
            }));
        }
        return $this$filterUnprefixed;
    }

    private final String getSelectedHierarchicalValue() {
        List value = (List)this.viewModel.getSelections().getValue();
        if (value.isEmpty()) {
            return null;
        }
        return CollectionsKt.joinToString$default((Iterable)value, (CharSequence)this.viewModel.getSeparator(), null, null, (int)0, null, null, (int)62, null);
    }

    public void connect() {
        super.connect();
        this.searcher.getResponse().subscribe(this.updateTree);
    }

    public void disconnect() {
        super.disconnect();
        this.searcher.getResponse().unsubscribe(this.updateTree);
    }

    private final HierarchicalViewModel component1() {
        return this.viewModel;
    }

    private final SearcherForHits<?> component2() {
        return this.searcher;
    }

    @NotNull
    public final HierarchicalConnectionSearcher copy(@NotNull HierarchicalViewModel viewModel, @NotNull SearcherForHits<?> searcher) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewModel), (String)"viewModel");
        Intrinsics.checkNotNullParameter(searcher, (String)"searcher");
        return new HierarchicalConnectionSearcher(viewModel, searcher);
    }

    public static /* synthetic */ HierarchicalConnectionSearcher copy$default(HierarchicalConnectionSearcher hierarchicalConnectionSearcher, HierarchicalViewModel hierarchicalViewModel, SearcherForHits searcherForHits, int n, Object object) {
        if ((n & 1) != 0) {
            hierarchicalViewModel = hierarchicalConnectionSearcher.viewModel;
        }
        if ((n & 2) != 0) {
            searcherForHits = hierarchicalConnectionSearcher.searcher;
        }
        return hierarchicalConnectionSearcher.copy(hierarchicalViewModel, searcherForHits);
    }

    @NotNull
    public String toString() {
        return "HierarchicalConnectionSearcher(viewModel=" + (Object)((Object)this.viewModel) + ", searcher=" + this.searcher + ')';
    }

    public int hashCode() {
        int result = this.viewModel.hashCode();
        result = result * 31 + this.searcher.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HierarchicalConnectionSearcher)) {
            return false;
        }
        HierarchicalConnectionSearcher hierarchicalConnectionSearcher = (HierarchicalConnectionSearcher)((Object)other);
        if (!Intrinsics.areEqual((Object)((Object)this.viewModel), (Object)((Object)hierarchicalConnectionSearcher.viewModel))) {
            return false;
        }
        return Intrinsics.areEqual(this.searcher, hierarchicalConnectionSearcher.searcher);
    }

    public static final /* synthetic */ HierarchicalViewModel access$getViewModel$p(HierarchicalConnectionSearcher $this) {
        return $this.viewModel;
    }

    public static final /* synthetic */ List access$filterUnprefixed(HierarchicalConnectionSearcher $this, List $receiver) {
        return $this.filterUnprefixed($receiver);
    }

    public static final /* synthetic */ String access$getSelectedHierarchicalValue(HierarchicalConnectionSearcher $this) {
        return $this.getSelectedHierarchicalValue();
    }
}

