/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.instantsearch.searchbox;

import com.algolia.instantsearch.core.connection.AbstractConnection;
import com.algolia.instantsearch.core.connection.Connection;
import com.algolia.instantsearch.core.searchbox.SearchBoxViewModel;
import com.algolia.instantsearch.core.searcher.Debouncer;
import com.algolia.instantsearch.core.searcher.Searcher;
import com.algolia.instantsearch.extension.TelemetryKt;
import com.algolia.instantsearch.searchbox.SearchBoxConnectionKt;
import com.algolia.instantsearch.searchbox.SearchMode;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B;\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001e\u001a\u00020\fH\u00c6\u0003J\b\u0010\u001f\u001a\u00020 H\u0016JG\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\b\u0010\"\u001a\u00020 H\u0016J\u0013\u0010#\u001a\u00020\f2\b\u0010$\u001a\u0004\u0018\u00010%H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020)H\u00d6\u0001R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006*"}, d2={"Lcom/algolia/instantsearch/searchbox/SearchBoxConnector;", "R", "Lcom/algolia/instantsearch/core/connection/AbstractConnection;", "searcher", "Lcom/algolia/instantsearch/core/searcher/Searcher;", "viewModel", "Lcom/algolia/instantsearch/core/searchbox/SearchBoxViewModel;", "searchMode", "Lcom/algolia/instantsearch/searchbox/SearchMode;", "debouncer", "Lcom/algolia/instantsearch/core/searcher/Debouncer;", "searchOnQueryUpdate", "", "(Lcom/algolia/instantsearch/core/searcher/Searcher;Lcom/algolia/instantsearch/core/searchbox/SearchBoxViewModel;Lcom/algolia/instantsearch/searchbox/SearchMode;Lcom/algolia/instantsearch/core/searcher/Debouncer;Z)V", "connectionSearcher", "Lcom/algolia/instantsearch/core/connection/Connection;", "getDebouncer", "()Lcom/algolia/instantsearch/core/searcher/Debouncer;", "getSearchMode", "()Lcom/algolia/instantsearch/searchbox/SearchMode;", "getSearchOnQueryUpdate", "()Z", "getSearcher", "()Lcom/algolia/instantsearch/core/searcher/Searcher;", "getViewModel", "()Lcom/algolia/instantsearch/core/searchbox/SearchBoxViewModel;", "component1", "component2", "component3", "component4", "component5", "connect", "", "copy", "disconnect", "equals", "other", "", "hashCode", "", "toString", "", "instantsearch_release"})
public final class SearchBoxConnector<R>
extends AbstractConnection {
    @NotNull
    private final Searcher<R> searcher;
    @NotNull
    private final SearchBoxViewModel viewModel;
    @NotNull
    private final SearchMode searchMode;
    @NotNull
    private final Debouncer debouncer;
    private final boolean searchOnQueryUpdate;
    @NotNull
    private final Connection connectionSearcher;

    public SearchBoxConnector(@NotNull Searcher<R> searcher, @NotNull SearchBoxViewModel viewModel, @NotNull SearchMode searchMode, @NotNull Debouncer debouncer, boolean searchOnQueryUpdate) {
        Intrinsics.checkNotNullParameter(searcher, (String)"searcher");
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)((Object)searchMode), (String)"searchMode");
        Intrinsics.checkNotNullParameter((Object)debouncer, (String)"debouncer");
        this.searcher = searcher;
        this.viewModel = viewModel;
        this.searchMode = searchMode;
        this.debouncer = debouncer;
        this.searchOnQueryUpdate = searchOnQueryUpdate;
        this.connectionSearcher = SearchBoxConnectionKt.connectSearcher(this.viewModel, this.searcher, this.searchMode, this.debouncer, this.searchOnQueryUpdate);
        TelemetryKt.traceSearchBoxConnector(this);
    }

    public /* synthetic */ SearchBoxConnector(Searcher searcher, SearchBoxViewModel searchBoxViewModel, SearchMode searchMode, Debouncer debouncer, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            searchBoxViewModel = new SearchBoxViewModel();
        }
        if ((n & 4) != 0) {
            searchMode = SearchMode.AsYouType;
        }
        if ((n & 8) != 0) {
            debouncer = new Debouncer(100L);
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        this(searcher, searchBoxViewModel, searchMode, debouncer, bl);
    }

    @NotNull
    public final Searcher<R> getSearcher() {
        return this.searcher;
    }

    @NotNull
    public final SearchBoxViewModel getViewModel() {
        return this.viewModel;
    }

    @NotNull
    public final SearchMode getSearchMode() {
        return this.searchMode;
    }

    @NotNull
    public final Debouncer getDebouncer() {
        return this.debouncer;
    }

    public final boolean getSearchOnQueryUpdate() {
        return this.searchOnQueryUpdate;
    }

    public void connect() {
        super.connect();
        this.connectionSearcher.connect();
    }

    public void disconnect() {
        super.disconnect();
        this.connectionSearcher.disconnect();
    }

    @NotNull
    public final Searcher<R> component1() {
        return this.searcher;
    }

    @NotNull
    public final SearchBoxViewModel component2() {
        return this.viewModel;
    }

    @NotNull
    public final SearchMode component3() {
        return this.searchMode;
    }

    @NotNull
    public final Debouncer component4() {
        return this.debouncer;
    }

    public final boolean component5() {
        return this.searchOnQueryUpdate;
    }

    @NotNull
    public final SearchBoxConnector<R> copy(@NotNull Searcher<R> searcher, @NotNull SearchBoxViewModel viewModel, @NotNull SearchMode searchMode, @NotNull Debouncer debouncer, boolean searchOnQueryUpdate) {
        Intrinsics.checkNotNullParameter(searcher, (String)"searcher");
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)((Object)searchMode), (String)"searchMode");
        Intrinsics.checkNotNullParameter((Object)debouncer, (String)"debouncer");
        return new SearchBoxConnector<R>(searcher, viewModel, searchMode, debouncer, searchOnQueryUpdate);
    }

    public static /* synthetic */ SearchBoxConnector copy$default(SearchBoxConnector searchBoxConnector, Searcher searcher, SearchBoxViewModel searchBoxViewModel, SearchMode searchMode, Debouncer debouncer, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            searcher = searchBoxConnector.searcher;
        }
        if ((n & 2) != 0) {
            searchBoxViewModel = searchBoxConnector.viewModel;
        }
        if ((n & 4) != 0) {
            searchMode = searchBoxConnector.searchMode;
        }
        if ((n & 8) != 0) {
            debouncer = searchBoxConnector.debouncer;
        }
        if ((n & 0x10) != 0) {
            bl = searchBoxConnector.searchOnQueryUpdate;
        }
        return searchBoxConnector.copy(searcher, searchBoxViewModel, searchMode, debouncer, bl);
    }

    @NotNull
    public String toString() {
        return "SearchBoxConnector(searcher=" + this.searcher + ", viewModel=" + this.viewModel + ", searchMode=" + (Object)((Object)this.searchMode) + ", debouncer=" + this.debouncer + ", searchOnQueryUpdate=" + this.searchOnQueryUpdate + ')';
    }

    public int hashCode() {
        int result = this.searcher.hashCode();
        result = result * 31 + this.viewModel.hashCode();
        result = result * 31 + this.searchMode.hashCode();
        result = result * 31 + this.debouncer.hashCode();
        int n = this.searchOnQueryUpdate ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SearchBoxConnector)) {
            return false;
        }
        SearchBoxConnector searchBoxConnector = (SearchBoxConnector)((Object)other);
        if (!Intrinsics.areEqual(this.searcher, searchBoxConnector.searcher)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.viewModel, (Object)searchBoxConnector.viewModel)) {
            return false;
        }
        if (this.searchMode != searchBoxConnector.searchMode) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.debouncer, (Object)searchBoxConnector.debouncer)) {
            return false;
        }
        return this.searchOnQueryUpdate == searchBoxConnector.searchOnQueryUpdate;
    }
}

