/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.instruction.op;

import com.ql.util.express.ArraySwap;
import com.ql.util.express.DynamicParamsUtil;
import com.ql.util.express.ExpressUtil;
import com.ql.util.express.InstructionSetContext;
import com.ql.util.express.OperateData;
import com.ql.util.express.instruction.OperateDataCacheManager;
import com.ql.util.express.instruction.op.CanClone;
import com.ql.util.express.instruction.op.OperatorBase;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class OperatorSelfDefineClassFunction
extends OperatorBase
implements CanClone {
    private final String functionName;
    private final String[] parameterTypes;
    private final Class<?>[] parameterClasses;
    private final Class<?> operatorClass;
    private Object operatorInstance;
    private final Method method;
    private boolean isReturnVoid;
    private final boolean maybeDynamicParams;

    public OperatorSelfDefineClassFunction(String operatorName, Class<?> operatorClass, String functionName, Class<?>[] parameterClassTypes, String[] parameterDesc, String[] parameterAnnotation, String errorInfo) throws Exception {
        this.name = operatorName;
        this.errorInfo = errorInfo;
        this.functionName = functionName;
        this.parameterClasses = parameterClassTypes;
        this.parameterTypes = new String[parameterClassTypes.length];
        this.operateDataDesc = parameterDesc;
        this.operateDataAnnotation = parameterAnnotation;
        for (int i = 0; i < this.parameterClasses.length; ++i) {
            this.parameterTypes[i] = this.parameterClasses[i].getName();
        }
        this.operatorClass = operatorClass;
        this.method = this.operatorClass.getMethod(functionName, this.parameterClasses);
        this.isReturnVoid = this.method.getReturnType().equals(Void.TYPE);
        this.maybeDynamicParams = DynamicParamsUtil.maybeDynamicParams(this.parameterClasses);
    }

    public OperatorSelfDefineClassFunction(String operatorName, String className, String functionName, Class<?>[] parameterClassTypes, String[] parameterDesc, String[] parameterAnnotation, String errorInfo) throws Exception {
        this.name = operatorName;
        this.errorInfo = errorInfo;
        this.functionName = functionName;
        this.parameterClasses = parameterClassTypes;
        this.parameterTypes = new String[parameterClassTypes.length];
        this.operateDataDesc = parameterDesc;
        this.operateDataAnnotation = parameterAnnotation;
        for (int i = 0; i < this.parameterClasses.length; ++i) {
            this.parameterTypes[i] = this.parameterClasses[i].getName();
        }
        this.operatorClass = ExpressUtil.getJavaClass(className);
        this.method = this.operatorClass.getMethod(functionName, this.parameterClasses);
        this.isReturnVoid = this.method.getReturnType().equals(Void.TYPE);
        this.maybeDynamicParams = DynamicParamsUtil.maybeDynamicParams(this.parameterClasses);
    }

    public OperatorSelfDefineClassFunction(String operatorName, String className, String functionName, String[] parameterTypes, String[] parameterDesc, String[] parameterAnnotation, String errorInfo) throws Exception {
        this.name = operatorName;
        this.errorInfo = errorInfo;
        this.functionName = functionName;
        this.parameterTypes = parameterTypes;
        this.operateDataDesc = parameterDesc;
        this.operateDataAnnotation = parameterAnnotation;
        this.parameterClasses = new Class[this.parameterTypes.length];
        for (int i = 0; i < this.parameterClasses.length; ++i) {
            this.parameterClasses[i] = ExpressUtil.getJavaClass(this.parameterTypes[i]);
        }
        this.operatorClass = ExpressUtil.getJavaClass(className);
        this.method = this.operatorClass.getMethod(functionName, this.parameterClasses);
        this.maybeDynamicParams = DynamicParamsUtil.maybeDynamicParams(this.parameterClasses);
    }

    @Override
    public OperatorBase cloneMe(String opName, String errorInfo) throws Exception {
        return new OperatorSelfDefineClassFunction(opName, this.operatorClass.getName(), this.functionName, this.parameterClasses, this.operateDataDesc, this.operateDataAnnotation, errorInfo);
    }

    @Override
    public OperateData executeInner(InstructionSetContext parent, ArraySwap list) throws Exception {
        Object obj;
        Object[] parameters = DynamicParamsUtil.transferDynamicParams(parent, list, this.parameterClasses, this.maybeDynamicParams);
        if (Modifier.isStatic(this.method.getModifiers())) {
            obj = this.method.invoke(null, ExpressUtil.transferArray(parameters, this.parameterClasses));
        } else {
            if (this.operatorInstance == null) {
                this.operatorInstance = this.operatorClass.newInstance();
            }
            obj = this.method.invoke(this.operatorInstance, ExpressUtil.transferArray(parameters, this.parameterClasses));
        }
        if (obj != null) {
            return OperateDataCacheManager.fetchOperateData(obj, obj.getClass());
        }
        if (this.isReturnVoid) {
            return OperateDataCacheManager.fetchOperateDataAttr("null", Void.TYPE);
        }
        return OperateDataCacheManager.fetchOperateDataAttr("null", null);
    }
}

