/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.parse;

import com.ql.util.express.exception.QLCompileException;
import com.ql.util.express.parse.Word;
import java.util.ArrayList;
import java.util.Arrays;

public class WordSplit {
    private WordSplit() {
        throw new IllegalStateException("Utility class");
    }

    public static Word[] parse(String[] splitWord, String str) throws Exception {
        if (str == null) {
            return new Word[0];
        }
        int line = 1;
        ArrayList<Word> list = new ArrayList<Word>();
        int i = 0;
        int point = 0;
        int currentLineOffset = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '\"' || c == '\'') {
                int index = str.indexOf(c, i + 1);
                while (index > 0 && str.charAt(index - 1) == '\\') {
                    index = str.indexOf(c, index + 1);
                }
                if (index < 0) {
                    throw new QLCompileException("\u5b57\u7b26\u4e32\u6ca1\u6709\u5173\u95ed");
                }
                String tempDealStr = str.substring(i, index + 1);
                StringBuilder tmpResult = new StringBuilder();
                int tmpPoint = tempDealStr.indexOf("\\");
                while (tmpPoint >= 0) {
                    tmpResult.append(tempDealStr, 0, tmpPoint);
                    if (tmpPoint == tempDealStr.length() - 1) {
                        throw new QLCompileException("\u5b57\u7b26\u4e32\u4e2d\u7684\\\u9519\u8bef:" + tempDealStr);
                    }
                    tmpResult.append(tempDealStr.charAt(tmpPoint + 1));
                    tempDealStr = tempDealStr.substring(tmpPoint + 2);
                    tmpPoint = tempDealStr.indexOf("\\");
                }
                tmpResult.append(tempDealStr);
                list.add(new Word(tmpResult.toString(), line, i - currentLineOffset + 1));
                if (point < i) {
                    list.add(new Word(str.substring(point, i), line, point - currentLineOffset + 1));
                }
                point = i = index + 1;
                continue;
            }
            if (c == '.' && point < i && WordSplit.isNumber(str.substring(point, i))) {
                ++i;
                continue;
            }
            if (c == ' ' || c == '\r' || c == '\n' || c == '\t' || c == '\f') {
                if (point < i) {
                    list.add(new Word(str.substring(point, i), line, point - currentLineOffset + 1));
                }
                if (c == '\n') {
                    ++line;
                    currentLineOffset = i + 1;
                }
                point = ++i;
                continue;
            }
            boolean isFind = false;
            for (String s : splitWord) {
                int length = s.length();
                if (i + length > str.length() || !str.substring(i, i + length).equals(s)) continue;
                if (point < i) {
                    list.add(new Word(str.substring(point, i), line, point - currentLineOffset + 1));
                }
                list.add(new Word(str.substring(i, i + length), line, i - currentLineOffset + 1));
                point = i += length;
                isFind = true;
                break;
            }
            if (isFind) continue;
            ++i;
        }
        if (point < i) {
            list.add(new Word(str.substring(point, i), line, point - currentLineOffset + 1));
        }
        Word[] result = new Word[list.size()];
        list.toArray(result);
        return result;
    }

    public static void sortSplitWord(String[] splitWord) {
        Arrays.sort(splitWord, (o1, o2) -> Integer.compare(o2.length(), o1.length()));
    }

    protected static boolean isNumber(String str) {
        if (str == null || "".equals(str)) {
            return false;
        }
        char c = str.charAt(0);
        return c >= '0' && c <= '9';
    }

    public static String getPrintInfo(Object[] list, String splitOp) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < list.length; ++i) {
            if (i > 0) {
                buffer.append(splitOp);
            }
            buffer.append("{").append(list[i]).append("}");
        }
        return buffer.toString();
    }
}

