/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.vlayout;

import android.os.Build;
import android.support.annotation.NonNull;
import java.util.Arrays;
import java.util.Objects;

public final class Range<T extends Comparable<? super T>> {
    private final T mLower;
    private final T mUpper;

    public Range(@NonNull T lower, @NonNull T upper) {
        if (lower == null) {
            throw new IllegalArgumentException("lower must not be null");
        }
        if (upper == null) {
            throw new IllegalArgumentException("upper must not be null");
        }
        this.mLower = lower;
        this.mUpper = upper;
        if (lower.compareTo(upper) > 0) {
            throw new IllegalArgumentException("lower must be less than or equal to upper");
        }
    }

    public static <T extends Comparable<? super T>> Range<T> create(T lower, T upper) {
        return new Range<T>(lower, upper);
    }

    public T getLower() {
        return this.mLower;
    }

    public T getUpper() {
        return this.mUpper;
    }

    public boolean contains(@NonNull T value) {
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        boolean gteLower = value.compareTo(this.mLower) >= 0;
        boolean lteUpper = value.compareTo(this.mUpper) <= 0;
        return gteLower && lteUpper;
    }

    public boolean contains(@NonNull Range<T> range) {
        if (range == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        boolean gteLower = range.mLower.compareTo(this.mLower) >= 0;
        boolean lteUpper = range.mUpper.compareTo(this.mUpper) <= 0;
        return gteLower && lteUpper;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Range) {
            Range other = (Range)obj;
            return this.mLower.equals(other.mLower) && this.mUpper.equals(other.mUpper);
        }
        return false;
    }

    public T clamp(T value) {
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        if (value.compareTo(this.mLower) < 0) {
            return this.mLower;
        }
        if (value.compareTo(this.mUpper) > 0) {
            return this.mUpper;
        }
        return value;
    }

    public Range<T> intersect(Range<T> range) {
        if (range == null) {
            throw new IllegalArgumentException("range must not be null");
        }
        int cmpLower = range.mLower.compareTo(this.mLower);
        int cmpUpper = range.mUpper.compareTo(this.mUpper);
        if (cmpLower <= 0 && cmpUpper >= 0) {
            return this;
        }
        if (cmpLower >= 0 && cmpUpper <= 0) {
            return range;
        }
        return Range.create(cmpLower <= 0 ? this.mLower : range.mLower, cmpUpper >= 0 ? this.mUpper : range.mUpper);
    }

    public Range<T> intersect(T lower, T upper) {
        if (lower == null) {
            throw new IllegalArgumentException("lower must not be null");
        }
        if (upper == null) {
            throw new IllegalArgumentException("upper must not be null");
        }
        int cmpLower = lower.compareTo(this.mLower);
        int cmpUpper = upper.compareTo(this.mUpper);
        if (cmpLower <= 0 && cmpUpper >= 0) {
            return this;
        }
        return Range.create(cmpLower <= 0 ? this.mLower : lower, cmpUpper >= 0 ? this.mUpper : upper);
    }

    public Range<T> extend(Range<T> range) {
        if (range == null) {
            throw new IllegalArgumentException("range must not be null");
        }
        int cmpLower = range.mLower.compareTo(this.mLower);
        int cmpUpper = range.mUpper.compareTo(this.mUpper);
        if (cmpLower <= 0 && cmpUpper >= 0) {
            return range;
        }
        if (cmpLower >= 0 && cmpUpper <= 0) {
            return this;
        }
        return Range.create(cmpLower >= 0 ? this.mLower : range.mLower, cmpUpper <= 0 ? this.mUpper : range.mUpper);
    }

    public Range<T> extend(T lower, T upper) {
        if (lower == null) {
            throw new IllegalArgumentException("lower must not be null");
        }
        if (upper == null) {
            throw new IllegalArgumentException("upper must not be null");
        }
        int cmpLower = lower.compareTo(this.mLower);
        int cmpUpper = upper.compareTo(this.mUpper);
        if (cmpLower >= 0 && cmpUpper <= 0) {
            return this;
        }
        return Range.create(cmpLower >= 0 ? this.mLower : lower, cmpUpper <= 0 ? this.mUpper : upper);
    }

    public Range<T> extend(T value) {
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        return this.extend(value, value);
    }

    public String toString() {
        return String.format("[%s, %s]", this.mLower, this.mUpper);
    }

    public int hashCode() {
        if (Build.VERSION.SDK_INT >= 19) {
            return Objects.hash(this.mLower, this.mUpper);
        }
        return Arrays.hashCode(new Object[]{this.mLower, this.mUpper});
    }
}

