/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.vlayout;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.alibaba.android.vlayout.LayoutHelper;
import com.alibaba.android.vlayout.LayoutHelperFinder;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class RangeLayoutHelperFinder
extends LayoutHelperFinder {
    @NonNull
    private List<LayoutHelperItem> mLayoutHelperItems = new LinkedList<LayoutHelperItem>();
    @NonNull
    private List<LayoutHelper> mLayoutHelpers = new LinkedList<LayoutHelper>();
    @NonNull
    private List<LayoutHelper> mReverseLayoutHelpers = new LinkedList<LayoutHelper>();
    private LayoutHelperItem[] mSortedLayoutHelpers = null;
    @NonNull
    private Comparator<LayoutHelperItem> mLayoutHelperItemComparator = new Comparator<LayoutHelperItem>(){

        @Override
        public int compare(LayoutHelperItem lhs, LayoutHelperItem rhs) {
            return lhs.getStartPosition() - rhs.getStartPosition();
        }
    };

    @Override
    protected List<LayoutHelper> reverse() {
        return this.mReverseLayoutHelpers;
    }

    @Override
    public void setLayouts(@Nullable List<LayoutHelper> layouts) {
        this.mLayoutHelpers.clear();
        this.mReverseLayoutHelpers.clear();
        this.mLayoutHelperItems.clear();
        if (layouts != null) {
            ListIterator<LayoutHelper> iterator = layouts.listIterator();
            LayoutHelper helper = null;
            while (iterator.hasNext()) {
                helper = iterator.next();
                this.mLayoutHelpers.add(helper);
                this.mLayoutHelperItems.add(new LayoutHelperItem(helper));
            }
            while (iterator.hasPrevious()) {
                this.mReverseLayoutHelpers.add(iterator.previous());
            }
            this.mSortedLayoutHelpers = this.mLayoutHelperItems.toArray(new LayoutHelperItem[this.mLayoutHelperItems.size()]);
            Arrays.sort(this.mSortedLayoutHelpers, this.mLayoutHelperItemComparator);
        }
    }

    @Override
    @NonNull
    protected List<LayoutHelper> getLayoutHelpers() {
        return this.mLayoutHelpers;
    }

    @Override
    @Nullable
    public LayoutHelper getLayoutHelper(int position) {
        if (this.mSortedLayoutHelpers == null || this.mSortedLayoutHelpers.length == 0) {
            return null;
        }
        int count = this.mSortedLayoutHelpers.length;
        int s = 0;
        int e = count - 1;
        LayoutHelperItem rs = null;
        while (s <= e) {
            int m = (s + e) / 2;
            rs = this.mSortedLayoutHelpers[m];
            if (rs.getStartPosition() > position) {
                e = m - 1;
            } else if (rs.getEndPosition() < position) {
                s = m + 1;
            } else if (rs.getStartPosition() <= position && rs.getEndPosition() >= position) break;
            rs = null;
        }
        return rs == null ? null : rs.layoutHelper;
    }

    static class LayoutHelperItem {
        LayoutHelper layoutHelper;

        LayoutHelperItem(LayoutHelper helper) {
            this.layoutHelper = helper;
        }

        public int getStartPosition() {
            return this.layoutHelper.getRange().getLower();
        }

        public int getEndPosition() {
            return this.layoutHelper.getRange().getUpper();
        }
    }
}

