/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.vlayout.layout;

import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.alibaba.android.vlayout.LayoutManagerHelper;
import com.alibaba.android.vlayout.OrientationHelperEx;
import com.alibaba.android.vlayout.VirtualLayoutManager;
import com.alibaba.android.vlayout.layout.BaseLayoutHelper;
import com.alibaba.android.vlayout.layout.LayoutChunkResult;

public class LinearLayoutHelper
extends BaseLayoutHelper {
    private static final String TAG = "LinearLayoutHelper";
    private static final boolean DEBUG = false;
    private int mDividerHeight = 0;
    private boolean mLayoutWithAnchor = false;

    public LinearLayoutHelper() {
        this(0);
    }

    public LinearLayoutHelper(int dividerHeight) {
        this(dividerHeight, 0);
    }

    public LinearLayoutHelper(int dividerHeight, int itemCount) {
        this.setItemCount(itemCount);
        this.setDividerHeight(dividerHeight);
    }

    public void setDividerHeight(int dividerHeight) {
        if (dividerHeight < 0) {
            dividerHeight = 0;
        }
        this.mDividerHeight = dividerHeight;
    }

    @Override
    public void layoutViews(RecyclerView.Recycler recycler, RecyclerView.State state, VirtualLayoutManager.LayoutStateWrapper layoutState, LayoutChunkResult result, LayoutManagerHelper helper) {
        int top;
        int bottom;
        int left;
        int right;
        boolean isEndLine;
        boolean isStartLine;
        boolean isLayoutEnd;
        if (this.isOutOfRange(layoutState.getCurrentPosition())) {
            return;
        }
        int currentPosition = layoutState.getCurrentPosition();
        View view = this.nextView(recycler, layoutState, helper, result);
        if (view == null) {
            return;
        }
        boolean isOverLapMargin = helper.isEnableMarginOverLap();
        VirtualLayoutManager.LayoutParams params = (VirtualLayoutManager.LayoutParams)view.getLayoutParams();
        boolean layoutInVertical = helper.getOrientation() == 1;
        int startSpace = 0;
        int endSpace = 0;
        int gap = 0;
        boolean bl = isLayoutEnd = layoutState.getLayoutDirection() == 1;
        boolean bl2 = isLayoutEnd ? currentPosition == this.getRange().getLower() : (isStartLine = currentPosition == this.getRange().getUpper());
        boolean bl3 = isLayoutEnd ? currentPosition == this.getRange().getUpper() : (isEndLine = currentPosition == this.getRange().getLower());
        if (isStartLine) {
            startSpace = this.computeStartSpace(helper, layoutInVertical, isLayoutEnd, isOverLapMargin);
        }
        if (isEndLine) {
            endSpace = this.computeEndSpace(helper, layoutInVertical, isLayoutEnd, isOverLapMargin);
        }
        if (!isStartLine) {
            View sibling;
            if (!isOverLapMargin) {
                gap = this.mLayoutWithAnchor ? 0 : this.mDividerHeight;
            } else if (isLayoutEnd) {
                int lastMarginBottom;
                int marginTop = params.topMargin;
                sibling = helper.findViewByPosition(currentPosition - 1);
                int n = lastMarginBottom = sibling != null ? ((VirtualLayoutManager.LayoutParams)sibling.getLayoutParams()).bottomMargin : 0;
                gap = lastMarginBottom >= 0 && marginTop >= 0 ? Math.max(lastMarginBottom, marginTop) : lastMarginBottom + marginTop;
            } else {
                int marginBottom = params.bottomMargin;
                sibling = helper.findViewByPosition(currentPosition + 1);
                int lastMarginTop = sibling != null ? ((VirtualLayoutManager.LayoutParams)sibling.getLayoutParams()).topMargin : 0;
                gap = marginBottom >= 0 && lastMarginTop >= 0 ? Math.max(marginBottom, lastMarginTop) : marginBottom + lastMarginTop;
            }
        }
        int widthSize = helper.getContentWidth() - helper.getPaddingLeft() - helper.getPaddingRight() - this.getHorizontalMargin() - this.getHorizontalPadding();
        int widthSpec = helper.getChildMeasureSpec(widthSize, params.width, !layoutInVertical);
        float viewAspectRatio = params.mAspectRatio;
        int heightSpec = !Float.isNaN(viewAspectRatio) && viewAspectRatio > 0.0f ? View.MeasureSpec.makeMeasureSpec((int)((int)((float)widthSize / viewAspectRatio + 0.5f)), (int)0x40000000) : (!Float.isNaN(this.mAspectRatio) && this.mAspectRatio > 0.0f ? View.MeasureSpec.makeMeasureSpec((int)((int)((double)((float)widthSize / this.mAspectRatio) + 0.5)), (int)0x40000000) : helper.getChildMeasureSpec(helper.getContentHeight() - helper.getPaddingTop() - helper.getPaddingBottom() - this.getVerticalMargin() - this.getVerticalPadding(), params.height, layoutInVertical));
        if (!isOverLapMargin) {
            helper.measureChildWithMargins(view, widthSpec, heightSpec);
        } else {
            helper.measureChild(view, widthSpec, heightSpec);
        }
        OrientationHelperEx orientationHelper = helper.getMainOrientationHelper();
        result.mConsumed = orientationHelper.getDecoratedMeasurement(view) + startSpace + endSpace + gap;
        if (helper.getOrientation() == 1) {
            if (helper.isDoLayoutRTL()) {
                right = helper.getContentWidth() - helper.getPaddingRight() - this.mMarginRight - this.mPaddingRight;
                left = right - orientationHelper.getDecoratedMeasurementInOther(view);
            } else {
                left = helper.getPaddingLeft() + this.mMarginLeft + this.mPaddingLeft;
                right = left + orientationHelper.getDecoratedMeasurementInOther(view);
            }
            if (layoutState.getLayoutDirection() == -1) {
                bottom = layoutState.getOffset() - startSpace - (isStartLine ? 0 : gap);
                top = bottom - orientationHelper.getDecoratedMeasurement(view);
            } else {
                top = layoutState.getOffset() + startSpace + (isStartLine ? 0 : gap);
                bottom = top + orientationHelper.getDecoratedMeasurement(view);
            }
        } else {
            top = helper.getPaddingTop() + this.mMarginTop + this.mPaddingTop;
            bottom = top + orientationHelper.getDecoratedMeasurementInOther(view);
            if (layoutState.getLayoutDirection() == -1) {
                right = layoutState.getOffset() - startSpace - (isStartLine ? 0 : gap);
                left = right - orientationHelper.getDecoratedMeasurement(view);
            } else {
                left = layoutState.getOffset() + startSpace + (isStartLine ? 0 : gap);
                right = left + orientationHelper.getDecoratedMeasurement(view);
            }
        }
        this.layoutChildWithMargin(view, left, top, right, bottom, helper);
        this.handleStateOnResult(result, view);
        this.mLayoutWithAnchor = false;
    }

    @Override
    public void checkAnchorInfo(RecyclerView.State state, VirtualLayoutManager.AnchorInfoWrapper anchorInfo, LayoutManagerHelper helper) {
        super.checkAnchorInfo(state, anchorInfo, helper);
        this.mLayoutWithAnchor = true;
    }

    @Override
    public int computeAlignOffset(int offset, boolean isLayoutEnd, boolean useAnchor, LayoutManagerHelper helper) {
        boolean layoutInVertical;
        boolean bl = layoutInVertical = helper.getOrientation() == 1;
        if (isLayoutEnd) {
            if (offset == this.getItemCount() - 1) {
                return layoutInVertical ? this.mMarginBottom + this.mPaddingBottom : this.mMarginRight + this.mPaddingRight;
            }
        } else if (offset == 0) {
            return layoutInVertical ? -this.mMarginTop - this.mPaddingTop : -this.mMarginLeft - this.mPaddingLeft;
        }
        return super.computeAlignOffset(offset, isLayoutEnd, useAnchor, helper);
    }
}

