/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import java.net.URI;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.Path;

public class HadoopFileStatus
implements FileStatus {
    private Path path;
    private org.apache.hadoop.fs.FileStatus fileStatus;

    public HadoopFileStatus(Path parent, org.apache.hadoop.fs.FileStatus fileStatus) {
        this.fileStatus = fileStatus;
        URI uri = fileStatus.getPath().toUri();
        this.path = new Path(uri.getScheme(), uri.getAuthority(), uri.getPath(), parent.toUri().getQuery());
    }

    public long getLen() {
        return this.fileStatus.getLen();
    }

    public long getBlockSize() {
        long blocksize = this.fileStatus.getBlockSize();
        if (blocksize > this.fileStatus.getLen()) {
            return this.fileStatus.getLen();
        }
        return blocksize;
    }

    public long getAccessTime() {
        return this.fileStatus.getAccessTime();
    }

    public long getModificationTime() {
        return this.fileStatus.getModificationTime();
    }

    public short getReplication() {
        return this.fileStatus.getReplication();
    }

    public org.apache.hadoop.fs.FileStatus getInternalFileStatus() {
        return this.fileStatus;
    }

    public Path getPath() {
        return this.path;
    }

    public boolean isDir() {
        return this.fileStatus.isDir();
    }
}

