/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemKind;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.fs.hdfs.HadoopBlockLocation;
import org.apache.flink.runtime.fs.hdfs.HadoopDataInputStream;
import org.apache.flink.runtime.fs.hdfs.HadoopDataOutputStream;
import org.apache.flink.runtime.fs.hdfs.HadoopFileStatus;
import org.apache.flink.runtime.fs.hdfs.HadoopLocatedFileStatus;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopFileSystem
extends FileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopFileSystem.class);
    private final org.apache.hadoop.fs.FileSystem fs;
    private FileSystemKind fsKind;
    private Configuration config;
    private final long recoverLeasePauseBase;

    public HadoopFileSystem(org.apache.hadoop.fs.FileSystem hadoopFileSystem) {
        this((Configuration)new HdfsConfiguration(), hadoopFileSystem);
    }

    public HadoopFileSystem(Configuration conf, org.apache.hadoop.fs.FileSystem hadoopFileSystem) {
        this.config = conf;
        this.recoverLeasePauseBase = this.config.getLong(CheckpointingOptions.CHECKPOINT_DFS_LEASE_RECOVERY_TIMEOUT.key(), ((Long)CheckpointingOptions.CHECKPOINT_DFS_LEASE_RECOVERY_TIMEOUT.defaultValue()).longValue());
        this.fs = (org.apache.hadoop.fs.FileSystem)Preconditions.checkNotNull((Object)hadoopFileSystem, (String)"hadoopFileSystem");
        LOG.info("Configure hadoop file system with conf {}.", (Object)conf);
    }

    public org.apache.hadoop.fs.FileSystem getHadoopFileSystem() {
        return this.fs;
    }

    public Path getWorkingDirectory() {
        return new Path(this.fs.getWorkingDirectory().toUri());
    }

    public Path getHomeDirectory() {
        return new Path(this.fs.getHomeDirectory().toUri());
    }

    public URI getUri() {
        return this.fs.getUri();
    }

    public Configuration getConfig() {
        return this.config;
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        org.apache.hadoop.fs.FileStatus status = this.fs.getFileStatus(HadoopFileSystem.toHadoopPath(f));
        return new HadoopFileStatus(f, status);
    }

    public org.apache.flink.core.fs.BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (!(file instanceof HadoopFileStatus)) {
            throw new IOException("file is not an instance of DistributedFileStatus");
        }
        HadoopFileStatus f = (HadoopFileStatus)file;
        BlockLocation[] blkLocations = this.fs.getFileBlockLocations(f.getInternalFileStatus(), start, len);
        org.apache.flink.core.fs.BlockLocation[] distBlkLocations = new HadoopBlockLocation[blkLocations.length];
        for (int i = 0; i < distBlkLocations.length; ++i) {
            distBlkLocations[i] = new HadoopBlockLocation(blkLocations[i]);
        }
        return distBlkLocations;
    }

    public HadoopDataInputStream open(Path f, int bufferSize) throws IOException {
        org.apache.hadoop.fs.Path path = HadoopFileSystem.toHadoopPath(f);
        FSDataInputStream fdis = this.fs.open(path, bufferSize);
        return new HadoopDataInputStream(fdis);
    }

    public HadoopDataInputStream open(Path f) throws IOException {
        org.apache.hadoop.fs.Path path = HadoopFileSystem.toHadoopPath(f);
        FSDataInputStream fdis = this.fs.open(path);
        return new HadoopDataInputStream(fdis);
    }

    public HadoopDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        FSDataOutputStream fdos = this.fs.create(HadoopFileSystem.toHadoopPath(f), overwrite, bufferSize, replication, blockSize);
        return new HadoopDataOutputStream(fdos);
    }

    public HadoopDataOutputStream create(Path f, FileSystem.WriteMode overwrite) throws IOException {
        FSDataOutputStream fsDataOutputStream = this.fs.create(HadoopFileSystem.toHadoopPath(f), overwrite == FileSystem.WriteMode.OVERWRITE);
        return new HadoopDataOutputStream(fsDataOutputStream);
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        return this.fs.delete(HadoopFileSystem.toHadoopPath(f), recursive);
    }

    public boolean exists(Path f) throws IOException {
        return this.fs.exists(HadoopFileSystem.toHadoopPath(f));
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        org.apache.hadoop.fs.FileStatus[] hadoopFiles = this.fs.listStatus(HadoopFileSystem.toHadoopPath(f));
        FileStatus[] files = new FileStatus[hadoopFiles.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new HadoopFileStatus(f, hadoopFiles[i]);
        }
        return files;
    }

    public org.apache.flink.core.fs.LocatedFileStatus[] listLocatedStatus(Path f) throws IOException {
        RemoteIterator fileStatus = this.fs.listLocatedStatus(HadoopFileSystem.toHadoopPath(f));
        ArrayList<HadoopLocatedFileStatus> result = new ArrayList<HadoopLocatedFileStatus>();
        while (fileStatus.hasNext()) {
            result.add(new HadoopLocatedFileStatus(f, (LocatedFileStatus)fileStatus.next()));
        }
        return result.toArray(new HadoopLocatedFileStatus[0]);
    }

    public boolean mkdirs(Path f) throws IOException {
        return this.fs.mkdirs(HadoopFileSystem.toHadoopPath(f));
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return this.fs.rename(HadoopFileSystem.toHadoopPath(src), HadoopFileSystem.toHadoopPath(dst));
    }

    public boolean recoverFileLease(Path path) throws IOException {
        if (!(this.getHadoopFileSystem() instanceof DistributedFileSystem)) {
            return true;
        }
        DistributedFileSystem dfs = (DistributedFileSystem)this.getHadoopFileSystem();
        org.apache.hadoop.fs.Path dfsPath = new org.apache.hadoop.fs.Path(path.toUri());
        boolean recovered = false;
        if (!dfs.isFileClosed(dfsPath)) {
            LOG.info("File: {} is not closed, try to recover lease for it.", (Object)path);
            long startWaiting = System.currentTimeMillis();
            long timeout = 900000L;
            long recoveryTimeout = timeout + startWaiting;
            long firstPause = 4000L;
            int attempt = 0;
            while (!recovered && !(recovered = dfs.recoverLease(dfsPath))) {
                block10: {
                    if (System.currentTimeMillis() > recoveryTimeout) {
                        LOG.warn("Cannot recoverLease after trying for {} ms, may be data lost.", (Object)timeout);
                        break;
                    }
                    try {
                        if (attempt == 0) {
                            Thread.sleep(firstPause);
                            break block10;
                        }
                        long localStartWaiting = System.currentTimeMillis();
                        while (System.currentTimeMillis() - localStartWaiting < this.recoverLeasePauseBase * (long)attempt) {
                            Thread.sleep(1000L);
                            if (!dfs.isFileClosed(dfsPath)) continue;
                            recovered = true;
                            break;
                        }
                    }
                    catch (InterruptedException ie) {
                        InterruptedIOException ioException = new InterruptedIOException();
                        ioException.initCause(ie);
                        throw ioException;
                    }
                }
                ++attempt;
            }
        } else {
            return true;
        }
        return recovered;
    }

    public long getDefaultBlockSize() {
        return this.fs.getDefaultBlockSize();
    }

    public boolean isDistributedFS() {
        return true;
    }

    public FileSystemKind getKind() {
        if (this.fsKind == null) {
            this.fsKind = HadoopFileSystem.getKindForScheme(this.fs.getUri().getScheme());
        }
        return this.fsKind;
    }

    private static org.apache.hadoop.fs.Path toHadoopPath(Path path) {
        return new org.apache.hadoop.fs.Path(path.toUri());
    }

    static FileSystemKind getKindForScheme(String scheme) {
        if ((scheme = scheme.toLowerCase(Locale.US)).startsWith("s3") || scheme.startsWith("emr") || scheme.startsWith("oss")) {
            return FileSystemKind.OBJECT_STORE;
        }
        if (scheme.startsWith("http") || scheme.startsWith("ftp")) {
            return FileSystemKind.OBJECT_STORE;
        }
        return FileSystemKind.FILE_SYSTEM;
    }
}

