/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.SafetyNetWrapperFileSystem;
import org.apache.flink.runtime.fs.hdfs.HadoopFileSystem;

public class RestoreUtils {
    public static void recoverLeaseIfNeeded(Collection<Path> filePaths) {
        if (filePaths.isEmpty()) {
            return;
        }
        try {
            FileSystem delegateFs;
            FileSystem fileSystem = filePaths.iterator().next().getFileSystem();
            HadoopFileSystem hadoopFileSystem = null;
            if (fileSystem instanceof HadoopFileSystem) {
                hadoopFileSystem = (HadoopFileSystem)fileSystem;
            } else if (fileSystem instanceof SafetyNetWrapperFileSystem && (delegateFs = ((SafetyNetWrapperFileSystem)fileSystem).getWrappedDelegate()) instanceof HadoopFileSystem) {
                hadoopFileSystem = (HadoopFileSystem)delegateFs;
            }
            if (hadoopFileSystem != null) {
                RestoreUtils.recoverLeaseInParallel(filePaths, hadoopFileSystem);
            }
        }
        catch (IOException exception) {
            throw new UncheckedIOException(exception);
        }
    }

    @VisibleForTesting
    static void recoverLeaseInParallel(Collection<Path> snapshotHandles, HadoopFileSystem hadoopFileSystem) {
        snapshotHandles.parallelStream().forEach(filePath -> {
            try {
                hadoopFileSystem.recoverFileLease((Path)filePath);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Have an exception when recovering lease for file " + filePath + ".", e);
            }
        });
    }
}

