/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo;

import com.netflix.fenzo.TaskAssignmentResult;
import com.netflix.fenzo.TaskRequest;
import com.netflix.fenzo.VMAssignmentResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SchedulingResult {
    private final Map<String, VMAssignmentResult> resultMap;
    private final Map<TaskRequest, List<TaskAssignmentResult>> failures;
    private final List<Exception> exceptions;
    private int leasesAdded;
    private int leasesRejected;
    private long runtime;
    private int numAllocations;
    private int totalVMsCount;
    private int idleVMsCount;

    SchedulingResult(Map<String, VMAssignmentResult> resultMap) {
        this.resultMap = resultMap;
        this.failures = new HashMap<TaskRequest, List<TaskAssignmentResult>>();
        this.exceptions = new ArrayList<Exception>();
    }

    public Map<String, VMAssignmentResult> getResultMap() {
        return this.resultMap;
    }

    void addFailures(TaskRequest request, List<TaskAssignmentResult> f) {
        this.failures.put(request, f);
    }

    void addException(Exception e) {
        this.exceptions.add(e);
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public Map<TaskRequest, List<TaskAssignmentResult>> getFailures() {
        return this.failures;
    }

    public int getLeasesAdded() {
        return this.leasesAdded;
    }

    void setLeasesAdded(int leasesAdded) {
        this.leasesAdded = leasesAdded;
    }

    public int getLeasesRejected() {
        return this.leasesRejected;
    }

    void setLeasesRejected(int leasesRejected) {
        this.leasesRejected = leasesRejected;
    }

    public long getRuntime() {
        return this.runtime;
    }

    void setRuntime(long runtime) {
        this.runtime = runtime;
    }

    public int getNumAllocations() {
        return this.numAllocations;
    }

    void setNumAllocations(int numAllocations) {
        this.numAllocations = numAllocations;
    }

    public int getTotalVMsCount() {
        return this.totalVMsCount;
    }

    void setTotalVMsCount(int totalVMsCount) {
        this.totalVMsCount = totalVMsCount;
    }

    public int getIdleVMsCount() {
        return this.idleVMsCount;
    }

    void setIdleVMsCount(int idleVMsCount) {
        this.idleVMsCount = idleVMsCount;
    }

    public String toString() {
        return "SchedulingResult{resultMap=" + this.resultMap + ", failures=" + this.failures + ", leasesAdded=" + this.leasesAdded + ", leasesRejected=" + this.leasesRejected + ", runtime=" + this.runtime + ", numAllocations=" + this.numAllocations + ", totalVMsCount=" + this.totalVMsCount + ", idleVMsCount=" + this.idleVMsCount + '}';
    }
}

