/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo.plugins;

import com.netflix.fenzo.TaskAssignmentResult;
import com.netflix.fenzo.TaskRequest;
import com.netflix.fenzo.TaskTrackerState;
import com.netflix.fenzo.VMTaskFitnessCalculator;
import com.netflix.fenzo.VirtualMachineCurrentState;
import com.netflix.fenzo.VirtualMachineLease;
import com.netflix.fenzo.functions.Func1;
import java.util.Iterator;

public class BinPackingFitnessCalculators {
    public static final VMTaskFitnessCalculator cpuBinPacker = new VMTaskFitnessCalculator(){

        @Override
        public String getName() {
            return "CPUBinPacker";
        }

        @Override
        public double calculateFitness(TaskRequest taskRequest, VirtualMachineCurrentState targetVM, TaskTrackerState taskTrackerState) {
            return BinPackingFitnessCalculators.calculateResourceFitness(taskRequest, targetVM, taskTrackerState, new Func1<TaskRequest, Double>(){

                @Override
                public Double call(TaskRequest request) {
                    return request.getCPUs();
                }
            }, new Func1<VirtualMachineLease, Double>(){

                @Override
                public Double call(VirtualMachineLease l) {
                    return l.cpuCores();
                }
            });
        }
    };
    public static final VMTaskFitnessCalculator memoryBinPacker = new VMTaskFitnessCalculator(){

        @Override
        public String getName() {
            return "MemoryBinPacker";
        }

        @Override
        public double calculateFitness(TaskRequest taskRequest, VirtualMachineCurrentState targetVM, TaskTrackerState taskTrackerState) {
            return BinPackingFitnessCalculators.calculateResourceFitness(taskRequest, targetVM, taskTrackerState, new Func1<TaskRequest, Double>(){

                @Override
                public Double call(TaskRequest request) {
                    return request.getMemory();
                }
            }, new Func1<VirtualMachineLease, Double>(){

                @Override
                public Double call(VirtualMachineLease l) {
                    return l.memoryMB();
                }
            });
        }
    };
    public static final VMTaskFitnessCalculator cpuMemBinPacker = new VMTaskFitnessCalculator(){

        @Override
        public String getName() {
            return "CPUAndMemoryBinPacker";
        }

        @Override
        public double calculateFitness(TaskRequest taskRequest, VirtualMachineCurrentState targetVM, TaskTrackerState taskTrackerState) {
            double cpuFitness = cpuBinPacker.calculateFitness(taskRequest, targetVM, taskTrackerState);
            double memoryFitness = memoryBinPacker.calculateFitness(taskRequest, targetVM, taskTrackerState);
            return (cpuFitness + memoryFitness) / 2.0;
        }
    };
    public static final VMTaskFitnessCalculator networkBinPacker = new VMTaskFitnessCalculator(){

        @Override
        public String getName() {
            return "NetworkBinPacker";
        }

        @Override
        public double calculateFitness(TaskRequest taskRequest, VirtualMachineCurrentState targetVM, TaskTrackerState taskTrackerState) {
            return BinPackingFitnessCalculators.calculateResourceFitness(taskRequest, targetVM, taskTrackerState, new Func1<TaskRequest, Double>(){

                @Override
                public Double call(TaskRequest request) {
                    return request.getNetworkMbps();
                }
            }, new Func1<VirtualMachineLease, Double>(){

                @Override
                public Double call(VirtualMachineLease l) {
                    return l.networkMbps();
                }
            });
        }
    };
    public static final VMTaskFitnessCalculator cpuMemNetworkBinPacker = new VMTaskFitnessCalculator(){

        @Override
        public String getName() {
            return "CPUAndMemoryAndNetworkBinPacker";
        }

        @Override
        public double calculateFitness(TaskRequest taskRequest, VirtualMachineCurrentState targetVM, TaskTrackerState taskTrackerState) {
            double cpuFitness = cpuBinPacker.calculateFitness(taskRequest, targetVM, taskTrackerState);
            double memFitness = memoryBinPacker.calculateFitness(taskRequest, targetVM, taskTrackerState);
            double networkFitness = networkBinPacker.calculateFitness(taskRequest, targetVM, taskTrackerState);
            return (cpuFitness + memFitness + networkFitness) / 3.0;
        }
    };

    private static double calculateResourceFitness(TaskRequest request, VirtualMachineCurrentState targetVM, TaskTrackerState taskTrackerState, Func1<TaskRequest, Double> taskResourceGetter, Func1<VirtualMachineLease, Double> leaseResourceGetter) {
        double totalRes = leaseResourceGetter.call(targetVM.getCurrAvailableResources());
        Iterator<TaskRequest> iterator = targetVM.getRunningTasks().iterator();
        double oldJobsTotal = 0.0;
        while (iterator.hasNext()) {
            oldJobsTotal += taskResourceGetter.call(iterator.next()).doubleValue();
        }
        double usedResource = taskResourceGetter.call(request);
        Iterator<TaskAssignmentResult> taskAssignmentResultIterator = targetVM.getTasksCurrentlyAssigned().iterator();
        while (taskAssignmentResultIterator.hasNext()) {
            usedResource += taskResourceGetter.call(taskAssignmentResultIterator.next().getRequest()).doubleValue();
        }
        return (usedResource += oldJobsTotal) / (totalRes += oldJobsTotal);
    }
}

