/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mesos;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.flink.mesos.util.MesosArtifactResolver;
import org.apache.flink.runtime.clusterframework.ContainerSpecification;
import org.apache.flink.util.Preconditions;
import org.apache.mesos.Protos;
import scala.Option;

public class Utils {
    public static final String UNRESERVED_ROLE = "*";

    public static Protos.Environment.Variable variable(String name, String value) {
        Preconditions.checkNotNull((Object)name);
        return Protos.Environment.Variable.newBuilder().setName(name).setValue(value).build();
    }

    public static Protos.CommandInfo.URI uri(URL url, boolean cacheable) {
        Preconditions.checkNotNull((Object)url);
        return Protos.CommandInfo.URI.newBuilder().setValue(url.toExternalForm()).setExtract(false).setCache(cacheable).build();
    }

    public static Protos.CommandInfo.URI uri(MesosArtifactResolver resolver, ContainerSpecification.Artifact artifact) {
        Preconditions.checkNotNull((Object)resolver);
        Preconditions.checkNotNull((Object)artifact);
        Option<URL> url = resolver.resolve(artifact.dest);
        if (url.isEmpty()) {
            throw new IllegalArgumentException("Unresolvable artifact: " + artifact.dest);
        }
        return Protos.CommandInfo.URI.newBuilder().setValue(((URL)url.get()).toExternalForm()).setOutputFile(artifact.dest.toString()).setExtract(artifact.extract).setCache(artifact.cachable).setExecutable(artifact.executable).build();
    }

    public static List<Protos.Resource> resources(Protos.Resource ... resources) {
        Preconditions.checkNotNull((Object)resources);
        return Arrays.asList(resources);
    }

    public static Protos.Resource cpus(double amount) {
        return Utils.cpus(UNRESERVED_ROLE, amount);
    }

    public static Protos.Resource cpus(String role, double amount) {
        return Utils.scalar("cpus", role, amount);
    }

    public static Protos.Resource gpus(double amount) {
        return Utils.gpus(UNRESERVED_ROLE, amount);
    }

    public static Protos.Resource gpus(String role, double amount) {
        return Utils.scalar("gpus", role, amount);
    }

    public static Protos.Resource mem(double amount) {
        return Utils.mem(UNRESERVED_ROLE, amount);
    }

    public static Protos.Resource mem(String role, double amount) {
        return Utils.scalar("mem", role, amount);
    }

    public static Protos.Resource network(double amount) {
        return Utils.network(UNRESERVED_ROLE, amount);
    }

    public static Protos.Resource network(String role, double amount) {
        return Utils.scalar("network", role, amount);
    }

    public static Protos.Resource disk(double amount) {
        return Utils.disk(UNRESERVED_ROLE, amount);
    }

    public static Protos.Resource disk(String role, double amount) {
        return Utils.scalar("disk", role, amount);
    }

    public static Protos.Resource ports(Protos.Value.Range ... ranges) {
        return Utils.ports(UNRESERVED_ROLE, ranges);
    }

    public static Protos.Resource ports(String role, Protos.Value.Range ... ranges) {
        return Utils.ranges("ports", role, ranges);
    }

    public static Protos.Resource scalar(String name, String role, double value) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)role);
        Preconditions.checkNotNull((Object)value);
        return Protos.Resource.newBuilder().setName(name).setType(Protos.Value.Type.SCALAR).setScalar(Protos.Value.Scalar.newBuilder().setValue(value)).setRole(role).build();
    }

    public static Protos.Value.Range range(long begin, long end) {
        return Protos.Value.Range.newBuilder().setBegin(begin).setEnd(end).build();
    }

    public static Protos.Resource ranges(String name, String role, Protos.Value.Range ... ranges) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)role);
        Preconditions.checkNotNull((Object)ranges);
        return Protos.Resource.newBuilder().setName(name).setType(Protos.Value.Type.RANGES).setRanges(Protos.Value.Ranges.newBuilder().addAllRange(Arrays.asList(ranges)).build()).setRole(role).build();
    }

    public static LongStream rangeValues(Collection<Protos.Resource> resources) {
        Preconditions.checkNotNull(resources);
        return resources.stream().filter(Protos.Resource::hasRanges).flatMap(r -> r.getRanges().getRangeList().stream()).flatMapToLong(Utils::rangeValues);
    }

    public static LongStream rangeValues(Protos.Value.Range range) {
        Preconditions.checkNotNull((Object)range);
        return LongStream.rangeClosed(range.getBegin(), range.getEnd());
    }

    public static String toString(Collection<Protos.Resource> resources) {
        Preconditions.checkNotNull(resources);
        return resources.stream().map(Utils::toString).collect(Collectors.joining("; ", "[", "]"));
    }

    public static String toString(Protos.Resource resource) {
        Preconditions.checkNotNull((Object)resource);
        if (resource.hasScalar()) {
            return String.format("%s(%s):%.1f", resource.getName(), resource.getRole(), resource.getScalar().getValue());
        }
        if (resource.hasRanges()) {
            return String.format("%s(%s):%s", resource.getName(), resource.getRole(), Utils.toString(resource.getRanges()));
        }
        return resource.toString();
    }

    public static String toString(Protos.Value.Ranges ranges) {
        Preconditions.checkNotNull((Object)ranges);
        return ranges.getRangeList().stream().map(Utils::toString).collect(Collectors.joining(",", "[", "]"));
    }

    public static String toString(Protos.Value.Range range) {
        Preconditions.checkNotNull((Object)range);
        return String.format("%d-%d", range.getBegin(), range.getEnd());
    }
}

