/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mesos.entrypoint;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.mesos.configuration.MesosOptions;
import org.apache.flink.mesos.runtime.clusterframework.MesosTaskManagerParameters;
import org.apache.flink.mesos.util.MesosConfiguration;
import org.apache.flink.runtime.clusterframework.ContainerSpecification;
import org.apache.flink.runtime.clusterframework.overlays.CompositeContainerOverlay;
import org.apache.flink.runtime.clusterframework.overlays.ContainerOverlay;
import org.apache.flink.runtime.clusterframework.overlays.FlinkDistributionOverlay;
import org.apache.flink.runtime.clusterframework.overlays.HadoopConfOverlay;
import org.apache.flink.runtime.clusterframework.overlays.HadoopUserOverlay;
import org.apache.flink.runtime.clusterframework.overlays.KeytabOverlay;
import org.apache.flink.runtime.clusterframework.overlays.Krb5ConfOverlay;
import org.apache.flink.runtime.clusterframework.overlays.SSLStoreOverlay;
import org.apache.mesos.Protos;
import org.slf4j.Logger;
import scala.Option;
import scala.concurrent.duration.FiniteDuration;

public class MesosEntrypointUtils {
    public static MesosConfiguration createMesosSchedulerConfiguration(Configuration flinkConfig, String hostname) {
        Protos.FrameworkInfo.Builder frameworkInfo = Protos.FrameworkInfo.newBuilder().setHostname(hostname);
        Protos.Credential.Builder credential = null;
        if (!flinkConfig.contains(MesosOptions.MASTER_URL)) {
            throw new IllegalConfigurationException(MesosOptions.MASTER_URL.key() + " must be configured.");
        }
        String masterUrl = flinkConfig.getString(MesosOptions.MASTER_URL);
        FiniteDuration failoverTimeout = FiniteDuration.apply((long)flinkConfig.getInteger(MesosOptions.FAILOVER_TIMEOUT_SECONDS), (TimeUnit)TimeUnit.SECONDS);
        frameworkInfo.setFailoverTimeout(failoverTimeout.toSeconds());
        frameworkInfo.setName(flinkConfig.getString(MesosOptions.RESOURCEMANAGER_FRAMEWORK_NAME));
        frameworkInfo.setRole(flinkConfig.getString(MesosOptions.RESOURCEMANAGER_FRAMEWORK_ROLE));
        frameworkInfo.setUser(flinkConfig.getString(MesosOptions.RESOURCEMANAGER_FRAMEWORK_USER));
        if (flinkConfig.contains(MesosOptions.RESOURCEMANAGER_FRAMEWORK_PRINCIPAL)) {
            frameworkInfo.setPrincipal(flinkConfig.getString(MesosOptions.RESOURCEMANAGER_FRAMEWORK_PRINCIPAL));
            credential = Protos.Credential.newBuilder();
            credential.setPrincipal(frameworkInfo.getPrincipal());
            if (flinkConfig.contains(MesosOptions.RESOURCEMANAGER_FRAMEWORK_SECRET)) {
                credential.setSecret(flinkConfig.getString(MesosOptions.RESOURCEMANAGER_FRAMEWORK_SECRET));
            }
        }
        MesosConfiguration mesos = new MesosConfiguration(masterUrl, frameworkInfo, (Option<Protos.Credential.Builder>)Option.apply(credential));
        return mesos;
    }

    public static MesosTaskManagerParameters createTmParameters(Configuration configuration, Logger log) {
        MesosTaskManagerParameters taskManagerParameters = MesosTaskManagerParameters.create(configuration);
        log.info("TaskManagers will be created with {} task slots", (Object)taskManagerParameters.containeredParameters().numSlots());
        log.info("TaskManagers will be started with container size {} MB, JVM heap size {} MB, JVM direct memory limit {} MB, {} cpus, {} gpus", new Object[]{taskManagerParameters.containeredParameters().taskManagerTotalMemoryMB(), taskManagerParameters.containeredParameters().taskManagerHeapSizeMB(), taskManagerParameters.containeredParameters().taskManagerDirectMemoryLimitMB(), taskManagerParameters.cpus(), taskManagerParameters.gpus()});
        return taskManagerParameters;
    }

    public static ContainerSpecification createContainerSpec(Configuration configuration, Configuration dynamicProperties) throws Exception {
        ContainerSpecification spec = new ContainerSpecification();
        spec.getDynamicConfiguration().addAll(dynamicProperties);
        MesosEntrypointUtils.applyOverlays(configuration, spec);
        return spec;
    }

    public static void applyOverlays(Configuration configuration, ContainerSpecification containerSpec) throws IOException {
        CompositeContainerOverlay overlay = new CompositeContainerOverlay(new ContainerOverlay[]{FlinkDistributionOverlay.newBuilder().fromEnvironment(configuration).build(), HadoopConfOverlay.newBuilder().fromEnvironment(configuration).build(), HadoopUserOverlay.newBuilder().fromEnvironment(configuration).build(), KeytabOverlay.newBuilder().fromEnvironment(configuration).build(), Krb5ConfOverlay.newBuilder().fromEnvironment(configuration).build(), SSLStoreOverlay.newBuilder().fromEnvironment(configuration).build()});
        overlay.configure(containerSpec);
    }

    public static Configuration loadConfiguration(Configuration dynamicProperties, Logger log) {
        Configuration configuration = GlobalConfiguration.loadConfigurationWithDynamicProperties((Configuration)dynamicProperties);
        Map<String, String> envs = System.getenv();
        String tmpDirs = envs.get("_FLINK_TMP_DIR");
        if (configuration.contains(CoreOptions.TMP_DIRS)) {
            log.info("Overriding Mesos' temporary file directories with those specified in the Flink config: " + configuration.getValue(CoreOptions.TMP_DIRS));
        } else if (tmpDirs != null) {
            log.info("Setting directories for temporary files to: {}", (Object)tmpDirs);
            configuration.setString(CoreOptions.TMP_DIRS, tmpDirs);
        }
        return configuration;
    }
}

