/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mesos.entrypoint;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.mesos.entrypoint.MesosEntrypointUtils;
import org.apache.flink.mesos.runtime.clusterframework.MesosResourceManager;
import org.apache.flink.mesos.runtime.clusterframework.MesosTaskManagerParameters;
import org.apache.flink.mesos.runtime.clusterframework.services.MesosServices;
import org.apache.flink.mesos.runtime.clusterframework.services.MesosServicesUtils;
import org.apache.flink.mesos.util.MesosConfiguration;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.clusterframework.BootstrapTools;
import org.apache.flink.runtime.clusterframework.ContainerSpecification;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.entrypoint.JobClusterEntrypoint;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.resourcemanager.ResourceManager;
import org.apache.flink.runtime.resourcemanager.ResourceManagerConfiguration;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServices;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServicesConfiguration;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.runtime.util.SignalHandler;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

public class MesosJobClusterEntrypoint
extends JobClusterEntrypoint {
    public static final String JOB_GRAPH_FILE_PATH = "flink.jobgraph.path";
    private static final Options ALL_OPTIONS = new Options().addOption(BootstrapTools.newDynamicPropertiesOption());
    private final Configuration dynamicProperties;
    private MesosConfiguration schedulerConfiguration;
    private MesosServices mesosServices;
    private MesosTaskManagerParameters taskManagerParameters;
    private ContainerSpecification taskManagerContainerSpec;

    public MesosJobClusterEntrypoint(Configuration config, Configuration dynamicProperties) {
        super(config);
        this.dynamicProperties = (Configuration)Preconditions.checkNotNull((Object)dynamicProperties);
    }

    protected void initializeServices(Configuration config) throws Exception {
        super.initializeServices(config);
        String hostname = config.getString(JobManagerOptions.ADDRESS);
        this.schedulerConfiguration = MesosEntrypointUtils.createMesosSchedulerConfiguration(config, hostname);
        this.mesosServices = MesosServicesUtils.createMesosServices(config, hostname);
        this.taskManagerParameters = MesosEntrypointUtils.createTmParameters(config, LOG);
        this.taskManagerContainerSpec = MesosEntrypointUtils.createContainerSpec(config, this.dynamicProperties);
    }

    protected ResourceManager<?> createResourceManager(Configuration configuration, ResourceID resourceId, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, MetricRegistry metricRegistry, FatalErrorHandler fatalErrorHandler, ClusterInformation clusterInformation, @Nullable String webInterfaceUrl) throws Exception {
        ResourceManagerConfiguration rmConfiguration = ResourceManagerConfiguration.fromConfiguration((Configuration)configuration);
        ResourceManagerRuntimeServicesConfiguration rmServicesConfiguration = ResourceManagerRuntimeServicesConfiguration.fromConfiguration((Configuration)configuration);
        ResourceManagerRuntimeServices rmRuntimeServices = ResourceManagerRuntimeServices.fromConfiguration((ResourceManagerRuntimeServicesConfiguration)rmServicesConfiguration, (HighAvailabilityServices)highAvailabilityServices, (ScheduledExecutor)rpcService.getScheduledExecutor());
        return new MesosResourceManager(rpcService, "resourcemanager", resourceId, rmConfiguration, highAvailabilityServices, heartbeatServices, rmRuntimeServices.getSlotManager(), metricRegistry, rmRuntimeServices.getJobLeaderIdService(), clusterInformation, fatalErrorHandler, configuration, this.mesosServices, this.schedulerConfiguration, this.taskManagerParameters, this.taskManagerContainerSpec);
    }

    /*
     * Exception decompiling
     */
    protected JobGraph retrieveJobGraph(Configuration configuration) throws FlinkException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected CompletableFuture<Void> stopClusterServices(boolean cleanupHaData) {
        CompletableFuture serviceShutDownFuture = super.stopClusterServices(cleanupHaData);
        return FutureUtils.runAfterwards((CompletableFuture)serviceShutDownFuture, () -> {
            if (this.mesosServices != null) {
                this.mesosServices.close(cleanupHaData);
            }
        });
    }

    protected void registerShutdownActions(CompletableFuture<ApplicationStatus> terminationFuture) {
    }

    public static void main(String[] args) {
        CommandLine cmd;
        EnvironmentInformation.logEnvironmentInfo((Logger)LOG, (String)MesosJobClusterEntrypoint.class.getSimpleName(), (String[])args);
        SignalHandler.register((Logger)LOG);
        JvmShutdownSafeguard.installAsShutdownHook((Logger)LOG);
        PosixParser parser = new PosixParser();
        try {
            cmd = parser.parse(ALL_OPTIONS, args);
        }
        catch (Exception e) {
            LOG.error("Could not parse the command-line options.", (Throwable)e);
            System.exit(1);
            return;
        }
        Configuration dynamicProperties = BootstrapTools.parseDynamicProperties((CommandLine)cmd);
        Configuration configuration = MesosEntrypointUtils.loadConfiguration(dynamicProperties, LOG);
        MesosJobClusterEntrypoint clusterEntrypoint = new MesosJobClusterEntrypoint(configuration, dynamicProperties);
        clusterEntrypoint.startCluster();
    }
}

