/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mesos.entrypoint;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.mesos.entrypoint.MesosEntrypointUtils;
import org.apache.flink.mesos.runtime.clusterframework.MesosResourceManager;
import org.apache.flink.mesos.runtime.clusterframework.MesosTaskManagerParameters;
import org.apache.flink.mesos.runtime.clusterframework.services.MesosServices;
import org.apache.flink.mesos.runtime.clusterframework.services.MesosServicesUtils;
import org.apache.flink.mesos.util.MesosConfiguration;
import org.apache.flink.runtime.clusterframework.BootstrapTools;
import org.apache.flink.runtime.clusterframework.ContainerSpecification;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.entrypoint.SessionClusterEntrypoint;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.resourcemanager.ResourceManager;
import org.apache.flink.runtime.resourcemanager.ResourceManagerConfiguration;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServices;
import org.apache.flink.runtime.resourcemanager.ResourceManagerRuntimeServicesConfiguration;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.runtime.util.SignalHandler;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

public class MesosSessionClusterEntrypoint
extends SessionClusterEntrypoint {
    private static final Options ALL_OPTIONS = new Options().addOption(BootstrapTools.newDynamicPropertiesOption());
    private final Configuration dynamicProperties;
    private MesosConfiguration mesosConfig;
    private MesosServices mesosServices;
    private MesosTaskManagerParameters taskManagerParameters;
    private ContainerSpecification taskManagerContainerSpec;

    public MesosSessionClusterEntrypoint(Configuration config, Configuration dynamicProperties) {
        super(config);
        this.dynamicProperties = (Configuration)Preconditions.checkNotNull((Object)dynamicProperties);
    }

    protected void initializeServices(Configuration config) throws Exception {
        super.initializeServices(config);
        String hostname = config.getString(JobManagerOptions.ADDRESS);
        this.mesosConfig = MesosEntrypointUtils.createMesosSchedulerConfiguration(config, hostname);
        this.mesosServices = MesosServicesUtils.createMesosServices(config, hostname);
        this.taskManagerParameters = MesosEntrypointUtils.createTmParameters(config, LOG);
        this.taskManagerContainerSpec = MesosEntrypointUtils.createContainerSpec(config, this.dynamicProperties);
    }

    protected ResourceManager<?> createResourceManager(Configuration configuration, ResourceID resourceId, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, MetricRegistry metricRegistry, FatalErrorHandler fatalErrorHandler, ClusterInformation clusterInformation, @Nullable String webInterfaceUrl) throws Exception {
        ResourceManagerConfiguration rmConfiguration = ResourceManagerConfiguration.fromConfiguration((Configuration)configuration);
        ResourceManagerRuntimeServicesConfiguration rmServicesConfiguration = ResourceManagerRuntimeServicesConfiguration.fromConfiguration((Configuration)configuration);
        ResourceManagerRuntimeServices rmRuntimeServices = ResourceManagerRuntimeServices.fromConfiguration((ResourceManagerRuntimeServicesConfiguration)rmServicesConfiguration, (HighAvailabilityServices)highAvailabilityServices, (ScheduledExecutor)rpcService.getScheduledExecutor());
        return new MesosResourceManager(rpcService, "resourcemanager", resourceId, rmConfiguration, highAvailabilityServices, heartbeatServices, rmRuntimeServices.getSlotManager(), metricRegistry, rmRuntimeServices.getJobLeaderIdService(), clusterInformation, fatalErrorHandler, configuration, this.mesosServices, this.mesosConfig, this.taskManagerParameters, this.taskManagerContainerSpec);
    }

    protected CompletableFuture<Void> stopClusterServices(boolean cleanupHaData) {
        CompletableFuture serviceShutDownFuture = super.stopClusterServices(cleanupHaData);
        return FutureUtils.runAfterwards((CompletableFuture)serviceShutDownFuture, () -> {
            if (this.mesosServices != null) {
                this.mesosServices.close(cleanupHaData);
            }
        });
    }

    public static void main(String[] args) {
        CommandLine cmd;
        EnvironmentInformation.logEnvironmentInfo((Logger)LOG, (String)MesosSessionClusterEntrypoint.class.getSimpleName(), (String[])args);
        SignalHandler.register((Logger)LOG);
        JvmShutdownSafeguard.installAsShutdownHook((Logger)LOG);
        PosixParser parser = new PosixParser();
        try {
            cmd = parser.parse(ALL_OPTIONS, args);
        }
        catch (Exception e) {
            LOG.error("Could not parse the command-line options.", (Throwable)e);
            System.exit(1);
            return;
        }
        Configuration dynamicProperties = BootstrapTools.parseDynamicProperties((CommandLine)cmd);
        Configuration configuration = MesosEntrypointUtils.loadConfiguration(dynamicProperties, LOG);
        MesosSessionClusterEntrypoint clusterEntrypoint = new MesosSessionClusterEntrypoint(configuration, dynamicProperties);
        clusterEntrypoint.startCluster();
    }
}

