/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mesos.entrypoint;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.mesos.entrypoint.MesosEntrypointUtils;
import org.apache.flink.runtime.clusterframework.BootstrapTools;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.runtime.taskexecutor.TaskManagerRunner;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.runtime.util.SignalHandler;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MesosTaskExecutorRunner {
    private static final Logger LOG = LoggerFactory.getLogger(MesosTaskExecutorRunner.class);
    private static final int INIT_ERROR_EXIT_CODE = 31;
    private static final Options ALL_OPTIONS = new Options().addOption(BootstrapTools.newDynamicPropertiesOption());

    public static void main(String[] args) throws Exception {
        Configuration configuration;
        EnvironmentInformation.logEnvironmentInfo((Logger)LOG, (String)MesosTaskExecutorRunner.class.getSimpleName(), (String[])args);
        SignalHandler.register((Logger)LOG);
        JvmShutdownSafeguard.installAsShutdownHook((Logger)LOG);
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(ALL_OPTIONS, args);
        try {
            Configuration dynamicProperties = BootstrapTools.parseDynamicProperties((CommandLine)cmd);
            LOG.debug("Mesos dynamic properties: {}", (Object)dynamicProperties);
            configuration = MesosEntrypointUtils.loadConfiguration(dynamicProperties, LOG);
        }
        catch (Throwable t) {
            LOG.error("Failed to load the TaskManager configuration and dynamic properties.", t);
            System.exit(31);
            return;
        }
        Map<String, String> envs = System.getenv();
        try {
            FileSystem.initialize((Configuration)configuration);
        }
        catch (IOException e) {
            throw new IOException("Error while configuring the filesystems.", e);
        }
        configuration.setBoolean(AkkaOptions.JVM_EXIT_ON_FATAL_ERROR, true);
        String containerID = (String)Preconditions.checkNotNull((Object)envs.get("_FLINK_CONTAINER_ID"));
        final ResourceID resourceId = new ResourceID(containerID);
        LOG.info("ResourceID assigned for this container: {}", (Object)resourceId);
        SecurityConfiguration sc = new SecurityConfiguration(configuration);
        SecurityUtils.install((SecurityConfiguration)sc);
        try {
            SecurityUtils.getInstalledContext().runSecured((Callable)new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    TaskManagerRunner.runTaskManager((Configuration)configuration, (ResourceID)resourceId);
                    return 0;
                }
            });
        }
        catch (Throwable t) {
            LOG.error("Error while starting the TaskManager", t);
            System.exit(31);
        }
    }
}

