/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mesos.runtime.clusterframework;

import com.netflix.fenzo.ConstraintEvaluator;
import com.netflix.fenzo.TaskRequest;
import com.netflix.fenzo.VMTaskFitnessCalculator;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.mesos.Utils;
import org.apache.flink.mesos.runtime.clusterframework.MesosTaskManagerParameters;
import org.apache.flink.mesos.scheduler.LaunchableTask;
import org.apache.flink.mesos.util.MesosArtifactResolver;
import org.apache.flink.mesos.util.MesosArtifactServer;
import org.apache.flink.mesos.util.MesosConfiguration;
import org.apache.flink.mesos.util.MesosResourceAllocation;
import org.apache.flink.runtime.clusterframework.ContainerSpecification;
import org.apache.flink.runtime.clusterframework.ContaineredTaskManagerParameters;
import org.apache.flink.shaded.guava18.com.google.common.collect.Iterators;
import org.apache.flink.shaded.guava18.com.google.common.collect.UnmodifiableIterator;
import org.apache.flink.util.Preconditions;
import org.apache.mesos.Protos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public class LaunchableMesosWorker
implements LaunchableTask {
    protected static final Logger LOG = LoggerFactory.getLogger(LaunchableMesosWorker.class);
    private static final String[] TM_PORT_KEYS = new String[]{"taskmanager.rpc.port", "taskmanager.data.port"};
    private final MesosArtifactResolver resolver;
    private final ContainerSpecification containerSpec;
    private final MesosTaskManagerParameters params;
    private final Protos.TaskID taskID;
    private final Request taskRequest;
    private final MesosConfiguration mesosConfiguration;

    public LaunchableMesosWorker(MesosArtifactResolver resolver, MesosTaskManagerParameters params, ContainerSpecification containerSpec, Protos.TaskID taskID, MesosConfiguration mesosConfiguration) {
        this.resolver = (MesosArtifactResolver)Preconditions.checkNotNull((Object)resolver);
        this.containerSpec = (ContainerSpecification)Preconditions.checkNotNull((Object)containerSpec);
        this.params = (MesosTaskManagerParameters)Preconditions.checkNotNull((Object)params);
        this.taskID = (Protos.TaskID)Preconditions.checkNotNull((Object)taskID);
        this.mesosConfiguration = (MesosConfiguration)Preconditions.checkNotNull((Object)mesosConfiguration);
        this.taskRequest = new Request();
    }

    public Protos.TaskID taskID() {
        return this.taskID;
    }

    @Override
    public TaskRequest taskRequest() {
        return this.taskRequest;
    }

    @Override
    public Protos.TaskInfo launch(Protos.SlaveID slaveId, MesosResourceAllocation allocation) {
        ContaineredTaskManagerParameters tmParams = this.params.containeredParameters();
        Configuration dynamicProperties = new Configuration();
        dynamicProperties.addAll(this.containerSpec.getDynamicConfiguration());
        Protos.TaskInfo.Builder taskInfo2 = Protos.TaskInfo.newBuilder().setSlaveId(slaveId).setTaskId(this.taskID).setName(this.taskID.getValue());
        Set<String> roles = this.mesosConfiguration.roles();
        taskInfo2.addAllResources(allocation.takeScalar("cpus", this.taskRequest.getCPUs(), roles));
        taskInfo2.addAllResources(allocation.takeScalar("gpus", this.taskRequest.getGPUs(), roles));
        taskInfo2.addAllResources(allocation.takeScalar("mem", this.taskRequest.getMemory(), roles));
        Protos.CommandInfo.Builder cmd = taskInfo2.getCommandBuilder();
        Protos.Environment.Builder env = cmd.getEnvironmentBuilder();
        StringBuilder jvmArgs = new StringBuilder();
        Option<String> taskManagerHostnameOption = this.params.getTaskManagerHostname();
        if (taskManagerHostnameOption.isDefined()) {
            String taskManagerHostname = MesosTaskManagerParameters.TASK_ID_PATTERN.matcher((CharSequence)taskManagerHostnameOption.get()).replaceAll(Matcher.quoteReplacement(this.taskID.getValue()));
            dynamicProperties.setString("taskmanager.hostname", taskManagerHostname);
        }
        List<Protos.Resource> portResources = allocation.takeRanges("ports", TM_PORT_KEYS.length, roles);
        taskInfo2.addAllResources(portResources);
        UnmodifiableIterator portsToAssign = Iterators.forArray((Object[])TM_PORT_KEYS);
        Utils.rangeValues(portResources).forEach(arg_0 -> LaunchableMesosWorker.lambda$launch$0(dynamicProperties, (Iterator)portsToAssign, arg_0));
        if (portsToAssign.hasNext()) {
            throw new IllegalArgumentException("insufficient # of ports assigned");
        }
        for (ContainerSpecification.Artifact artifact : this.containerSpec.getArtifacts()) {
            cmd.addUris(Utils.uri(this.resolver, artifact));
        }
        for (Map.Entry entry : this.params.containeredParameters().taskManagerEnv().entrySet()) {
            env.addVariables(Utils.variable((String)entry.getKey(), (String)entry.getValue()));
        }
        for (Map.Entry entry : this.containerSpec.getEnvironmentVariables().entrySet()) {
            env.addVariables(Utils.variable((String)entry.getKey(), (String)entry.getValue()));
        }
        env.addVariables(Utils.variable("_FLINK_CONTAINER_ID", taskInfo2.getTaskId().getValue()));
        jvmArgs.append(" -Xms").append(tmParams.taskManagerHeapSizeMB()).append("m");
        jvmArgs.append(" -Xmx").append(tmParams.taskManagerHeapSizeMB()).append("m");
        if (tmParams.taskManagerDirectMemoryLimitMB() >= 0L) {
            jvmArgs.append(" -XX:MaxDirectMemorySize=").append(tmParams.taskManagerDirectMemoryLimitMB()).append("m");
        }
        jvmArgs.append(' ').append(ContainerSpecification.formatSystemProperties((Configuration)this.containerSpec.getSystemProperties()));
        env.addVariables(Utils.variable("JVM_ARGS", jvmArgs.toString()));
        env.addVariables(Utils.variable("TASK_NAME", taskInfo2.getTaskId().getValue()));
        env.addVariables(Utils.variable("FRAMEWORK_NAME", this.mesosConfiguration.frameworkInfo().getName()));
        StringBuilder launchCommand = new StringBuilder();
        if (this.params.bootstrapCommand().isDefined()) {
            launchCommand.append((String)this.params.bootstrapCommand().get()).append(" && ");
        }
        launchCommand.append(this.params.command()).append(" ").append(ContainerSpecification.formatSystemProperties((Configuration)dynamicProperties));
        cmd.setValue(launchCommand.toString());
        Protos.ContainerInfo.Builder builder = Protos.ContainerInfo.newBuilder();
        builder.setType(Protos.ContainerInfo.Type.MESOS);
        switch (this.params.containerType()) {
            case MESOS: {
                if (!this.params.containerImageName().isDefined()) break;
                builder.setMesos(Protos.ContainerInfo.MesosInfo.newBuilder().setImage(Protos.Image.newBuilder().setType(Protos.Image.Type.DOCKER).setDocker(Protos.Image.Docker.newBuilder().setName((String)this.params.containerImageName().get()))));
                break;
            }
            case DOCKER: {
                assert (this.params.containerImageName().isDefined());
                builder.setType(Protos.ContainerInfo.Type.DOCKER).setDocker(Protos.ContainerInfo.DockerInfo.newBuilder().addAllParameters(this.params.dockerParameters()).setNetwork(Protos.ContainerInfo.DockerInfo.Network.HOST).setImage((String)this.params.containerImageName().get()));
                break;
            }
            default: {
                throw new IllegalStateException("unsupported container type");
            }
        }
        builder.addAllVolumes(this.params.containerVolumes());
        taskInfo2.setContainer(builder);
        return taskInfo2.build();
    }

    public String toString() {
        return "LaunchableMesosWorker{taskID=" + this.taskID + "taskRequest=" + this.taskRequest + '}';
    }

    static void configureArtifactServer(MesosArtifactServer server, ContainerSpecification container) throws IOException {
        for (ContainerSpecification.Artifact artifact : container.getArtifacts()) {
            server.addPath(artifact.source, artifact.dest);
        }
    }

    private static /* synthetic */ void lambda$launch$0(Configuration dynamicProperties, Iterator portsToAssign, long port) {
        dynamicProperties.setLong((String)portsToAssign.next(), port);
    }

    class Request
    implements TaskRequest {
        private final AtomicReference<TaskRequest.AssignedResources> assignedResources = new AtomicReference();

        Request() {
        }

        @Override
        public String getId() {
            return LaunchableMesosWorker.this.taskID.getValue();
        }

        @Override
        public String taskGroupName() {
            return "";
        }

        @Override
        public double getCPUs() {
            return LaunchableMesosWorker.this.params.cpus();
        }

        public double getGPUs() {
            return LaunchableMesosWorker.this.params.gpus();
        }

        @Override
        public double getMemory() {
            return LaunchableMesosWorker.this.params.containeredParameters().taskManagerTotalMemoryMB();
        }

        @Override
        public double getNetworkMbps() {
            return 0.0;
        }

        @Override
        public double getDisk() {
            return 0.0;
        }

        @Override
        public int getPorts() {
            return TM_PORT_KEYS.length;
        }

        @Override
        public Map<String, Double> getScalarRequests() {
            return Collections.singletonMap("gpus", Double.valueOf(LaunchableMesosWorker.this.params.gpus()));
        }

        @Override
        public Map<String, TaskRequest.NamedResourceSetRequest> getCustomNamedResources() {
            return Collections.emptyMap();
        }

        @Override
        public List<? extends ConstraintEvaluator> getHardConstraints() {
            return LaunchableMesosWorker.this.params.constraints();
        }

        @Override
        public List<? extends VMTaskFitnessCalculator> getSoftConstraints() {
            return null;
        }

        @Override
        public void setAssignedResources(TaskRequest.AssignedResources assignedResources) {
            this.assignedResources.set(assignedResources);
        }

        @Override
        public TaskRequest.AssignedResources getAssignedResources() {
            return this.assignedResources.get();
        }

        public String toString() {
            return "Request{cpus=" + this.getCPUs() + ", memory=" + this.getMemory() + ", gpus=" + this.getGPUs() + "}";
        }
    }
}

