/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mesos.runtime.clusterframework;

import com.netflix.fenzo.ConstraintEvaluator;
import com.netflix.fenzo.functions.Func1;
import com.netflix.fenzo.plugins.HostAttrValueConstraint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.clusterframework.ContaineredTaskManagerParameters;
import org.apache.flink.util.Preconditions;
import org.apache.mesos.Protos;
import scala.Option;

public class MesosTaskManagerParameters {
    public static final Pattern TASK_ID_PATTERN = Pattern.compile("_TASK_", 16);
    public static final ConfigOption<Integer> MESOS_RM_TASKS_SLOTS = TaskManagerOptions.NUM_TASK_SLOTS;
    public static final ConfigOption<Integer> MESOS_RM_TASKS_MEMORY_MB = ConfigOptions.key((String)"mesos.resourcemanager.tasks.mem").defaultValue((Object)1024).withDescription("Memory to assign to the Mesos workers in MB.");
    public static final ConfigOption<Double> MESOS_RM_TASKS_CPUS = ConfigOptions.key((String)"mesos.resourcemanager.tasks.cpus").defaultValue((Object)0.0).withDescription("CPUs to assign to the Mesos workers.");
    public static final ConfigOption<Integer> MESOS_RM_TASKS_GPUS = ConfigOptions.key((String)"mesos.resourcemanager.tasks.gpus").defaultValue((Object)0);
    public static final ConfigOption<String> MESOS_RM_CONTAINER_TYPE = ConfigOptions.key((String)"mesos.resourcemanager.tasks.container.type").defaultValue((Object)"mesos").withDescription("Type of the containerization used: \u201cmesos\u201d or \u201cdocker\u201d.");
    public static final ConfigOption<String> MESOS_RM_CONTAINER_IMAGE_NAME = ConfigOptions.key((String)"mesos.resourcemanager.tasks.container.image.name").noDefaultValue().withDescription("Image name to use for the container.");
    public static final ConfigOption<String> MESOS_TM_HOSTNAME = ConfigOptions.key((String)"mesos.resourcemanager.tasks.hostname").noDefaultValue();
    public static final ConfigOption<String> MESOS_TM_CMD = ConfigOptions.key((String)"mesos.resourcemanager.tasks.taskmanager-cmd").defaultValue((Object)"$FLINK_HOME/bin/mesos-taskmanager.sh");
    public static final ConfigOption<String> MESOS_TM_BOOTSTRAP_CMD = ConfigOptions.key((String)"mesos.resourcemanager.tasks.bootstrap-cmd").noDefaultValue();
    public static final ConfigOption<String> MESOS_RM_CONTAINER_VOLUMES = ConfigOptions.key((String)"mesos.resourcemanager.tasks.container.volumes").noDefaultValue().withDescription("A comma separated list of [host_path:]container_path[:RO|RW]. This allows for mounting additional volumes into your container.");
    public static final ConfigOption<String> MESOS_RM_CONTAINER_DOCKER_PARAMETERS = ConfigOptions.key((String)"mesos.resourcemanager.tasks.container.docker.parameters").noDefaultValue().withDescription("Custom parameters to be passed into docker run command when using the docker containerizer. Comma separated list of \"key=value\" pairs. The \"value\" may contain '='.");
    public static final ConfigOption<String> MESOS_CONSTRAINTS_HARD_HOSTATTR = ConfigOptions.key((String)"mesos.constraints.hard.hostattribute").noDefaultValue().withDescription("Constraints for task placement on mesos.");
    public static final String MESOS_RESOURCEMANAGER_TASKS_CONTAINER_TYPE_MESOS = "mesos";
    public static final String MESOS_RESOURCEMANAGER_TASKS_CONTAINER_TYPE_DOCKER = "docker";
    private final double cpus;
    private final int gpus;
    private final ContainerType containerType;
    private final Option<String> containerImageName;
    private final ContaineredTaskManagerParameters containeredParameters;
    private final List<Protos.Volume> containerVolumes;
    private final List<Protos.Parameter> dockerParameters;
    private final List<ConstraintEvaluator> constraints;
    private final String command;
    private final Option<String> bootstrapCommand;
    private final Option<String> taskManagerHostname;

    public MesosTaskManagerParameters(double cpus, int gpus, ContainerType containerType, Option<String> containerImageName, ContaineredTaskManagerParameters containeredParameters, List<Protos.Volume> containerVolumes, List<Protos.Parameter> dockerParameters, List<ConstraintEvaluator> constraints, String command, Option<String> bootstrapCommand, Option<String> taskManagerHostname) {
        this.cpus = cpus;
        this.gpus = gpus;
        this.containerType = (ContainerType)((Object)Preconditions.checkNotNull((Object)((Object)containerType)));
        this.containerImageName = (Option)Preconditions.checkNotNull(containerImageName);
        this.containeredParameters = (ContaineredTaskManagerParameters)Preconditions.checkNotNull((Object)containeredParameters);
        this.containerVolumes = (List)Preconditions.checkNotNull(containerVolumes);
        this.dockerParameters = (List)Preconditions.checkNotNull(dockerParameters);
        this.constraints = (List)Preconditions.checkNotNull(constraints);
        this.command = (String)Preconditions.checkNotNull((Object)command);
        this.bootstrapCommand = (Option)Preconditions.checkNotNull(bootstrapCommand);
        this.taskManagerHostname = (Option)Preconditions.checkNotNull(taskManagerHostname);
    }

    public double cpus() {
        return this.cpus;
    }

    public int gpus() {
        return this.gpus;
    }

    public ContainerType containerType() {
        return this.containerType;
    }

    public Option<String> containerImageName() {
        return this.containerImageName;
    }

    public ContaineredTaskManagerParameters containeredParameters() {
        return this.containeredParameters;
    }

    public List<Protos.Volume> containerVolumes() {
        return this.containerVolumes;
    }

    public List<Protos.Parameter> dockerParameters() {
        return this.dockerParameters;
    }

    public List<ConstraintEvaluator> constraints() {
        return this.constraints;
    }

    public Option<String> getTaskManagerHostname() {
        return this.taskManagerHostname;
    }

    public String command() {
        return this.command;
    }

    public Option<String> bootstrapCommand() {
        return this.bootstrapCommand;
    }

    public String toString() {
        return "MesosTaskManagerParameters{cpus=" + this.cpus + ", gpus=" + this.gpus + ", containerType=" + (Object)((Object)this.containerType) + ", containerImageName=" + this.containerImageName + ", containeredParameters=" + this.containeredParameters + ", containerVolumes=" + this.containerVolumes + ", dockerParameters=" + this.dockerParameters + ", constraints=" + this.constraints + ", taskManagerHostName=" + this.taskManagerHostname + ", command=" + this.command + ", bootstrapCommand=" + this.bootstrapCommand + '}';
    }

    public static MesosTaskManagerParameters create(Configuration flinkConfig) {
        ContainerType containerType;
        String containerTypeString;
        int gpus;
        List<ConstraintEvaluator> constraints = MesosTaskManagerParameters.parseConstraints(flinkConfig.getString(MESOS_CONSTRAINTS_HARD_HOSTATTR));
        ContaineredTaskManagerParameters containeredParameters = ContaineredTaskManagerParameters.create((Configuration)flinkConfig, (long)flinkConfig.getInteger(MESOS_RM_TASKS_MEMORY_MB), (int)flinkConfig.getInteger(MESOS_RM_TASKS_SLOTS));
        double cpus = flinkConfig.getDouble(MESOS_RM_TASKS_CPUS);
        if (cpus <= 0.0) {
            cpus = Math.max((double)containeredParameters.numSlots(), 1.0);
        }
        if ((gpus = flinkConfig.getInteger(MESOS_RM_TASKS_GPUS)) < 0) {
            throw new IllegalConfigurationException(MESOS_RM_TASKS_GPUS.key() + " cannot be negative");
        }
        String imageName = flinkConfig.getString(MESOS_RM_CONTAINER_IMAGE_NAME);
        switch (containerTypeString = flinkConfig.getString(MESOS_RM_CONTAINER_TYPE)) {
            case "mesos": {
                containerType = ContainerType.MESOS;
                break;
            }
            case "docker": {
                containerType = ContainerType.DOCKER;
                if (imageName != null && imageName.length() != 0) break;
                throw new IllegalConfigurationException(MESOS_RM_CONTAINER_IMAGE_NAME.key() + " must be specified for docker container type");
            }
            default: {
                throw new IllegalConfigurationException("invalid container type: " + containerTypeString);
            }
        }
        Option containerVolOpt = Option.apply((Object)flinkConfig.getString(MESOS_RM_CONTAINER_VOLUMES));
        Option dockerParamsOpt = Option.apply((Object)flinkConfig.getString(MESOS_RM_CONTAINER_DOCKER_PARAMETERS));
        List<Protos.Volume> containerVolumes = MesosTaskManagerParameters.buildVolumes((Option<String>)containerVolOpt);
        List<Protos.Parameter> dockerParameters = MesosTaskManagerParameters.buildDockerParameters((Option<String>)dockerParamsOpt);
        Option taskManagerHostname = Option.apply((Object)flinkConfig.getString(MESOS_TM_HOSTNAME));
        String tmCommand = flinkConfig.getString(MESOS_TM_CMD);
        Option tmBootstrapCommand = Option.apply((Object)flinkConfig.getString(MESOS_TM_BOOTSTRAP_CMD));
        return new MesosTaskManagerParameters(cpus, gpus, containerType, (Option<String>)Option.apply((Object)imageName), containeredParameters, containerVolumes, dockerParameters, constraints, tmCommand, (Option<String>)tmBootstrapCommand, (Option<String>)taskManagerHostname);
    }

    private static List<ConstraintEvaluator> parseConstraints(String mesosConstraints) {
        if (mesosConstraints == null || mesosConstraints.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ConstraintEvaluator> constraints = new ArrayList<ConstraintEvaluator>();
        for (String constraint : mesosConstraints.split(",")) {
            String[] constraintList;
            if (constraint.isEmpty() || (constraintList = constraint.split(":")).length != 2) continue;
            MesosTaskManagerParameters.addHostAttrValueConstraint(constraints, constraintList[0], constraintList[1]);
        }
        return constraints;
    }

    private static void addHostAttrValueConstraint(List<ConstraintEvaluator> constraints, String constraintKey, final String constraintValue) {
        constraints.add(new HostAttrValueConstraint(constraintKey, new Func1<String, String>(){

            @Override
            public String call(String s) {
                return constraintValue;
            }
        }));
    }

    public static List<Protos.Volume> buildVolumes(Option<String> containerVolumes) {
        if (containerVolumes.isEmpty()) {
            return Collections.emptyList();
        }
        String[] volumeSpecifications = ((String)containerVolumes.get()).split(",");
        ArrayList<Protos.Volume> volumes = new ArrayList<Protos.Volume>(volumeSpecifications.length);
        for (String volumeSpecification : volumeSpecifications) {
            if (volumeSpecification.trim().isEmpty()) continue;
            Protos.Volume.Builder volume = Protos.Volume.newBuilder();
            volume.setMode(Protos.Volume.Mode.RW);
            String[] parts = volumeSpecification.split(":");
            switch (parts.length) {
                case 1: {
                    volume.setContainerPath(parts[0]);
                    break;
                }
                case 2: {
                    Protos.Volume.Mode mode;
                    try {
                        mode = Protos.Volume.Mode.valueOf(parts[1].trim().toUpperCase());
                        volume.setMode(mode).setContainerPath(parts[0]);
                    }
                    catch (IllegalArgumentException e) {
                        volume.setHostPath(parts[0]).setContainerPath(parts[1]);
                    }
                    break;
                }
                case 3: {
                    Protos.Volume.Mode mode = Protos.Volume.Mode.valueOf(parts[2].trim().toUpperCase());
                    volume.setMode(mode).setHostPath(parts[0]).setContainerPath(parts[1]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("volume specification is invalid, given: " + volumeSpecification);
                }
            }
            volumes.add(volume.build());
        }
        return volumes;
    }

    public static List<Protos.Parameter> buildDockerParameters(Option<String> dockerParameters) {
        if (dockerParameters.isEmpty()) {
            return Collections.emptyList();
        }
        String[] dockerParameterSpecifications = ((String)dockerParameters.get()).split(",");
        ArrayList<Protos.Parameter> parameters = new ArrayList<Protos.Parameter>(dockerParameterSpecifications.length);
        for (String dockerParameterSpecification : dockerParameterSpecifications) {
            if (dockerParameterSpecification.trim().isEmpty()) continue;
            String[] match = dockerParameterSpecification.split("=", 2);
            if (match.length != 2) {
                throw new IllegalArgumentException("Docker parameter specification is invalid, given: " + dockerParameterSpecification);
            }
            Protos.Parameter.Builder parameter = Protos.Parameter.newBuilder();
            parameter.setKey(match[0]);
            parameter.setValue(match[1]);
            parameters.add(parameter.build());
        }
        return parameters;
    }

    public static enum ContainerType {
        MESOS,
        DOCKER;

    }
}

