/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mesos.runtime.clusterframework;

import java.io.Serializable;
import org.apache.flink.mesos.runtime.clusterframework.MesosResourceManager;
import org.apache.flink.mesos.runtime.clusterframework.store.MesosWorkerStore;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceIDRetrievable;
import org.apache.flink.util.Preconditions;

public class RegisteredMesosWorkerNode
implements Serializable,
ResourceIDRetrievable {
    private static final long serialVersionUID = 2L;
    private final MesosWorkerStore.Worker worker;

    public RegisteredMesosWorkerNode(MesosWorkerStore.Worker worker) {
        this.worker = (MesosWorkerStore.Worker)Preconditions.checkNotNull((Object)worker);
        Preconditions.checkArgument((boolean)worker.slaveID().isDefined());
        Preconditions.checkArgument((boolean)worker.hostname().isDefined());
    }

    public MesosWorkerStore.Worker getWorker() {
        return this.worker;
    }

    public ResourceID getResourceID() {
        return MesosResourceManager.extractResourceID(this.worker.taskID());
    }

    public String toString() {
        return "RegisteredMesosWorkerNode{worker=" + this.worker + '}';
    }
}

