/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mesos.runtime.clusterframework.services;

import akka.actor.ActorSystem;
import org.apache.flink.mesos.runtime.clusterframework.services.MesosServices;
import org.apache.flink.mesos.util.MesosArtifactServer;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;

public abstract class AbstractMesosServices
implements MesosServices {
    private final ActorSystem actorSystem;
    private final MesosArtifactServer artifactServer;

    protected AbstractMesosServices(ActorSystem actorSystem, MesosArtifactServer artifactServer) {
        this.actorSystem = (ActorSystem)Preconditions.checkNotNull((Object)actorSystem);
        this.artifactServer = (MesosArtifactServer)Preconditions.checkNotNull((Object)artifactServer);
    }

    @Override
    public ActorSystem getLocalActorSystem() {
        return this.actorSystem;
    }

    @Override
    public MesosArtifactServer getArtifactServer() {
        return this.artifactServer;
    }

    @Override
    public void close(boolean cleanup) throws Exception {
        Throwable exception = null;
        try {
            this.actorSystem.shutdown();
        }
        catch (Throwable t) {
            exception = ExceptionUtils.firstOrSuppressed((Throwable)t, exception);
        }
        try {
            this.artifactServer.stop();
        }
        catch (Throwable t) {
            exception = ExceptionUtils.firstOrSuppressed((Throwable)t, (Throwable)exception);
        }
        if (exception != null) {
            throw new FlinkException("Could not properly shut down the Mesos services.", exception);
        }
    }
}

