/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mesos.runtime.clusterframework.services;

import akka.actor.ActorSystem;
import java.util.UUID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.mesos.configuration.MesosOptions;
import org.apache.flink.mesos.runtime.clusterframework.services.MesosServices;
import org.apache.flink.mesos.runtime.clusterframework.services.StandaloneMesosServices;
import org.apache.flink.mesos.runtime.clusterframework.services.ZooKeeperMesosServices;
import org.apache.flink.mesos.util.MesosArtifactServer;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.jobmanager.HighAvailabilityMode;
import org.apache.flink.runtime.zookeeper.ZooKeeperUtilityFactory;

public class MesosServicesUtils {
    public static MesosServices createMesosServices(Configuration configuration, String hostname) throws Exception {
        ActorSystem localActorSystem = AkkaUtils.createLocalActorSystem((Configuration)configuration);
        MesosArtifactServer artifactServer = MesosServicesUtils.createArtifactServer(configuration, hostname);
        HighAvailabilityMode highAvailabilityMode = HighAvailabilityMode.fromConfig((Configuration)configuration);
        switch (highAvailabilityMode) {
            case NONE: {
                return new StandaloneMesosServices(localActorSystem, artifactServer);
            }
            case ZOOKEEPER: {
                String zkMesosRootPath = configuration.getString(HighAvailabilityOptions.HA_ZOOKEEPER_MESOS_WORKERS_PATH);
                ZooKeeperUtilityFactory zooKeeperUtilityFactory = new ZooKeeperUtilityFactory(configuration, zkMesosRootPath);
                return new ZooKeeperMesosServices(localActorSystem, artifactServer, zooKeeperUtilityFactory);
            }
        }
        throw new Exception("High availability mode " + highAvailabilityMode + " is not supported.");
    }

    private static MesosArtifactServer createArtifactServer(Configuration configuration, String hostname) throws Exception {
        int artifactServerPort = configuration.getInteger(MesosOptions.ARTIFACT_SERVER_PORT, 0);
        String artifactServerPrefix = UUID.randomUUID().toString();
        return new MesosArtifactServer(artifactServerPrefix, hostname, artifactServerPort, configuration);
    }
}

