/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mesos.runtime.clusterframework.services;

import akka.actor.ActorSystem;
import java.util.concurrent.Executor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.mesos.runtime.clusterframework.services.AbstractMesosServices;
import org.apache.flink.mesos.runtime.clusterframework.store.MesosWorkerStore;
import org.apache.flink.mesos.runtime.clusterframework.store.ZooKeeperMesosWorkerStore;
import org.apache.flink.mesos.util.MesosArtifactServer;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.runtime.zookeeper.RetrievableStateStorageHelper;
import org.apache.flink.runtime.zookeeper.ZooKeeperSharedCount;
import org.apache.flink.runtime.zookeeper.ZooKeeperSharedValue;
import org.apache.flink.runtime.zookeeper.ZooKeeperStateHandleStore;
import org.apache.flink.runtime.zookeeper.ZooKeeperUtilityFactory;
import org.apache.flink.runtime.zookeeper.filesystem.FileSystemStateStorageHelper;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;

public class ZooKeeperMesosServices
extends AbstractMesosServices {
    private final ZooKeeperUtilityFactory zooKeeperUtilityFactory;

    public ZooKeeperMesosServices(ActorSystem actorSystem, MesosArtifactServer artifactServer, ZooKeeperUtilityFactory zooKeeperUtilityFactory) {
        super(actorSystem, artifactServer);
        this.zooKeeperUtilityFactory = (ZooKeeperUtilityFactory)Preconditions.checkNotNull((Object)zooKeeperUtilityFactory);
    }

    @Override
    public MesosWorkerStore createMesosWorkerStore(Configuration configuration, Executor executor) throws Exception {
        FileSystemStateStorageHelper stateStorageHelper = ZooKeeperUtils.createFileSystemStateStorage((Configuration)configuration, (String)"mesosWorkerStore");
        ZooKeeperStateHandleStore zooKeeperStateHandleStore = this.zooKeeperUtilityFactory.createZooKeeperStateHandleStore("/workers", (RetrievableStateStorageHelper)stateStorageHelper, executor);
        ZooKeeperSharedValue frameworkId = this.zooKeeperUtilityFactory.createSharedValue("/frameworkId", new byte[0]);
        ZooKeeperSharedCount totalTaskCount = this.zooKeeperUtilityFactory.createSharedCount("/taskCount", 0);
        return new ZooKeeperMesosWorkerStore((ZooKeeperStateHandleStore<MesosWorkerStore.Worker>)zooKeeperStateHandleStore, frameworkId, totalTaskCount);
    }

    @Override
    public void close(boolean cleanup) throws Exception {
        Throwable exception = null;
        try {
            this.zooKeeperUtilityFactory.close(cleanup);
        }
        catch (Throwable t) {
            exception = ExceptionUtils.firstOrSuppressed((Throwable)t, exception);
        }
        try {
            super.close(cleanup);
        }
        catch (Throwable t) {
            exception = ExceptionUtils.firstOrSuppressed((Throwable)t, (Throwable)exception);
        }
        if (exception != null) {
            throw new FlinkException("Could not properly shut down the Mesos services.", exception);
        }
    }
}

