/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mesos.runtime.clusterframework.store;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Objects;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.mesos.Protos;
import scala.Option;

public interface MesosWorkerStore {
    public static final DecimalFormat TASKID_FORMAT = new DecimalFormat("taskmanager-00000");

    public void start() throws Exception;

    public void stop(boolean var1) throws Exception;

    public Option<Protos.FrameworkID> getFrameworkID() throws Exception;

    public void setFrameworkID(Option<Protos.FrameworkID> var1) throws Exception;

    public List<Worker> recoverWorkers() throws Exception;

    public Protos.TaskID newTaskID() throws Exception;

    public void putWorker(Worker var1) throws Exception;

    public boolean removeWorker(Protos.TaskID var1) throws Exception;

    public static enum WorkerState {
        New,
        Launched,
        Released;

    }

    public static class Worker
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Protos.TaskID taskID;
        private final ResourceProfile profile;
        private final Option<Protos.SlaveID> slaveID;
        private final Option<String> hostname;
        private final WorkerState state;

        private Worker(Protos.TaskID taskID, ResourceProfile profile, Option<Protos.SlaveID> slaveID, Option<String> hostname, WorkerState state) {
            this.taskID = Objects.requireNonNull(taskID, "taskID");
            this.profile = Objects.requireNonNull(profile, "profile");
            this.slaveID = Objects.requireNonNull(slaveID, "slaveID");
            this.hostname = Objects.requireNonNull(hostname, "hostname");
            this.state = Objects.requireNonNull(state, "state");
        }

        public Protos.TaskID taskID() {
            return this.taskID;
        }

        public ResourceProfile profile() {
            return this.profile;
        }

        public Option<Protos.SlaveID> slaveID() {
            return this.slaveID;
        }

        public Option<String> hostname() {
            return this.hostname;
        }

        public WorkerState state() {
            return this.state;
        }

        public static Worker newWorker(Protos.TaskID taskID) {
            return new Worker(taskID, ResourceProfile.UNKNOWN, (Option<Protos.SlaveID>)Option.empty(), (Option<String>)Option.empty(), WorkerState.New);
        }

        public static Worker newWorker(Protos.TaskID taskID, ResourceProfile profile) {
            return new Worker(taskID, profile, (Option<Protos.SlaveID>)Option.empty(), (Option<String>)Option.empty(), WorkerState.New);
        }

        public Worker launchWorker(Protos.SlaveID slaveID, String hostname) {
            return new Worker(this.taskID, this.profile, (Option<Protos.SlaveID>)Option.apply((Object)slaveID), (Option<String>)Option.apply((Object)hostname), WorkerState.Launched);
        }

        public Worker releaseWorker() {
            return new Worker(this.taskID, this.profile, this.slaveID, this.hostname, WorkerState.Released);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Worker worker = (Worker)o;
            return Objects.equals(this.taskID, worker.taskID) && Objects.equals(this.slaveID, worker.slaveID) && Objects.equals(this.hostname, worker.hostname) && Objects.equals(this.profile, worker.profile) && this.state == worker.state;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.taskID, this.slaveID, this.hostname, this.state, this.profile});
        }

        public String toString() {
            return "Worker{taskID=" + this.taskID + ", slaveID=" + this.slaveID + ", hostname=" + this.hostname + ", state=" + (Object)((Object)this.state) + ", profile=" + this.profile + '}';
        }
    }
}

