/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.mesos.runtime.clusterframework.store;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.mesos.runtime.clusterframework.store.MesosWorkerStore;
import org.apache.flink.runtime.state.RetrievableStateHandle;
import org.apache.flink.runtime.zookeeper.ZooKeeperSharedCount;
import org.apache.flink.runtime.zookeeper.ZooKeeperSharedValue;
import org.apache.flink.runtime.zookeeper.ZooKeeperStateHandleStore;
import org.apache.flink.runtime.zookeeper.ZooKeeperVersionedValue;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.mesos.Protos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;

public class ZooKeeperMesosWorkerStore
implements MesosWorkerStore {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperMesosWorkerStore.class);
    private final Object startStopLock = new Object();
    private boolean isRunning;
    private final ZooKeeperSharedValue frameworkIdInZooKeeper;
    private final ZooKeeperSharedCount totalTaskCountInZooKeeper;
    private final ZooKeeperStateHandleStore<MesosWorkerStore.Worker> workersInZooKeeper;

    public ZooKeeperMesosWorkerStore(ZooKeeperStateHandleStore<MesosWorkerStore.Worker> workersInZooKeeper, ZooKeeperSharedValue frameworkIdInZooKeeper, ZooKeeperSharedCount totalTaskCountInZooKeeper) throws Exception {
        this.workersInZooKeeper = (ZooKeeperStateHandleStore)Preconditions.checkNotNull(workersInZooKeeper, (String)"workersInZooKeeper");
        this.frameworkIdInZooKeeper = (ZooKeeperSharedValue)Preconditions.checkNotNull((Object)frameworkIdInZooKeeper, (String)"frameworkIdInZooKeeper");
        this.totalTaskCountInZooKeeper = (ZooKeeperSharedCount)Preconditions.checkNotNull((Object)totalTaskCountInZooKeeper, (String)"totalTaskCountInZooKeeper");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        Object object = this.startStopLock;
        synchronized (object) {
            if (!this.isRunning) {
                this.isRunning = true;
                this.frameworkIdInZooKeeper.start();
                this.totalTaskCountInZooKeeper.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(boolean cleanup) throws Exception {
        Object object = this.startStopLock;
        synchronized (object) {
            if (this.isRunning) {
                this.frameworkIdInZooKeeper.close();
                this.totalTaskCountInZooKeeper.close();
                if (cleanup) {
                    this.workersInZooKeeper.releaseAndTryRemoveAll();
                }
                this.isRunning = false;
            }
        }
    }

    private void verifyIsRunning() {
        Preconditions.checkState((boolean)this.isRunning, (Object)"Not running. Forgot to call start()?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Option<Protos.FrameworkID> getFrameworkID() throws Exception {
        Object object = this.startStopLock;
        synchronized (object) {
            this.verifyIsRunning();
            byte[] value = this.frameworkIdInZooKeeper.getValue();
            Option frameworkID = value.length == 0 ? Option.empty() : Option.apply((Object)Protos.FrameworkID.newBuilder().setValue(new String(value, ConfigConstants.DEFAULT_CHARSET)).build());
            return frameworkID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFrameworkID(Option<Protos.FrameworkID> frameworkID) throws Exception {
        Object object = this.startStopLock;
        synchronized (object) {
            this.verifyIsRunning();
            byte[] value = frameworkID.isDefined() ? ((Protos.FrameworkID)frameworkID.get()).getValue().getBytes(ConfigConstants.DEFAULT_CHARSET) : new byte[]{};
            this.frameworkIdInZooKeeper.setValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Protos.TaskID newTaskID() throws Exception {
        Object object = this.startStopLock;
        synchronized (object) {
            int nextCount;
            ZooKeeperVersionedValue count;
            boolean success;
            this.verifyIsRunning();
            while (!(success = this.totalTaskCountInZooKeeper.trySetCount(count = this.totalTaskCountInZooKeeper.getVersionedValue(), nextCount = (Integer)count.getValue() + 1))) {
            }
            Protos.TaskID taskID = Protos.TaskID.newBuilder().setValue(TASKID_FORMAT.format(nextCount)).build();
            return taskID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MesosWorkerStore.Worker> recoverWorkers() throws Exception {
        Object object = this.startStopLock;
        synchronized (object) {
            this.verifyIsRunning();
            List handles = this.workersInZooKeeper.getAllAndLock();
            if (handles.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<MesosWorkerStore.Worker> workers = new ArrayList<MesosWorkerStore.Worker>(handles.size());
            for (Tuple2 handle : handles) {
                MesosWorkerStore.Worker worker;
                try {
                    worker = (MesosWorkerStore.Worker)((RetrievableStateHandle)handle.f0).retrieveState();
                }
                catch (ClassNotFoundException cnfe) {
                    throw new FlinkException("Could not retrieve Mesos worker from state handle under " + (String)handle.f1 + ". This indicates that you are trying to recover from state written by an older Flink version which is not compatible. Try cleaning the state handle store.", (Throwable)cnfe);
                }
                catch (IOException ioe) {
                    throw new FlinkException("Could not retrieve Mesos worker from state handle under " + (String)handle.f1 + ". This indicates that the retrieved state handle is broken. Try cleaning the state handle store.", (Throwable)ioe);
                }
                workers.add(worker);
            }
            return workers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putWorker(MesosWorkerStore.Worker worker) throws Exception {
        Preconditions.checkNotNull((Object)worker, (String)"worker");
        String path = ZooKeeperMesosWorkerStore.getPathForWorker(worker.taskID());
        Object object = this.startStopLock;
        synchronized (object) {
            this.verifyIsRunning();
            int currentVersion = this.workersInZooKeeper.exists(path);
            if (currentVersion == -1) {
                this.workersInZooKeeper.addAndLock(path, (Serializable)worker);
                LOG.debug("Added {} in ZooKeeper.", (Object)worker);
            } else {
                this.workersInZooKeeper.replace(path, currentVersion, (Serializable)worker);
                LOG.debug("Updated {} in ZooKeeper.", (Object)worker);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeWorker(Protos.TaskID taskID) throws Exception {
        Preconditions.checkNotNull((Object)taskID, (String)"taskID");
        String path = ZooKeeperMesosWorkerStore.getPathForWorker(taskID);
        Object object = this.startStopLock;
        synchronized (object) {
            this.verifyIsRunning();
            if (this.workersInZooKeeper.exists(path) == -1) {
                LOG.debug("No such worker {} in ZooKeeper.", (Object)taskID);
                return false;
            }
            this.workersInZooKeeper.releaseAndTryRemove(path);
            LOG.debug("Removed worker {} from ZooKeeper.", (Object)taskID);
            return true;
        }
    }

    private static String getPathForWorker(Protos.TaskID taskID) {
        Preconditions.checkNotNull((Object)taskID, (String)"taskID");
        return String.format("/%s", taskID.getValue());
    }
}

